/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.hibernate.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javax.persistence.EntityManager;
import org.apache.commons.io.IOUtils;
import org.artificer.common.ArtifactContent;
import org.artificer.repository.hibernate.entity.ArtificerDocumentArtifact;
import org.artificer.repository.hibernate.file.FileManager;

public class FilesystemFileManager
implements FileManager {
    private final String path;

    public FilesystemFileManager(String path) {
        File f;
        this.path = path;
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if (!(f = new File(path)).exists()) {
            f.mkdirs();
        }
    }

    @Override
    public InputStream read(ArtificerDocumentArtifact artifact) throws Exception {
        String uuid = artifact.getUuid();
        File out = new File(this.path + uuid);
        return new FileInputStream(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void write(ArtificerDocumentArtifact artifact, ArtifactContent content, EntityManager entityManager) throws Exception {
        InputStream inputStream = null;
        try {
            File out = new File(this.path + artifact.getUuid());
            out.createNewFile();
            inputStream = content.getInputStream();
            Files.copy(content.getInputStream(), out.toPath(), StandardCopyOption.REPLACE_EXISTING);
            artifact.setContentPath(this.path + artifact.getUuid());
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            if (inputStream == null) throw throwable;
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }
}

