/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.hibernate;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.artificer.common.ArtifactContent;
import org.artificer.common.ArtifactType;
import org.artificer.common.ArtificerConfig;
import org.artificer.common.ArtificerException;
import org.artificer.common.error.ArtificerConflictException;
import org.artificer.common.error.ArtificerNotFoundException;
import org.artificer.common.error.ArtificerServerException;
import org.artificer.common.ontology.ArtificerOntology;
import org.artificer.common.ontology.ArtificerOntologyClass;
import org.artificer.common.query.RelationshipType;
import org.artificer.integration.ExtensionFactory;
import org.artificer.integration.artifactbuilder.ArtifactBuilder;
import org.artificer.integration.artifactbuilder.RelationshipContext;
import org.artificer.repository.AbstractPersistenceManager;
import org.artificer.repository.ClassificationHelper;
import org.artificer.repository.PersistenceManager;
import org.artificer.repository.hibernate.HibernateEntityFactory;
import org.artificer.repository.hibernate.HibernateRelationshipContext;
import org.artificer.repository.hibernate.HibernateRelationshipFactory;
import org.artificer.repository.hibernate.HibernateUtil;
import org.artificer.repository.hibernate.audit.ArtificerAuditEntry;
import org.artificer.repository.hibernate.audit.HibernateAuditor;
import org.artificer.repository.hibernate.data.HibernateEntityToSrampVisitor;
import org.artificer.repository.hibernate.data.SrampToHibernateEntityRelationshipsVisitor;
import org.artificer.repository.hibernate.data.SrampToHibernateEntityVisitor;
import org.artificer.repository.hibernate.entity.ArtificerArtifact;
import org.artificer.repository.hibernate.entity.ArtificerComment;
import org.artificer.repository.hibernate.entity.ArtificerDocumentArtifact;
import org.artificer.repository.hibernate.entity.ArtificerRelationship;
import org.artificer.repository.hibernate.entity.ArtificerStoredQuery;
import org.artificer.repository.hibernate.file.FileManagerFactory;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.StoredQuery;

public class HibernatePersistenceManager
extends AbstractPersistenceManager {
    private final ClassificationHelper classificationHelper = this;

    public void login(String username, String password) {
    }

    public List<BaseArtifactType> persistBatch(final List<PersistenceManager.BatchItem> items) throws ArtificerException {
        try {
            return (List)new HibernateUtil.HibernateTask<List<BaseArtifactType>>(){

                @Override
                protected List<BaseArtifactType> doExecute(EntityManager entityManager) throws Exception {
                    HibernateRelationshipFactory relationshipFactory = new HibernateRelationshipFactory();
                    ArrayList<BaseArtifactType> rval = new ArrayList<BaseArtifactType>(items.size());
                    for (PersistenceManager.BatchItem item : items) {
                        BaseArtifactType artifact = HibernatePersistenceManager.this.doPersistArtifact(item.baseArtifactType, item.content, relationshipFactory, entityManager);
                        rval.add(artifact);
                    }
                    return rval;
                }
            }.execute();
        }
        catch (ArtificerException ae) {
            throw ae;
        }
        catch (Throwable t) {
            throw new ArtificerServerException(t);
        }
    }

    public BaseArtifactType persistArtifact(BaseArtifactType srampArtifact, ArtifactContent content) throws ArtificerException {
        return this.persistArtifact(srampArtifact, content, new HibernateRelationshipFactory());
    }

    private BaseArtifactType persistArtifact(final BaseArtifactType srampArtifact, final ArtifactContent content, final HibernateRelationshipFactory relationshipFactory) throws ArtificerException {
        try {
            return (BaseArtifactType)new HibernateUtil.HibernateTask<BaseArtifactType>(){

                @Override
                protected BaseArtifactType doExecute(EntityManager entityManager) throws Exception {
                    return HibernatePersistenceManager.this.doPersistArtifact(srampArtifact, content, relationshipFactory, entityManager);
                }
            }.execute();
        }
        catch (ArtificerException ae) {
            throw ae;
        }
        catch (Throwable t) {
            throw new ArtificerServerException(t);
        }
    }

    private BaseArtifactType doPersistArtifact(BaseArtifactType srampArtifact, ArtifactContent content, HibernateRelationshipFactory relationshipFactory, EntityManager entityManager) throws Exception {
        ArtificerArtifact artificerDerivedArtifact;
        ArtifactType artifactType = ArtifactType.valueOf((BaseArtifactType)srampArtifact);
        if (StringUtils.isBlank((String)srampArtifact.getUuid())) {
            srampArtifact.setUuid(UUID.randomUUID().toString());
        } else {
            try {
                HibernateUtil.getArtifact(srampArtifact.getUuid(), entityManager, false);
                throw ArtificerConflictException.artifactConflict((String)srampArtifact.getUuid());
            }
            catch (ArtificerNotFoundException artificerNotFoundException) {
                // empty catch block
            }
        }
        List artifactBuilders = ExtensionFactory.createArtifactBuilders((BaseArtifactType)srampArtifact, (ArtifactContent)content);
        ArrayList derivedSrampArtifacts = new ArrayList();
        for (ArtifactBuilder artifactBuilder : artifactBuilders) {
            artifactBuilder.buildArtifacts(srampArtifact, content);
            derivedSrampArtifacts.addAll(artifactBuilder.getDerivedArtifacts());
        }
        ArtificerArtifact artificerArtifact = SrampToHibernateEntityVisitor.visit(srampArtifact, artifactType, this.classificationHelper);
        if (artifactType.isDocument()) {
            ArtificerDocumentArtifact artificerDocumentArtifact = (ArtificerDocumentArtifact)artificerArtifact;
            this.processDocument(artificerDocumentArtifact, content);
            if (content != null) {
                FileManagerFactory.getInstance().write(artificerDocumentArtifact, content, entityManager);
            }
        }
        entityManager.persist((Object)artificerArtifact);
        relationshipFactory.trackEntity(artificerArtifact.getUuid(), artificerArtifact);
        HashMap<BaseArtifactType, ArtificerArtifact> artificerDerivedArtifacts = new HashMap<BaseArtifactType, ArtificerArtifact>();
        for (BaseArtifactType derivedSrampArtifact : derivedSrampArtifacts) {
            ArtifactType derivedSrampArtifactType = ArtifactType.valueOf((BaseArtifactType)derivedSrampArtifact);
            artificerDerivedArtifact = SrampToHibernateEntityVisitor.visit(derivedSrampArtifact, derivedSrampArtifactType, this.classificationHelper);
            artificerDerivedArtifact.setDerived(true);
            artificerDerivedArtifact.setDerivedFrom(artificerArtifact);
            artificerArtifact.getDerivedArtifacts().add(artificerDerivedArtifact);
            artificerDerivedArtifacts.put(derivedSrampArtifact, artificerDerivedArtifact);
            entityManager.persist((Object)artificerDerivedArtifact);
            relationshipFactory.trackEntity(artificerDerivedArtifact.getUuid(), artificerDerivedArtifact);
        }
        HibernateRelationshipContext relationshipContext = new HibernateRelationshipContext(entityManager);
        for (ArtifactBuilder artifactBuilder : artifactBuilders) {
            artifactBuilder.buildRelationships((RelationshipContext)relationshipContext);
        }
        SrampToHibernateEntityRelationshipsVisitor.visit(srampArtifact, artificerArtifact, relationshipFactory, entityManager);
        for (BaseArtifactType derivedSrampArtifact : artificerDerivedArtifacts.keySet()) {
            artificerDerivedArtifact = (ArtificerArtifact)artificerDerivedArtifacts.get(derivedSrampArtifact);
            SrampToHibernateEntityRelationshipsVisitor.visit(derivedSrampArtifact, artificerDerivedArtifact, relationshipFactory, entityManager);
        }
        if (ArtificerConfig.isAuditingEnabled()) {
            entityManager.persist((Object)HibernateAuditor.createAddEntry(artificerArtifact));
            for (ArtificerArtifact derivedArtifact : artificerDerivedArtifacts.values()) {
                entityManager.persist((Object)HibernateAuditor.createAddEntry(derivedArtifact));
            }
        }
        return HibernateEntityToSrampVisitor.visit(artificerArtifact, artifactType, true);
    }

    public BaseArtifactType getArtifact(final String uuid, final ArtifactType artifactType) throws ArtificerException {
        return (BaseArtifactType)new HibernateUtil.HibernateTask<BaseArtifactType>(){

            @Override
            protected BaseArtifactType doExecute(EntityManager entityManager) throws Exception {
                try {
                    ArtificerArtifact artifact = HibernateUtil.getArtifact(uuid, entityManager, true);
                    return HibernateEntityToSrampVisitor.visit(artifact, artifactType, true);
                }
                catch (ArtificerNotFoundException e) {
                    return null;
                }
            }
        }.execute();
    }

    public InputStream getArtifactContent(final String uuid, ArtifactType artifactType) throws ArtificerException {
        return (InputStream)new HibernateUtil.HibernateTask<InputStream>(){

            @Override
            protected InputStream doExecute(EntityManager entityManager) throws Exception {
                ArtificerDocumentArtifact artifact = (ArtificerDocumentArtifact)HibernateUtil.getArtifact(uuid, entityManager, false);
                return FileManagerFactory.getInstance().read(artifact);
            }
        }.execute();
    }

    public BaseArtifactType updateArtifact(final BaseArtifactType srampArtifact, final ArtifactType artifactType) throws ArtificerException {
        ArtificerArtifact artificerArtifact = (ArtificerArtifact)new HibernateUtil.HibernateTask<ArtificerArtifact>(){

            @Override
            protected ArtificerArtifact doExecute(EntityManager entityManager) throws Exception {
                ArtificerArtifact artificerArtifact = HibernateUtil.getArtifact(srampArtifact.getUuid(), entityManager, true);
                HibernateUtil.evict(ArtificerArtifact.class, Long.valueOf(artificerArtifact.getId()), entityManager);
                HibernateAuditor differ = null;
                if (ArtificerConfig.isAuditingEnabled()) {
                    differ = new HibernateAuditor(artificerArtifact);
                }
                SrampToHibernateEntityVisitor.visit(srampArtifact, artificerArtifact, artifactType, HibernatePersistenceManager.this.classificationHelper);
                HibernateRelationshipFactory relationshipFactory = new HibernateRelationshipFactory();
                SrampToHibernateEntityRelationshipsVisitor.visit(srampArtifact, artificerArtifact, relationshipFactory, entityManager);
                if (ArtificerConfig.isAuditingEnabled()) {
                    ArtificerAuditEntry auditEntry = differ.diff(artificerArtifact);
                    entityManager.persist((Object)auditEntry);
                }
                return artificerArtifact;
            }
        }.execute();
        try {
            return HibernateEntityToSrampVisitor.visit(artificerArtifact, artifactType, true);
        }
        catch (ArtificerException ae) {
            throw ae;
        }
        catch (Throwable t) {
            throw new ArtificerServerException(t);
        }
    }

    public BaseArtifactType addComment(final String uuid, final ArtifactType artifactType, final String text) throws ArtificerException {
        return (BaseArtifactType)new HibernateUtil.HibernateTask<BaseArtifactType>(){

            @Override
            protected BaseArtifactType doExecute(EntityManager entityManager) throws Exception {
                ArtificerArtifact artifact = HibernateUtil.getArtifact(uuid, entityManager, false);
                HibernateUtil.evict(ArtificerArtifact.class, Long.valueOf(artifact.getId()), entityManager);
                ArtificerComment comment = new ArtificerComment();
                comment.setCreatedBy(HibernateEntityFactory.user());
                comment.setText(text);
                comment.setArtifact(artifact);
                entityManager.persist((Object)comment);
                return HibernateEntityToSrampVisitor.visit(artifact, artifactType, true);
            }
        }.execute();
    }

    public BaseArtifactType deleteArtifact(final String uuid, final ArtifactType artifactType, final boolean force) throws ArtificerException {
        return (BaseArtifactType)new HibernateUtil.HibernateTask<BaseArtifactType>(){

            @Override
            protected BaseArtifactType doExecute(EntityManager entityManager) throws Exception {
                ArtificerArtifact artifact = HibernateUtil.getArtifact(uuid, entityManager, false);
                HibernatePersistenceManager.this.deleteArtifact(artifact, force, entityManager);
                for (ArtificerArtifact expandedArtifact : artifact.getExpandedArtifacts()) {
                    HibernatePersistenceManager.this.deleteArtifact(expandedArtifact, force, entityManager);
                }
                return HibernateEntityToSrampVisitor.visit(artifact, artifactType, true);
            }
        }.execute();
    }

    private void deleteArtifact(ArtificerArtifact artifact, boolean force, EntityManager entityManager) throws ArtificerException {
        Query query;
        ArrayList<Long> targetedArtifacts = new ArrayList<Long>();
        targetedArtifacts.add(artifact.getId());
        for (ArtificerArtifact derivedArtifact : artifact.getDerivedArtifacts()) {
            targetedArtifacts.add(derivedArtifact.getId());
        }
        if (force) {
            query = entityManager.createQuery("SELECT r FROM ArtificerRelationship r INNER JOIN r.targets ts INNER JOIN ts.target t WHERE t.id IN :targetedArtifacts");
            query.setParameter("targetedArtifacts", targetedArtifacts);
            List relationships = query.getResultList();
            for (ArtificerRelationship relationship : relationships) {
                entityManager.remove((Object)relationship);
                HibernateUtil.evict(ArtificerRelationship.class, Long.valueOf(relationship.getId()), entityManager);
            }
        } else {
            query = entityManager.createQuery("SELECT r FROM ArtificerRelationship r INNER JOIN r.owner o INNER JOIN r.targets ts INNER JOIN ts.target t WHERE o.trashed = false AND t.id IN :targetedArtifacts AND (r.type=:type1 OR r.type=:type2)");
            query.setParameter("targetedArtifacts", targetedArtifacts);
            query.setParameter("type1", (Object)RelationshipType.GENERIC);
            query.setParameter("type2", (Object)RelationshipType.MODELED);
            if (query.getResultList().size() > 0) {
                throw ArtificerConflictException.relationshipConstraint((String)artifact.getUuid());
            }
        }
        artifact.setTrashed(true);
        HibernateUtil.evict(ArtificerArtifact.class, Long.valueOf(artifact.getId()), entityManager);
        if (ArtificerConfig.isAuditingEnabled()) {
            HibernateAuditor.createDeleteEntry(artifact);
        }
        for (ArtificerArtifact derivedArtifact : artifact.getDerivedArtifacts()) {
            derivedArtifact.setTrashed(true);
            HibernateUtil.evict(ArtificerArtifact.class, Long.valueOf(derivedArtifact.getId()), entityManager);
            if (!ArtificerConfig.isAuditingEnabled()) continue;
            HibernateAuditor.createDeleteEntry(derivedArtifact);
        }
    }

    public ArtificerOntology persistOntology(final ArtificerOntology ontology) throws ArtificerException {
        if (StringUtils.isBlank((String)ontology.getUuid())) {
            ontology.setUuid(UUID.randomUUID().toString());
        }
        new HibernateUtil.HibernateTask<Void>(){

            @Override
            protected Void doExecute(EntityManager entityManager) throws Exception {
                for (ArtificerOntologyClass rootClass : ontology.getRootClasses()) {
                    if (rootClass.getRoot() != null) continue;
                    rootClass.setRoot(ontology);
                }
                entityManager.persist((Object)ontology);
                return null;
            }
        }.execute();
        return ontology;
    }

    public ArtificerOntology getOntology(final String uuid) throws ArtificerException {
        return (ArtificerOntology)new HibernateUtil.HibernateTask<ArtificerOntology>(){

            @Override
            protected ArtificerOntology doExecute(EntityManager entityManager) throws Exception {
                return HibernateUtil.getOntology(uuid, entityManager);
            }
        }.execute();
    }

    public List<ArtificerOntology> getOntologies() throws ArtificerException {
        return (List)new HibernateUtil.HibernateTask<List<ArtificerOntology>>(){

            @Override
            protected List<ArtificerOntology> doExecute(EntityManager entityManager) throws Exception {
                Query q = entityManager.createQuery("SELECT DISTINCT o FROM ArtificerOntology o LEFT JOIN FETCH o.rootClasses ORDER BY o.label ASC");
                return q.getResultList();
            }
        }.execute();
    }

    public void updateOntology(final ArtificerOntology ontology) throws ArtificerException {
        new HibernateUtil.HibernateTask<Void>(){

            @Override
            protected Void doExecute(EntityManager entityManager) throws Exception {
                ArtificerOntology persistedOntology = HibernateUtil.getOntology(ontology.getUuid(), entityManager);
                HibernateUtil.evict(ArtificerOntology.class, Long.valueOf(ontology.getSurrogateId()), entityManager);
                ontology.setSurrogateId(persistedOntology.getSurrogateId());
                for (ArtificerOntologyClass rootClass : ontology.getRootClasses()) {
                    if (rootClass.getRoot() != null) continue;
                    rootClass.setRoot(ontology);
                }
                entityManager.merge((Object)ontology);
                return null;
            }
        }.execute();
    }

    public void deleteOntology(final String uuid) throws ArtificerException {
        new HibernateUtil.HibernateTask<Void>(){

            @Override
            protected Void doExecute(EntityManager entityManager) throws Exception {
                ArtificerOntology ontology = HibernateUtil.getOntology(uuid, entityManager);
                HibernateUtil.evict(ArtificerOntology.class, Long.valueOf(ontology.getSurrogateId()), entityManager);
                entityManager.remove((Object)ontology);
                return null;
            }
        }.execute();
    }

    public StoredQuery persistStoredQuery(final StoredQuery srampStoredQuery) throws ArtificerException {
        if (StringUtils.isBlank((String)srampStoredQuery.getQueryName())) {
            throw ArtificerConflictException.storedQueryConflict();
        }
        try {
            this.getStoredQuery(srampStoredQuery.getQueryName());
            throw ArtificerConflictException.storedQueryConflict((String)srampStoredQuery.getQueryName());
        }
        catch (ArtificerNotFoundException artificerNotFoundException) {
            new HibernateUtil.HibernateTask<Void>(){

                @Override
                protected Void doExecute(EntityManager entityManager) throws Exception {
                    ArtificerStoredQuery artificerStoredQuery = HibernateEntityFactory.storedQuery(srampStoredQuery);
                    entityManager.persist((Object)artificerStoredQuery);
                    return null;
                }
            }.execute();
            return srampStoredQuery;
        }
    }

    public void updateStoredQuery(final String queryName, final StoredQuery srampStoredQuery) throws ArtificerException {
        new HibernateUtil.HibernateTask<Void>(){

            @Override
            protected Void doExecute(EntityManager entityManager) throws Exception {
                ArtificerStoredQuery artificerStoredQuery = HibernateUtil.getStoredQuery(queryName, entityManager);
                HibernateUtil.evict(ArtificerStoredQuery.class, (Serializable)((Object)artificerStoredQuery.getQueryName()), entityManager);
                HibernateEntityFactory.processStoredQuery(artificerStoredQuery, srampStoredQuery);
                entityManager.merge((Object)artificerStoredQuery);
                return null;
            }
        }.execute();
    }

    public StoredQuery getStoredQuery(final String queryName) throws ArtificerException {
        return (StoredQuery)new HibernateUtil.HibernateTask<StoredQuery>(){

            @Override
            protected StoredQuery doExecute(EntityManager entityManager) throws Exception {
                ArtificerStoredQuery storedQuery = HibernateUtil.getStoredQuery(queryName, entityManager);
                return HibernateEntityFactory.storedQuery(storedQuery);
            }
        }.execute();
    }

    public List<StoredQuery> getStoredQueries() throws ArtificerException {
        return (List)new HibernateUtil.HibernateTask<List<StoredQuery>>(){

            @Override
            protected List<StoredQuery> doExecute(EntityManager entityManager) throws Exception {
                Query q = entityManager.createQuery("FROM ArtificerStoredQuery asq ORDER BY asq.queryName ASC");
                ((org.hibernate.Query)q.unwrap(org.hibernate.Query.class)).setCacheable(true);
                List storedQueries = q.getResultList();
                return HibernateEntityFactory.storedQueries(storedQueries);
            }
        }.execute();
    }

    public void deleteStoredQuery(final String queryName) throws ArtificerException {
        new HibernateUtil.HibernateTask<Void>(){

            @Override
            protected Void doExecute(EntityManager entityManager) throws Exception {
                ArtificerStoredQuery storedQuery = (ArtificerStoredQuery)entityManager.find(ArtificerStoredQuery.class, (Object)queryName);
                if (storedQuery == null) {
                    throw ArtificerNotFoundException.storedQueryNotFound((String)queryName);
                }
                entityManager.remove((Object)storedQuery);
                HibernateUtil.evict(ArtificerStoredQuery.class, (Serializable)((Object)storedQuery.getQueryName()), entityManager);
                return null;
            }
        }.execute();
    }

    public void printArtifactGraph(String uuid, ArtifactType type) {
    }

    public void startup() {
    }

    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processDocument(ArtificerDocumentArtifact artificerArtifact, ArtifactContent content) throws Exception {
        InputStream inputStream = null;
        try {
            if (content != null) {
                artificerArtifact.setContentSize(content.getSize());
                inputStream = content.getInputStream();
                String sha1Hash = DigestUtils.shaHex((InputStream)inputStream);
                artificerArtifact.setContentHash(sha1Hash);
            } else {
                artificerArtifact.setContentSize(0L);
                artificerArtifact.setContentHash("");
            }
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            if (inputStream == null) throw throwable;
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }
}

