/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.hibernate;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import org.artificer.common.ArtificerException;
import org.artificer.common.error.ArtificerNotFoundException;
import org.artificer.common.error.ArtificerServerException;
import org.artificer.repository.hibernate.HibernateUtil;
import org.artificer.repository.hibernate.entity.ArtificerArtifact;

public class HibernateRelationshipFactory {
    private final Map<String, ArtificerArtifact> entities = new HashMap<String, ArtificerArtifact>();

    public ArtificerArtifact createRelationship(String uuid, EntityManager entityManager) throws ArtificerException {
        try {
            ArtificerArtifact entity = this.entities.containsKey(uuid) ? this.entities.get(uuid) : HibernateUtil.getArtifact(uuid, entityManager, false);
            if (entity == null) {
                throw ArtificerNotFoundException.artifactNotFound((String)uuid);
            }
            return entity;
        }
        catch (ArtificerException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new ArtificerServerException(t);
        }
    }

    public void trackEntity(String uuid, ArtificerArtifact entity) {
        this.entities.put(uuid, entity);
    }
}

