/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.hibernate;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.Serializable;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Locale;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.apache.commons.io.IOUtils;
import org.artificer.common.ArtificerConfig;
import org.artificer.common.ArtificerException;
import org.artificer.common.error.ArtificerNotFoundException;
import org.artificer.common.ontology.ArtificerOntology;
import org.artificer.repository.hibernate.entity.ArtificerArtifact;
import org.artificer.repository.hibernate.entity.ArtificerStoredQuery;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.ejb.HibernatePersistence;
import org.hibernate.engine.spi.SessionImplementor;

public class HibernateUtil {
    private static String persistenceUnit = "Artificer";
    private static EntityManagerFactory entityManagerFactory = null;

    private static EntityManager entityManager() throws Exception {
        if (entityManagerFactory == null) {
            Map properties = ArtificerConfig.getConfigProperties((String)"hibernate");
            if (properties.containsKey("hibernate.connection.url")) {
                HibernateUtil.initHikariCP(properties);
            }
            entityManagerFactory = new HibernatePersistence().createEntityManagerFactory(persistenceUnit, properties);
            EntityManager entityManager = entityManagerFactory.createEntityManager();
            HibernateUtil.initDDL(entityManager, properties);
            return entityManager;
        }
        return entityManagerFactory.createEntityManager();
    }

    private static void initHikariCP(Map<String, Object> properties) {
        String connectionUrl = (String)properties.remove("hibernate.connection.url");
        String username = (String)properties.remove("hibernate.connection.username");
        String password = (String)properties.remove("hibernate.connection.password");
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setJdbcUrl(connectionUrl);
        hikariConfig.setUsername(username);
        hikariConfig.setPassword(password);
        hikariConfig.addDataSourceProperty("cachePrepStmts", (Object)"true");
        hikariConfig.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
        hikariConfig.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
        hikariConfig.addDataSourceProperty("useServerPrepStmts", (Object)"true");
        String dialect = (String)properties.get("hibernate.dialect");
        if (dialect != null && dialect.contains("PostgreSQL")) {
            hikariConfig.setConnectionTestQuery("SELECT 1");
        }
        HikariDataSource hikariDataSource = new HikariDataSource(hikariConfig);
        properties.put("hibernate.connection.datasource", hikariDataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initDDL(EntityManager entityManager, Map<String, Object> properties) throws Exception {
        String dialect;
        SessionImplementor session = (SessionImplementor)entityManager.getDelegate();
        Connection connection = session.connection();
        if (!HibernateUtil.hasTables(connection) && (dialect = (String)properties.get("hibernate.dialect")) != null) {
            String ddlFile = dialect.contains("PostgreSQL") ? "postgres9.sql" : (dialect.contains("MySQL") ? "mysql5.sql" : (dialect.contains("Oracle") ? "oracle10.sql" : (dialect.contains("SQLServer") ? "mssql2012.sql" : (dialect.contains("DB2") ? "db2.sql" : "h2.sql"))));
            try (Statement statement = null;){
                URL url = HibernateUtil.class.getClassLoader().getResource("ddl/" + ddlFile);
                String ddl = IOUtils.toString((URL)url);
                statement = connection.createStatement();
                statement.executeUpdate(ddl);
            }
        }
    }

    private static boolean hasTables(Connection connection) throws Exception {
        DatabaseMetaData metadata = connection.getMetaData();
        ResultSet tables = metadata.getTables(null, null, ArtificerArtifact.class.getSimpleName(), null);
        if (tables.next()) {
            return true;
        }
        tables = metadata.getTables(null, null, ArtificerArtifact.class.getSimpleName().toUpperCase(Locale.ROOT), null);
        return tables.next();
    }

    public static ArtificerArtifact getArtifact(String uuid, EntityManager entityManager, boolean fullFetch) throws ArtificerException {
        ArtificerArtifact artifact;
        Query q = entityManager.createQuery("FROM ArtificerArtifact a WHERE a.trashed = false AND a.uuid = :uuid");
        q.setParameter("uuid", (Object)uuid);
        ((org.hibernate.Query)q.unwrap(org.hibernate.Query.class)).setCacheable(true);
        try {
            artifact = (ArtificerArtifact)q.getSingleResult();
        }
        catch (NoResultException e) {
            throw ArtificerNotFoundException.artifactNotFound((String)uuid);
        }
        if (fullFetch) {
            Hibernate.initialize(artifact.getClassifiers());
            Hibernate.initialize(artifact.getComments());
            Hibernate.initialize(artifact.getNormalizedClassifiers());
            Hibernate.initialize(artifact.getRelationships());
        }
        return artifact;
    }

    public static ArtificerOntology getOntology(String uuid, EntityManager entityManager) throws ArtificerException {
        ArtificerOntology ontology;
        Query q = entityManager.createQuery("FROM ArtificerOntology a WHERE a.uuid = :uuid");
        q.setParameter("uuid", (Object)uuid);
        ((org.hibernate.Query)q.unwrap(org.hibernate.Query.class)).setCacheable(true);
        try {
            ontology = (ArtificerOntology)q.getSingleResult();
        }
        catch (NoResultException e) {
            throw ArtificerNotFoundException.ontologyNotFound((String)uuid);
        }
        Hibernate.initialize((Object)ontology.getRootClasses());
        return ontology;
    }

    public static ArtificerStoredQuery getStoredQuery(String queryName, EntityManager entityManager) throws ArtificerException {
        ArtificerStoredQuery storedQuery = (ArtificerStoredQuery)entityManager.find(ArtificerStoredQuery.class, (Object)queryName);
        if (storedQuery == null) {
            throw ArtificerNotFoundException.storedQueryNotFound((String)queryName);
        }
        return storedQuery;
    }

    public static void evict(Class clazz, Serializable id, EntityManager entityManager) {
        ((Session)entityManager.unwrap(Session.class)).getSessionFactory().getCache().evictEntity(clazz, id);
    }

    public static void setPersistenceUnit(String name) {
        persistenceUnit = name;
    }

    public static abstract class HibernateTask<T> {
        public T execute() throws ArtificerException {
            try (EntityManager entityManager = null;){
                entityManager = HibernateUtil.entityManager();
                entityManager.getTransaction().begin();
                T rtn = this.doExecute(entityManager);
                entityManager.getTransaction().commit();
                T t = rtn;
                return t;
            }
        }

        protected abstract T doExecute(EntityManager var1) throws Exception;
    }
}

