/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.hibernate.data;

import java.net.URI;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.artificer.common.ArtifactType;
import org.artificer.common.visitors.ArtifactVisitor;
import org.artificer.common.visitors.ArtifactVisitorHelper;
import org.artificer.common.visitors.HierarchicalArtifactVisitor;
import org.artificer.repository.ClassificationHelper;
import org.artificer.repository.hibernate.HibernateEntityFactory;
import org.artificer.repository.hibernate.data.HibernateEntityCreator;
import org.artificer.repository.hibernate.entity.ArtificerArtifact;
import org.artificer.repository.hibernate.entity.ArtificerDocumentArtifact;
import org.artificer.repository.hibernate.entity.ArtificerProperty;
import org.artificer.repository.hibernate.entity.ArtificerUser;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.AttributeDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ComplexTypeDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DocumentArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ElementDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.NamedWsdlDerivedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Property;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceEndpoint;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceImplementationModelType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceInstance;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceOperation;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.SimpleTypeDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.SoapAddress;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.SoapBinding;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlDerivedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XmlDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdDocument;

public class SrampToHibernateEntityVisitor
extends HierarchicalArtifactVisitor {
    private ArtificerArtifact artificerArtifact;
    private final ArtifactType artifactType;
    private final ClassificationHelper classificationHelper;

    public static ArtificerArtifact visit(BaseArtifactType srampArtifact, ArtifactType artifactType, ClassificationHelper classificationHelper) throws Exception {
        ArtificerArtifact artificerArtifact = HibernateEntityCreator.visit(artifactType);
        return SrampToHibernateEntityVisitor.visit(srampArtifact, artificerArtifact, artifactType, classificationHelper);
    }

    public static ArtificerArtifact visit(BaseArtifactType srampArtifact, ArtificerArtifact artificerArtifact, ArtifactType artifactType, ClassificationHelper classificationHelper) throws Exception {
        SrampToHibernateEntityVisitor visitor = new SrampToHibernateEntityVisitor(artificerArtifact, artifactType, classificationHelper);
        ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)srampArtifact);
        visitor.throwError();
        return artificerArtifact;
    }

    public SrampToHibernateEntityVisitor(ArtificerArtifact artificerArtifact, ArtifactType artifactType, ClassificationHelper classificationHelper) {
        this.artificerArtifact = artificerArtifact;
        this.artifactType = artifactType;
        this.classificationHelper = classificationHelper;
        artificerArtifact.getClassifiers().clear();
        artificerArtifact.getNormalizedClassifiers().clear();
        artificerArtifact.getProperties().clear();
    }

    protected void visitBase(BaseArtifactType artifact) {
        super.visitBase(artifact);
        try {
            this.updateArtifactMetaData(artifact);
            this.updateClassifications(artifact);
            this.updateArtifactProperties(artifact);
        }
        catch (Exception e) {
            this.error = e;
        }
    }

    protected void visitDocument(DocumentArtifactType artifact) {
        super.visitDocument(artifact);
        try {
            ArtificerDocumentArtifact artificerDocumentArtifact = (ArtificerDocumentArtifact)this.artificerArtifact;
            artificerDocumentArtifact.setMimeType(this.artifactType.getMimeType());
        }
        catch (Exception e) {
            this.error = e;
        }
    }

    protected void visitXmlDocument(XmlDocument artifact) {
        super.visitXmlDocument(artifact);
        this.artificerArtifact.setContentEncoding(artifact.getContentEncoding());
    }

    protected void visitWsdlDerived(WsdlDerivedArtifactType artifact) {
        super.visitWsdlDerived(artifact);
        try {
            this.createProperty("namespace", artifact.getNamespace());
        }
        catch (Exception e) {
            this.error = e;
        }
    }

    protected void visitNamedWsdlDerived(NamedWsdlDerivedArtifactType artifact) {
        super.visitNamedWsdlDerived(artifact);
        try {
            this.createProperty("ncName", artifact.getNCName());
        }
        catch (Exception e) {
            this.error = e;
        }
    }

    protected void visitExtended(ExtendedArtifactType artifact) {
        this.artificerArtifact.setType(artifact.getExtendedType());
    }

    protected void visitExtendedDocument(ExtendedDocument artifact) {
        this.artificerArtifact.setType(artifact.getExtendedType());
    }

    private void updateArtifactMetaData(BaseArtifactType srampArtifact) throws Exception {
        this.artificerArtifact.setUuid(srampArtifact.getUuid());
        this.artificerArtifact.setModel(this.artifactType.getModel());
        if (StringUtils.isBlank((String)this.artificerArtifact.getType())) {
            this.artificerArtifact.setType(this.artifactType.getType());
        }
        ArtificerUser createdBy = HibernateEntityFactory.user(srampArtifact.getCreatedBy(), srampArtifact.getCreatedTimestamp());
        this.artificerArtifact.setCreatedBy(createdBy);
        ArtificerUser modifiedBy = HibernateEntityFactory.user(srampArtifact.getLastModifiedBy(), srampArtifact.getLastModifiedTimestamp());
        this.artificerArtifact.setModifiedBy(modifiedBy);
        if (srampArtifact.getName() != null) {
            this.artificerArtifact.setName(srampArtifact.getName());
        } else {
            this.artificerArtifact.setName(srampArtifact.getClass().getSimpleName());
        }
        this.artificerArtifact.setDescription(srampArtifact.getDescription());
        this.artificerArtifact.setVersion(srampArtifact.getVersion());
    }

    private void updateClassifications(BaseArtifactType artifact) throws Exception {
        Collection classifiers = this.classificationHelper.resolveAll((Collection)artifact.getClassifiedBy());
        Collection normalizedClassifiers = this.classificationHelper.normalizeAll(classifiers);
        for (URI classifier : classifiers) {
            this.artificerArtifact.getClassifiers().add(classifier.toString());
        }
        for (URI normalizedClassifier : normalizedClassifiers) {
            this.artificerArtifact.getNormalizedClassifiers().add(normalizedClassifier.toString());
        }
    }

    private void updateArtifactProperties(BaseArtifactType artifact) throws Exception {
        for (Property property : artifact.getProperty()) {
            this.createProperty(property.getPropertyName(), property.getPropertyValue(), true);
        }
    }

    public void visit(XsdDocument artifact) {
        super.visit(artifact);
        try {
            this.createProperty("targetNamespace", artifact.getTargetNamespace());
        }
        catch (Exception e) {
            this.error = e;
        }
    }

    public void visit(AttributeDeclaration artifact) {
        super.visit(artifact);
        try {
            this.createProperty("namespace", artifact.getNamespace());
            this.createProperty("ncName", artifact.getNCName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(ComplexTypeDeclaration artifact) {
        super.visit(artifact);
        try {
            this.createProperty("namespace", artifact.getNamespace());
            this.createProperty("ncName", artifact.getNCName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(ElementDeclaration artifact) {
        super.visit(artifact);
        try {
            this.createProperty("namespace", artifact.getNamespace());
            this.createProperty("ncName", artifact.getNCName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(SimpleTypeDeclaration artifact) {
        super.visit(artifact);
        try {
            this.createProperty("namespace", artifact.getNamespace());
            this.createProperty("ncName", artifact.getNCName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(WsdlDocument artifact) {
        super.visit(artifact);
        try {
            this.createProperty("targetNamespace", artifact.getTargetNamespace());
        }
        catch (Exception e) {
            this.error = e;
        }
    }

    public void visit(SoapBinding artifact) {
        super.visit(artifact);
        try {
            this.createProperty("style", artifact.getStyle());
            this.createProperty("transport", artifact.getTransport());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(SoapAddress artifact) {
        super.visit(artifact);
        try {
            this.createProperty("soapLocation", artifact.getSoapLocation());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void visitServiceImplementation(ServiceImplementationModelType artifact) {
        super.visitServiceImplementation(artifact);
    }

    public void visit(ServiceEndpoint artifact) {
        super.visit(artifact);
        try {
            this.createProperty("url", artifact.getUrl());
            this.createProperty("end", artifact.getEnd());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(ServiceInstance artifact) {
        super.visit(artifact);
        try {
            this.createProperty("end", artifact.getEnd());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(ServiceOperation artifact) {
        super.visit(artifact);
        try {
            this.createProperty("end", artifact.getEnd());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void createProperty(String key, String value) {
        this.createProperty(key, value, false);
    }

    private void createProperty(String key, String value, boolean isCustom) {
        ArtificerProperty artificerProperty = new ArtificerProperty();
        artificerProperty.setKey(key);
        artificerProperty.setValue(value);
        artificerProperty.setCustom(isCustom);
        artificerProperty.setOwner(this.artificerArtifact);
        this.artificerArtifact.getProperties().add(artificerProperty);
    }
}

