/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.hibernate.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.artificer.common.query.RelationshipType;
import org.artificer.repository.hibernate.entity.ArtificerArtifact;
import org.artificer.repository.hibernate.entity.ArtificerTarget;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Table;

@Entity
@Table(appliesTo="ArtificerRelationship", indexes={@Index(name="relationship_name_idx", columnNames={"name"})})
@Immutable
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_ONLY)
public class ArtificerRelationship
implements Serializable {
    private long id;
    private String name;
    private RelationshipType type;
    private List<ArtificerTarget> targets = new ArrayList<ArtificerTarget>();
    private Map<String, String> otherAttributes = new HashMap<String, String>();
    private ArtificerArtifact owner;

    @Id
    @GeneratedValue
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RelationshipType getType() {
        return this.type;
    }

    public void setType(RelationshipType type) {
        this.type = type;
    }

    @OneToMany(mappedBy="relationship", orphanRemoval=true, cascade={CascadeType.ALL})
    public List<ArtificerTarget> getTargets() {
        return this.targets;
    }

    public void setTargets(List<ArtificerTarget> targets) {
        this.targets = targets;
    }

    @ElementCollection
    public Map<String, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    public void setOtherAttributes(Map<String, String> otherAttributes) {
        this.otherAttributes = otherAttributes;
    }

    @ManyToOne(optional=false)
    public ArtificerArtifact getOwner() {
        return this.owner;
    }

    public void setOwner(ArtificerArtifact owner) {
        this.owner = owner;
    }
}

