/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.hibernate.query;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.sql.Blob;
import java.sql.SQLException;
import org.apache.lucene.document.Document;
import org.apache.tika.io.IOUtils;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.WriteOutContentHandler;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.TikaMetadataProcessor;
import org.hibernate.search.bridge.TikaParseContextProvider;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.xml.sax.ContentHandler;

public class ArtificerTikaBridge
implements FieldBridge {
    private static final Log log = LoggerFactory.make();
    private static final Parser PARSER = new AutoDetectParser();
    private TikaMetadataProcessor metadataProcessor;
    private TikaParseContextProvider parseContextProvider;

    public ArtificerTikaBridge() {
        this.setMetadataProcessorClass(null);
        this.setParseContextProviderClass(null);
    }

    public void setParseContextProviderClass(Class<?> parseContextProviderClass) {
        this.parseContextProvider = parseContextProviderClass == null ? new NoopParseContextProvider() : (TikaParseContextProvider)ClassLoaderHelper.instanceFromClass(TikaParseContextProvider.class, parseContextProviderClass, (String)"Tika metadata processor");
    }

    public void setMetadataProcessorClass(Class<?> metadataProcessorClass) {
        this.metadataProcessor = metadataProcessorClass == null ? new NoopTikaMetadataProcessor() : (TikaMetadataProcessor)ClassLoaderHelper.instanceFromClass(TikaMetadataProcessor.class, metadataProcessorClass, (String)"Tika parse context provider");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (value == null) {
            return;
        }
        InputStream in = this.getInputStreamForData(value);
        try {
            Metadata metadata = this.metadataProcessor.prepareMetadata();
            ParseContext parseContext = this.parseContextProvider.getParseContext(name, value);
            StringWriter writer = new StringWriter();
            WriteOutContentHandler contentHandler = new WriteOutContentHandler((Writer)writer);
            PARSER.parse(in, (ContentHandler)contentHandler, metadata, parseContext);
            luceneOptions.addFieldToDocument(name, writer.toString(), document);
            this.metadataProcessor.set(name, value, document, luceneOptions, metadata);
        }
        catch (Exception e) {
            log.warn((Object)"Tika was unable to parse the document -- full-text search may not work properly.", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private InputStream getInputStreamForData(Object object) {
        if (object instanceof Blob) {
            try {
                return ((Blob)object).getBinaryStream();
            }
            catch (SQLException e) {
                throw log.unableToGetInputStreamFromBlob((Throwable)e);
            }
        }
        if (object instanceof byte[]) {
            byte[] data = (byte[])object;
            return new ByteArrayInputStream(data);
        }
        if (object instanceof String) {
            String path = (String)object;
            File file = new File(path);
            return this.openInputStream(file);
        }
        if (object instanceof URI) {
            URI uri = (URI)object;
            File file = new File(uri);
            return this.openInputStream(file);
        }
        throw log.unsupportedTikaBridgeType();
    }

    private FileInputStream openInputStream(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw log.fileIsADirectory(file.toString());
            }
            if (!file.canRead()) {
                throw log.fileIsNotReadable(file.toString());
            }
        } else {
            throw log.fileDoesNotExist(file.toString());
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw log.fileDoesNotExist(file.toString());
        }
    }

    private static class NoopParseContextProvider
    implements TikaParseContextProvider {
        private NoopParseContextProvider() {
        }

        public ParseContext getParseContext(String name, Object value) {
            return new ParseContext();
        }
    }

    private static class NoopTikaMetadataProcessor
    implements TikaMetadataProcessor {
        private NoopTikaMetadataProcessor() {
        }

        public Metadata prepareMetadata() {
            return new Metadata();
        }

        public void set(String name, Object value, Document document, LuceneOptions luceneOptions, Metadata metadata) {
        }
    }
}

