/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.hibernate.query;

import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.artificer.common.ArtifactType;
import org.artificer.common.ArtificerException;
import org.artificer.common.query.ArtifactSummary;
import org.artificer.common.query.xpath.ast.AndExpr;
import org.artificer.common.query.xpath.ast.Argument;
import org.artificer.common.query.xpath.ast.EqualityExpr;
import org.artificer.common.query.xpath.ast.ForwardPropertyStep;
import org.artificer.common.query.xpath.ast.FunctionCall;
import org.artificer.common.query.xpath.ast.LocationPath;
import org.artificer.common.query.xpath.ast.OrExpr;
import org.artificer.common.query.xpath.ast.PrimaryExpr;
import org.artificer.common.query.xpath.ast.RelationshipPath;
import org.artificer.common.query.xpath.ast.SubartifactSet;
import org.artificer.common.query.xpath.visitors.XPathVisitor;
import org.artificer.repository.ClassificationHelper;
import org.artificer.repository.error.QueryExecutionException;
import org.artificer.repository.hibernate.data.HibernateEntityCreator;
import org.artificer.repository.hibernate.entity.ArtificerArtifact;
import org.artificer.repository.hibernate.entity.ArtificerRelationship;
import org.artificer.repository.hibernate.entity.ArtificerTarget;
import org.artificer.repository.hibernate.i18n.Messages;
import org.artificer.repository.query.AbstractArtificerQueryVisitor;
import org.artificer.repository.query.ArtificerQueryArgs;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.FullTextQuery;
import org.hibernate.search.jpa.Search;
import org.hibernate.search.query.dsl.BooleanJunction;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;

public class ArtificerToHibernateQueryVisitor
extends AbstractArtificerQueryVisitor {
    private final EntityManager entityManager;
    private final CriteriaBuilder criteriaBuilder;
    private CriteriaQuery query = null;
    private From from = null;
    private String artifactModel = null;
    private String artifactType = null;
    private From relationshipFrom = null;
    private From targetFrom = null;
    private Subquery customPropertySubquery = null;
    private Path customPropertyValuePath = null;
    private List<Predicate> customPropertyPredicates = null;
    private String propertyContext = null;
    private Object valueContext = null;
    private List<Predicate> predicates = new ArrayList<Predicate>();
    private long totalSize;
    private static final Map<QName, String> corePropertyMap = new HashMap<QName, String>();
    private static final Map<String, String> orderByMap;

    public ArtificerToHibernateQueryVisitor(EntityManager entityManager, ClassificationHelper classificationHelper) throws ArtificerException {
        super(classificationHelper);
        this.entityManager = entityManager;
        this.criteriaBuilder = entityManager.getCriteriaBuilder();
    }

    public List<ArtifactSummary> query(ArtificerQueryArgs args) throws ArtificerException {
        String propName;
        if (this.error != null) {
            throw this.error;
        }
        this.predicates.add(this.criteriaBuilder.equal((Expression)this.from.get("trashed"), (Object)false));
        this.query.where((Expression)this.compileAnd(this.predicates));
        this.query.select((Selection)this.criteriaBuilder.count((Expression)this.from)).distinct(true);
        this.totalSize = (Long)this.entityManager.createQuery(this.query).getSingleResult();
        this.query.multiselect(new Selection[]{this.from.get("uuid"), this.from.get("name"), this.from.get("description"), this.from.get("model"), this.from.get("type"), this.from.get("derived"), this.from.get("expandedFromArchive"), this.from.get("createdBy").get("lastActionTime"), this.from.get("createdBy").get("username"), this.from.get("modifiedBy").get("lastActionTime")}).distinct(true);
        if (args.getOrderBy() != null && (propName = orderByMap.get(args.getOrderBy())) != null) {
            if (args.getOrderAscending().booleanValue()) {
                this.query.orderBy(new Order[]{this.criteriaBuilder.asc((Expression)this.path(propName))});
            } else {
                this.query.orderBy(new Order[]{this.criteriaBuilder.desc((Expression)this.path(propName))});
            }
        }
        TypedQuery q = this.entityManager.createQuery(this.query);
        args.applyPaging((Query)q);
        ((org.hibernate.Query)q.unwrap(org.hibernate.Query.class)).setCacheable(true);
        return q.getResultList();
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public void visit(org.artificer.common.query.xpath.ast.Query node) {
        this.error = null;
        this.query = this.criteriaBuilder.createQuery(ArtifactSummary.class);
        this.from = this.query.from(ArtificerArtifact.class);
        node.getArtifactSet().accept((XPathVisitor)this);
        if (node.getPredicate() != null) {
            node.getPredicate().accept((XPathVisitor)this);
        }
        if (node.getSubartifactSet() != null) {
            SubartifactSet subartifactSet = node.getSubartifactSet();
            if (subartifactSet.getRelationshipPath() != null) {
                if (subartifactSet.getRelationshipPath().getRelationshipType().equalsIgnoreCase("relatedDocument")) {
                    this.from = this.from.join("derivedFrom");
                    if (subartifactSet.getPredicate() != null) {
                        subartifactSet.getPredicate().accept((XPathVisitor)this);
                    }
                } else if (subartifactSet.getRelationshipPath().getRelationshipType().equalsIgnoreCase("expandedFromDocument") || subartifactSet.getRelationshipPath().getRelationshipType().equalsIgnoreCase("expandedFromArchive")) {
                    this.from = this.from.join("expandedFrom");
                    if (subartifactSet.getPredicate() != null) {
                        subartifactSet.getPredicate().accept((XPathVisitor)this);
                    }
                } else {
                    this.relationshipFrom = this.from.join("relationships");
                    this.targetFrom = this.relationshipFrom.join("targets");
                    this.from = this.relationshipFrom;
                    subartifactSet.getRelationshipPath().accept((XPathVisitor)this);
                    this.from = this.targetFrom.join("target");
                    this.artifactModel = null;
                    this.artifactType = null;
                    if (subartifactSet.getPredicate() != null) {
                        subartifactSet.getPredicate().accept((XPathVisitor)this);
                    }
                }
            }
            if (subartifactSet.getFunctionCall() != null) {
                throw new RuntimeException(Messages.i18n.format("XP_SUBARTIFACTSET_NOT_SUPPORTED", new Object[0]));
            }
            if (subartifactSet.getSubartifactSet() != null) {
                throw new RuntimeException(Messages.i18n.format("XP_TOPLEVEL_SUBARTIFACTSET_ONLY", new Object[0]));
            }
        }
    }

    public void visit(LocationPath node) {
        if (node.getArtifactType() != null) {
            ArtificerArtifact artifact;
            try {
                artifact = HibernateEntityCreator.visit(ArtifactType.valueOf((String)node.getArtifactType()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.query = this.criteriaBuilder.createQuery(ArtifactSummary.class);
            this.from = this.query.from(artifact.getClass());
            this.eq("type", node.getArtifactType());
            this.artifactType = node.getArtifactType();
        }
        if (node.getArtifactModel() != null) {
            this.eq("model", node.getArtifactModel());
            this.artifactModel = node.getArtifactModel();
        }
    }

    public void visit(AndExpr node) {
        if (node.getRight() == null) {
            ((OrExpr)node.getLeft()).accept((XPathVisitor)this);
        } else {
            ((OrExpr)node.getLeft()).accept((XPathVisitor)this);
            ((AndExpr)node.getRight()).accept((XPathVisitor)this);
            Predicate predicate1 = this.predicates.remove(this.predicates.size() - 1);
            Predicate predicate2 = this.predicates.remove(this.predicates.size() - 1);
            this.predicates.add(this.criteriaBuilder.and((Expression)predicate1, (Expression)predicate2));
        }
    }

    public void visit(EqualityExpr node) {
        if (node.getSubartifactSet() != null) {
            node.getSubartifactSet().accept((XPathVisitor)this);
        } else if (node.getExpr() != null) {
            node.getExpr().accept((XPathVisitor)this);
        } else if (node.getOperator() == null) {
            node.getLeft().accept((XPathVisitor)this);
            if (this.customPropertySubquery != null) {
                this.customPropertySubquery.where((Expression)this.compileAnd(this.customPropertyPredicates));
            } else if (this.propertyContext != null) {
                this.exists(this.propertyContext);
            }
        } else {
            node.getLeft().accept((XPathVisitor)this);
            ((PrimaryExpr)node.getRight()).accept((XPathVisitor)this);
            if (this.customPropertySubquery != null) {
                this.customPropertyPredicates.add(this.criteriaBuilder.equal((Expression)this.customPropertyValuePath, this.valueContext));
                this.customPropertySubquery.where((Expression)this.compileAnd(this.customPropertyPredicates));
            } else if (this.propertyContext != null) {
                this.operation(node.getOperator().symbol(), this.propertyContext, this.valueContext);
            }
            this.valueContext = null;
        }
    }

    public void visit(ForwardPropertyStep node) {
        if (node.getPropertyQName() != null) {
            QName property = node.getPropertyQName();
            if (property.getNamespaceURI() == null || "".equals(property.getNamespaceURI())) {
                property = new QName("http://docs.oasis-open.org/s-ramp/ns/s-ramp-v1.0", property.getLocalPart());
            }
            if (property.getNamespaceURI().equals("http://docs.oasis-open.org/s-ramp/ns/s-ramp-v1.0")) {
                if (corePropertyMap.containsKey(property)) {
                    this.propertyContext = corePropertyMap.get(property);
                    this.customPropertySubquery = null;
                } else {
                    this.customPropertySubquery = this.query.subquery(ArtificerArtifact.class);
                    Root customPropertyFrom = this.customPropertySubquery.from(ArtificerArtifact.class);
                    Join customPropertyJoin = customPropertyFrom.join("properties");
                    this.customPropertySubquery.select((Expression)customPropertyFrom.get("id"));
                    this.customPropertyPredicates = new ArrayList<Predicate>();
                    this.customPropertyPredicates.add(this.criteriaBuilder.equal((Expression)customPropertyFrom.get("id"), (Expression)this.from.get("id")));
                    this.customPropertyPredicates.add(this.criteriaBuilder.equal((Expression)customPropertyJoin.get("key"), (Object)property.getLocalPart()));
                    this.customPropertyValuePath = customPropertyJoin.get("value");
                    this.predicates.add(this.criteriaBuilder.exists(this.customPropertySubquery));
                    this.propertyContext = null;
                }
            } else {
                throw new RuntimeException(Messages.i18n.format("XP_INVALID_PROPERTY_NS", new Object[]{property.getNamespaceURI()}));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void visit(FunctionCall node) {
        if ("http://docs.oasis-open.org/s-ramp/ns/s-ramp-v1.0".equals(node.getFunctionName().getNamespaceURI())) {
            if (node.getFunctionName().equals(CLASSIFIED_BY_ALL_OF)) {
                this.visitClassifications(node, false, true);
                return;
            }
            if (node.getFunctionName().equals(CLASSIFIED_BY_ANY_OF)) {
                this.visitClassifications(node, true, true);
                return;
            }
            if (node.getFunctionName().equals(EXACTLY_CLASSIFIED_BY_ALL_OF)) {
                this.visitClassifications(node, false, false);
                return;
            }
            if (node.getFunctionName().equals(EXACTLY_CLASSIFIED_BY_ANY_OF)) {
                this.visitClassifications(node, true, false);
                return;
            }
            if (node.getFunctionName().equals(GET_RELATIONSHIP_ATTRIBUTE)) {
                String otherAttributeKey = this.reduceStringLiteralArgument((Argument)node.getArguments().get(1));
                this.customPropertySubquery = this.query.subquery(ArtificerRelationship.class);
                Root customPropertyFrom = this.customPropertySubquery.from(ArtificerRelationship.class);
                MapJoin customPropertyJoin = customPropertyFrom.joinMap("otherAttributes");
                this.customPropertySubquery.select((Expression)customPropertyFrom.get("id"));
                this.customPropertyPredicates = new ArrayList<Predicate>();
                this.customPropertyPredicates.add(this.criteriaBuilder.equal((Expression)customPropertyFrom.get("id"), (Expression)this.relationshipFrom.get("id")));
                this.customPropertyPredicates.add(this.criteriaBuilder.equal((Expression)customPropertyJoin.key(), (Object)otherAttributeKey));
                this.customPropertyValuePath = customPropertyJoin.value();
                this.predicates.add(this.criteriaBuilder.exists(this.customPropertySubquery));
                this.propertyContext = null;
                return;
            }
            if (node.getFunctionName().equals(GET_TARGET_ATTRIBUTE)) {
                String otherAttributeKey = this.reduceStringLiteralArgument((Argument)node.getArguments().get(1));
                this.customPropertySubquery = this.query.subquery(ArtificerTarget.class);
                Root customPropertyFrom = this.customPropertySubquery.from(ArtificerTarget.class);
                MapJoin customPropertyJoin = customPropertyFrom.joinMap("otherAttributes");
                this.customPropertySubquery.select((Expression)customPropertyFrom.get("id"));
                this.customPropertyPredicates = new ArrayList<Predicate>();
                this.customPropertyPredicates.add(this.criteriaBuilder.equal((Expression)customPropertyFrom.get("id"), (Expression)this.targetFrom.get("id")));
                this.customPropertyPredicates.add(this.criteriaBuilder.equal((Expression)customPropertyJoin.key(), (Object)otherAttributeKey));
                this.customPropertyValuePath = customPropertyJoin.value();
                this.predicates.add(this.criteriaBuilder.exists(this.customPropertySubquery));
                this.propertyContext = null;
                return;
            }
            if (!node.getFunctionName().getLocalPart().equals("matches") && !node.getFunctionName().getLocalPart().equals("not")) {
                throw new RuntimeException(Messages.i18n.format("XP_FUNC_NOT_SUPPORTED", new Object[]{node.getFunctionName().toString()}));
            }
            throw new RuntimeException(Messages.i18n.format("XP_BAD_FUNC_NS", new Object[]{node.getFunctionName().getLocalPart()}));
        }
        if (MATCHES.equals(node.getFunctionName())) {
            if (node.getArguments().size() != 2) {
                throw new RuntimeException(Messages.i18n.format("XP_MATCHES_FUNC_NUM_ARGS_ERROR", new Object[]{node.getArguments().size()}));
            }
            Argument attributeArg = (Argument)node.getArguments().get(0);
            Argument patternArg = (Argument)node.getArguments().get(1);
            String pattern = this.reduceStringLiteralArgument(patternArg);
            if (this.isFullTextSearch(attributeArg)) {
                this.fullTextSearch(pattern);
                return;
            }
            pattern = pattern.replace(".*", "%");
            ForwardPropertyStep attribute = this.reducePropertyArgument(attributeArg);
            attribute.accept((XPathVisitor)this);
            this.like(this.propertyContext, pattern);
            return;
        }
        if (!NOT.equals(node.getFunctionName())) {
            throw new RuntimeException(Messages.i18n.format("XP_FUNCTION_NOT_SUPPORTED", new Object[]{node.getFunctionName().toString()}));
        }
        if (node.getArguments().size() != 1) {
            throw new RuntimeException(Messages.i18n.format("XP_NOT_FUNC_NUM_ARGS_ERROR", new Object[]{node.getArguments().size()}));
        }
        Argument argument = (Argument)node.getArguments().get(0);
        if (argument.getExpr() != null) {
            argument.getExpr().accept((XPathVisitor)this);
            Predicate predicate = this.predicates.remove(this.predicates.size() - 1);
            this.predicates.add(this.criteriaBuilder.not((Expression)predicate));
            return;
        }
        argument.accept((XPathVisitor)this);
    }

    private void visitClassifications(FunctionCall node, boolean isOr, boolean allowSubtypes) {
        Collection classifications = this.resolveArgumentsToClassifications(node.getArguments());
        Path classifierPath = allowSubtypes ? this.from.get("normalizedClassifiers") : this.from.get("classifiers");
        ArrayList<Predicate> classifierConstraints = new ArrayList<Predicate>();
        for (URI classification : classifications) {
            classifierConstraints.add(this.criteriaBuilder.isMember((Object)classification.toString(), (Expression)classifierPath));
        }
        if (isOr) {
            this.predicates.add(this.compileOr(classifierConstraints));
        } else {
            this.predicates.add(this.compileAnd(classifierConstraints));
        }
    }

    public void visit(OrExpr node) {
        if (node.getRight() == null) {
            ((EqualityExpr)node.getLeft()).accept((XPathVisitor)this);
        } else {
            ((EqualityExpr)node.getLeft()).accept((XPathVisitor)this);
            ((OrExpr)node.getRight()).accept((XPathVisitor)this);
            Predicate predicate1 = this.predicates.remove(this.predicates.size() - 1);
            Predicate predicate2 = this.predicates.remove(this.predicates.size() - 1);
            this.predicates.add(this.criteriaBuilder.or((Expression)predicate1, (Expression)predicate2));
        }
    }

    public void visit(PrimaryExpr node) {
        if (node.getLiteral() != null) {
            if (this.customPropertySubquery == null) {
                if (this.propertyContext != null && this.propertyContext.contains("lastActionTime")) {
                    Date date = null;
                    try {
                        date = SDF.parse(node.getLiteral());
                    }
                    catch (ParseException e) {
                        this.error = new QueryExecutionException((Throwable)e);
                    }
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    this.valueContext = calendar;
                } else {
                    this.valueContext = "true".equalsIgnoreCase(node.getLiteral()) ? Boolean.valueOf(true) : ("false".equalsIgnoreCase(node.getLiteral()) ? Boolean.valueOf(false) : node.getLiteral());
                }
            } else {
                this.valueContext = node.getLiteral();
            }
        } else if (node.getNumber() != null) {
            this.valueContext = node.getNumber().doubleValue();
        } else if (node.getPropertyQName() != null) {
            throw new RuntimeException(Messages.i18n.format("XP_PROPERTY_PRIMARY_EXPR_NOT_SUPPORTED", new Object[0]));
        }
    }

    public void visit(RelationshipPath node) {
        this.eq("name", node.getRelationshipType());
    }

    public void visit(SubartifactSet node) {
        if (node.getFunctionCall() != null) {
            node.getFunctionCall().accept((XPathVisitor)this);
        } else if (node.getRelationshipPath() != null) {
            From oldRootContext = this.from;
            if (node.getRelationshipPath().getRelationshipType().equalsIgnoreCase("relatedDocument")) {
                this.from = this.from.join("derivedFrom", JoinType.LEFT);
                if (node.getPredicate() != null) {
                    node.getPredicate().accept((XPathVisitor)this);
                }
            } else if (node.getRelationshipPath().getRelationshipType().equalsIgnoreCase("expandedFromDocument") || node.getRelationshipPath().getRelationshipType().equalsIgnoreCase("expandedFromArchive")) {
                this.from = this.from.join("expandedFrom");
                if (node.getPredicate() != null) {
                    node.getPredicate().accept((XPathVisitor)this);
                }
            } else {
                List<Predicate> oldPredicates = this.predicates;
                this.predicates = new ArrayList<Predicate>();
                Subquery relationshipSubquery = this.query.subquery(ArtificerRelationship.class);
                this.relationshipFrom = relationshipSubquery.from(ArtificerRelationship.class);
                this.targetFrom = this.relationshipFrom.join("targets");
                relationshipSubquery.select((Expression)this.relationshipFrom.get("id"));
                Join relationshipOwnerJoin = this.relationshipFrom.join("owner");
                this.predicates.add(this.criteriaBuilder.equal((Expression)relationshipOwnerJoin.get("id"), (Expression)oldRootContext.get("id")));
                this.from = this.relationshipFrom;
                node.getRelationshipPath().accept((XPathVisitor)this);
                this.from = this.targetFrom.join("target");
                if (node.getPredicate() != null) {
                    node.getPredicate().accept((XPathVisitor)this);
                }
                relationshipSubquery.where((Expression)this.compileAnd(this.predicates));
                this.predicates = oldPredicates;
                this.predicates.add(this.criteriaBuilder.exists(relationshipSubquery));
            }
            this.from = oldRootContext;
            if (node.getSubartifactSet() != null) {
                throw new RuntimeException(Messages.i18n.format("XP_MULTILEVEL_SUBARTYSETS_NOT_SUPPORTED", new Object[0]));
            }
        }
    }

    private void eq(String propertyName, Object value) {
        if (Boolean.TRUE.equals(value)) {
            this.predicates.add(this.criteriaBuilder.isTrue((Expression)this.path(propertyName)));
        } else if (Boolean.FALSE.equals(value)) {
            this.predicates.add(this.criteriaBuilder.isFalse((Expression)this.path(propertyName)));
        } else {
            this.predicates.add(this.criteriaBuilder.equal((Expression)this.path(propertyName), value));
        }
    }

    private void gt(String propertyName, Object value) {
        if (value instanceof Date) {
            this.predicates.add(this.criteriaBuilder.greaterThan((Expression)this.path(propertyName), (Comparable)((Date)value)));
        } else if (value instanceof Calendar) {
            this.predicates.add(this.criteriaBuilder.greaterThan((Expression)this.path(propertyName), (Comparable)((Calendar)value)));
        } else if (value instanceof Number) {
            this.predicates.add(this.criteriaBuilder.gt((Expression)this.path(propertyName), (Number)value));
        }
    }

    private void ge(String propertyName, Object value) {
        if (value instanceof Date) {
            this.predicates.add(this.criteriaBuilder.greaterThanOrEqualTo((Expression)this.path(propertyName), (Comparable)((Date)value)));
        } else if (value instanceof Calendar) {
            this.predicates.add(this.criteriaBuilder.greaterThanOrEqualTo((Expression)this.path(propertyName), (Comparable)((Calendar)value)));
        } else if (value instanceof Number) {
            this.predicates.add(this.criteriaBuilder.ge((Expression)this.path(propertyName), (Number)value));
        }
    }

    private void lt(String propertyName, Object value) {
        if (value instanceof Date) {
            this.predicates.add(this.criteriaBuilder.lessThan((Expression)this.path(propertyName), (Comparable)((Date)value)));
        } else if (value instanceof Calendar) {
            this.predicates.add(this.criteriaBuilder.lessThan((Expression)this.path(propertyName), (Comparable)((Calendar)value)));
        } else if (value instanceof Number) {
            this.predicates.add(this.criteriaBuilder.lt((Expression)this.path(propertyName), (Number)value));
        }
    }

    private void le(String propertyName, Object value) {
        if (value instanceof Date) {
            this.predicates.add(this.criteriaBuilder.lessThanOrEqualTo((Expression)this.path(propertyName), (Comparable)((Date)value)));
        } else if (value instanceof Calendar) {
            this.predicates.add(this.criteriaBuilder.lessThanOrEqualTo((Expression)this.path(propertyName), (Comparable)((Calendar)value)));
        } else if (value instanceof Number) {
            this.predicates.add(this.criteriaBuilder.le((Expression)this.path(propertyName), (Number)value));
        }
    }

    private void like(String propertyName, Object value) {
        this.predicates.add(this.criteriaBuilder.like((Expression)this.path(propertyName), (String)value));
    }

    private void ne(String propertyName, Object value) {
        this.predicates.add(this.criteriaBuilder.notEqual((Expression)this.path(propertyName), value));
    }

    private void operation(String operator, String propertyName, Object value) {
        if ("=".equalsIgnoreCase(operator)) {
            this.eq(propertyName, value);
        } else if (">".equalsIgnoreCase(operator)) {
            this.gt(propertyName, value);
        } else if (">=".equalsIgnoreCase(operator)) {
            this.ge(propertyName, value);
        } else if ("<".equalsIgnoreCase(operator)) {
            this.lt(propertyName, value);
        } else if ("<=".equalsIgnoreCase(operator)) {
            this.le(propertyName, value);
        } else if ("like".equalsIgnoreCase(operator)) {
            this.like(propertyName, value);
        } else if ("<>".equalsIgnoreCase(operator)) {
            this.ne(propertyName, value);
        }
    }

    private void fullTextSearch(String query) {
        FullTextEntityManager fullTextEntityManager = Search.getFullTextEntityManager((EntityManager)this.entityManager);
        QueryBuilder qb = fullTextEntityManager.getSearchFactory().buildQueryBuilder().forEntity(ArtificerArtifact.class).get();
        BooleanJunction junction = qb.bool();
        junction.must(qb.keyword().onField("trashed").matching((Object)false).createQuery());
        junction.must(((TermMatchingContext)((TermMatchingContext)qb.keyword().onFields(new String[]{"description", "name", "comments.text", "properties.key", "properties.value"}).andField("content").ignoreFieldBridge()).andField("contentPath").ignoreFieldBridge()).matching((Object)query).createQuery());
        if (StringUtils.isNotBlank((String)this.artifactModel)) {
            junction.must(qb.keyword().onField("model").matching((Object)this.artifactModel).createQuery());
        }
        if (StringUtils.isNotBlank((String)this.artifactType)) {
            junction.must(qb.keyword().onField("type").matching((Object)this.artifactType).createQuery());
        }
        FullTextQuery fullTextQuery = fullTextEntityManager.createFullTextQuery(junction.createQuery(), new Class[]{ArtificerArtifact.class});
        fullTextQuery.setProjection(new String[]{"id"});
        List results = fullTextQuery.getResultList();
        ArrayList<Predicate> searchResults = new ArrayList<Predicate>();
        for (int i = 0; i < results.size(); i += 1000) {
            List subResults = results.size() > i + 1000 ? results.subList(i, i + 1000 - 1) : results;
            Object[] ids = new Long[subResults.size()];
            for (int j = 0; j < subResults.size(); ++j) {
                Object[] result = (Object[])subResults.get(j);
                ids[j] = (Long)result[0];
            }
            searchResults.add(this.from.get("id").in(ids));
        }
        if (searchResults.size() > 0) {
            this.predicates.add(this.compileOr(searchResults));
        }
    }

    private void exists(String propertyName) {
        this.predicates.add(this.criteriaBuilder.isNotNull((Expression)this.path(propertyName)));
    }

    private Predicate compileAnd(List<Predicate> constraints) {
        if (constraints.size() == 0) {
            return null;
        }
        if (constraints.size() == 1) {
            return constraints.get(0);
        }
        return this.criteriaBuilder.and((Expression)constraints.get(0), (Expression)this.compileAnd(constraints.subList(1, constraints.size())));
    }

    private Predicate compileOr(List<Predicate> constraints) {
        if (constraints.size() == 0) {
            return null;
        }
        if (constraints.size() == 1) {
            return constraints.get(0);
        }
        return this.criteriaBuilder.or((Expression)constraints.get(0), (Expression)this.compileOr(constraints.subList(1, constraints.size())));
    }

    public Path path(String propertyName) {
        if (propertyName.contains(".")) {
            String[] split = propertyName.split("\\.");
            Path path = this.from.get(split[0]);
            if (split.length > 1) {
                for (int i = 1; i < split.length; ++i) {
                    path = path.get(split[i]);
                }
            }
            return path;
        }
        return this.from.get(propertyName);
    }

    static {
        corePropertyMap.put(new QName("http://docs.oasis-open.org/s-ramp/ns/s-ramp-v1.0", "createdBy"), "createdBy.username");
        corePropertyMap.put(new QName("http://docs.oasis-open.org/s-ramp/ns/s-ramp-v1.0", "createdTimestamp"), "createdBy.lastActionTime");
        corePropertyMap.put(new QName("http://docs.oasis-open.org/s-ramp/ns/s-ramp-v1.0", "version"), "version");
        corePropertyMap.put(new QName("http://docs.oasis-open.org/s-ramp/ns/s-ramp-v1.0", "uuid"), "uuid");
        corePropertyMap.put(new QName("http://docs.oasis-open.org/s-ramp/ns/s-ramp-v1.0", "lastModifiedTimestamp"), "modifiedBy.lastActionTime");
        corePropertyMap.put(new QName("http://docs.oasis-open.org/s-ramp/ns/s-ramp-v1.0", "lastModifiedBy"), "modifiedBy.username");
        corePropertyMap.put(new QName("http://docs.oasis-open.org/s-ramp/ns/s-ramp-v1.0", "description"), "description");
        corePropertyMap.put(new QName("http://docs.oasis-open.org/s-ramp/ns/s-ramp-v1.0", "name"), "name");
        corePropertyMap.put(new QName("http://docs.oasis-open.org/s-ramp/ns/s-ramp-v1.0", "contentType"), "contentType");
        corePropertyMap.put(new QName("http://docs.oasis-open.org/s-ramp/ns/s-ramp-v1.0", "contentSize"), "contentSize");
        corePropertyMap.put(new QName("http://docs.oasis-open.org/s-ramp/ns/s-ramp-v1.0", "contentHash"), "contentHash");
        corePropertyMap.put(new QName("http://docs.oasis-open.org/s-ramp/ns/s-ramp-v1.0", "contentEncoding"), "contentEncoding");
        corePropertyMap.put(new QName("http://docs.oasis-open.org/s-ramp/ns/s-ramp-v1.0", "extendedType"), "extendedType");
        corePropertyMap.put(new QName("http://docs.oasis-open.org/s-ramp/ns/s-ramp-v1.0", "derived"), "derived");
        corePropertyMap.put(new QName("http://docs.oasis-open.org/s-ramp/ns/s-ramp-v1.0", "expandedFromArchive"), "expandedFromArchive");
        orderByMap = new HashMap<String, String>();
        orderByMap.put("createdBy", "createdBy.username");
        orderByMap.put("version", "version");
        orderByMap.put("uuid", "uuid");
        orderByMap.put("createdTimestamp", "createdBy.lastActionTime");
        orderByMap.put("lastModifiedTimestamp", "modifiedBy.lastActionTime");
        orderByMap.put("lastModifiedBy", "modifiedBy.username");
        orderByMap.put("name", "name");
    }
}

