/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.hibernate.query;

import java.util.List;
import javax.persistence.EntityManager;
import org.artificer.common.ArtificerException;
import org.artificer.common.query.ArtifactSummary;
import org.artificer.common.query.xpath.ast.Query;
import org.artificer.common.query.xpath.visitors.XPathVisitor;
import org.artificer.repository.ClassificationHelper;
import org.artificer.repository.RepositoryProviderFactory;
import org.artificer.repository.error.QueryExecutionException;
import org.artificer.repository.hibernate.HibernatePersistenceManager;
import org.artificer.repository.hibernate.HibernateUtil;
import org.artificer.repository.hibernate.i18n.Messages;
import org.artificer.repository.hibernate.query.ArtificerToHibernateQueryVisitor;
import org.artificer.repository.query.AbstractArtificerQueryImpl;
import org.artificer.repository.query.ArtificerQueryArgs;
import org.artificer.repository.query.PagedResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateQuery
extends AbstractArtificerQueryImpl {
    private static final Logger LOG = LoggerFactory.getLogger(HibernatePersistenceManager.class);
    private EntityManager entityManager = null;

    public HibernateQuery(String xpathTemplate, ArtificerQueryArgs args) {
        super(xpathTemplate, args);
    }

    public HibernateQuery(String xpathTemplate) {
        super(xpathTemplate, new ArtificerQueryArgs());
    }

    public HibernateQuery(String xpathTemplate, EntityManager entityManager) {
        this(xpathTemplate);
        this.entityManager = entityManager;
    }

    protected PagedResult<ArtifactSummary> executeQuery(final Query queryModel) throws ArtificerException {
        try {
            if (this.entityManager != null) {
                return this.executeQuery(queryModel, this.entityManager);
            }
            return (PagedResult)new HibernateUtil.HibernateTask<PagedResult<ArtifactSummary>>(){

                @Override
                protected PagedResult<ArtifactSummary> doExecute(EntityManager entityManager) throws Exception {
                    return HibernateQuery.this.executeQuery(queryModel, entityManager);
                }
            }.execute();
        }
        catch (ArtificerException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new QueryExecutionException(t);
        }
    }

    private PagedResult<ArtifactSummary> executeQuery(Query queryModel, EntityManager entityManager) throws Exception {
        ArtificerToHibernateQueryVisitor visitor = new ArtificerToHibernateQueryVisitor(entityManager, (ClassificationHelper)RepositoryProviderFactory.persistenceManager());
        queryModel.accept((XPathVisitor)visitor);
        long startTime = System.currentTimeMillis();
        List<ArtifactSummary> artifacts = visitor.query(this.args);
        long totalSize = visitor.getTotalSize();
        long endTime = System.currentTimeMillis();
        LOG.debug(Messages.i18n.format("QUERY_EXECUTED_IN", new Object[]{endTime - startTime}));
        return new PagedResult(artifacts, this.xpathTemplate, totalSize, this.args);
    }
}

