/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.test;

import java.io.InputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.artificer.common.ArtifactContent;
import org.artificer.common.ArtifactType;
import org.artificer.common.ArtificerException;
import org.artificer.common.ArtificerModelUtils;
import org.artificer.common.audit.AuditUtils;
import org.artificer.common.ontology.ArtificerOntology;
import org.artificer.common.ontology.ArtificerOntologyClass;
import org.artificer.repository.query.PagedResult;
import org.artificer.repository.test.AbstractAuditingPersistenceTest;
import org.jboss.downloads.artificer._2013.auditing.AuditEntry;
import org.jboss.downloads.artificer._2013.auditing.AuditItemType;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Document;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdDocument;

@FixMethodOrder(value=MethodSorters.DEFAULT)
public class AuditTest
extends AbstractAuditingPersistenceTest {
    @BeforeClass
    public static void enableAuditing() {
        System.setProperty("artificer.config.auditing.enabled", "true");
        System.setProperty("artificer.config.auditing.enabled-derived", "true");
    }

    @Test
    public void testCreatedBy() throws Exception {
        BaseArtifactType artifact = this.createArtifact(null, new String[0]);
        Assert.assertEquals(Document.class, artifact.getClass());
        Assert.assertEquals((Object)"junituser", (Object)artifact.getCreatedBy());
    }

    @Test
    public void testLastModifiedBy() throws Exception {
        BaseArtifactType artifact = this.createArtifact(null, new String[0]);
        artifact.setDescription("New description of the artifact.");
        this.persistenceManager.updateArtifact(artifact, ArtifactType.Document());
        artifact = this.persistenceManager.getArtifact(artifact.getUuid(), ArtifactType.Document());
        Assert.assertEquals((Object)"junituser", (Object)artifact.getCreatedBy());
        Assert.assertEquals((Object)"junituser", (Object)artifact.getLastModifiedBy());
    }

    @Test
    public void testCreateAuditEntry() throws Exception {
        BaseArtifactType artifact = this.createArtifact(null, new String[0]);
        PagedResult auditEntries = this.auditManager.getArtifactAuditEntries(artifact.getUuid());
        Assert.assertNotNull((Object)auditEntries);
        Assert.assertEquals((long)1L, (long)auditEntries.getTotalSize());
        AuditEntry entry = (AuditEntry)auditEntries.getResults().get(0);
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((Object)"artifact:add".toString(), (Object)entry.getType());
        Assert.assertEquals((Object)"junituser", (Object)entry.getWho());
        List items = entry.getAuditItem();
        Assert.assertNotNull((Object)entry);
        Assert.assertFalse((boolean)items.isEmpty());
        Assert.assertEquals((long)1L, (long)items.size());
        AuditItemType item = (AuditItemType)items.get(0);
        Assert.assertEquals((Object)"property:added", (Object)item.getType());
        List properties = item.getProperty();
        Assert.assertNotNull((Object)properties);
        Assert.assertFalse((boolean)properties.isEmpty());
        Assert.assertEquals((long)2L, (long)properties.size());
    }

    @Test
    public void testCreateAuditEntryWithCustomProperties() throws Exception {
        BaseArtifactType artifact = this.createArtifact(null, "hello", "world", "foo", "bar");
        PagedResult auditEntries = this.auditManager.getArtifactAuditEntries(artifact.getUuid());
        Assert.assertNotNull((Object)auditEntries);
        Assert.assertEquals((long)1L, (long)auditEntries.getTotalSize());
        AuditEntry entry = (AuditEntry)auditEntries.getResults().get(0);
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((Object)"artifact:add".toString(), (Object)entry.getType());
        Assert.assertEquals((Object)"junituser", (Object)entry.getWho());
        List items = entry.getAuditItem();
        Assert.assertNotNull((Object)entry);
        Assert.assertFalse((boolean)items.isEmpty());
        Assert.assertEquals((long)1L, (long)items.size());
        AuditItemType item = this.getAuditItem(items, "property:added");
        Assert.assertEquals((Object)"property:added", (Object)item.getType());
        List properties = item.getProperty();
        Assert.assertNotNull((Object)properties);
        Assert.assertFalse((boolean)properties.isEmpty());
        Assert.assertEquals((long)4L, (long)properties.size());
    }

    @Test
    public void testCreateAuditEntryWithClassifiers() throws Exception {
        this.createOntology();
        BaseArtifactType artifact = this.createArtifact(Collections.singleton("urn:example.org/world#China"), new String[0]);
        PagedResult auditEntries = this.auditManager.getArtifactAuditEntries(artifact.getUuid());
        Assert.assertNotNull((Object)auditEntries);
        Assert.assertEquals((long)1L, (long)auditEntries.getTotalSize());
        AuditEntry entry = (AuditEntry)auditEntries.getResults().get(0);
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((Object)"artifact:add".toString(), (Object)entry.getType());
        Assert.assertEquals((Object)"junituser", (Object)entry.getWho());
        List items = entry.getAuditItem();
        Assert.assertNotNull((Object)entry);
        Assert.assertFalse((boolean)items.isEmpty());
        Assert.assertEquals((long)2L, (long)items.size());
        AuditItemType item = this.getAuditItem(items, "classifier:added");
        Assert.assertEquals((Object)"classifier:added", (Object)item.getType());
        List properties = item.getProperty();
        Assert.assertNotNull((Object)properties);
        Assert.assertFalse((boolean)properties.isEmpty());
        Assert.assertEquals((long)1L, (long)properties.size());
    }

    @Test
    public void testUpdateAuditEntry() throws Exception {
        String value;
        String name;
        BaseArtifactType artifact = this.createArtifact(null, "hello", "world");
        this.createArtifact(null, new String[0]);
        artifact.setName("S-RAMP Press Release");
        artifact.setDescription("Sample description.");
        ArtificerModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"foo", (String)"bar");
        ArtificerModelUtils.unsetCustomProperty((BaseArtifactType)artifact, (String)"hello");
        this.persistenceManager.updateArtifact(artifact, ArtifactType.Document());
        int expectedEntries = 2;
        PagedResult entries = this.auditManager.getArtifactAuditEntries(artifact.getUuid());
        Assert.assertNotNull((Object)entries);
        Assert.assertEquals((long)expectedEntries, (long)entries.getTotalSize());
        AuditEntry entry = (AuditEntry)entries.getResults().get(0);
        Assert.assertNotNull((Object)entry.getUuid());
        Assert.assertEquals((Object)"artifact:update", (Object)entry.getType());
        Assert.assertNotNull((Object)entry.getWhen());
        Assert.assertEquals((Object)"junituser", (Object)entry.getWho());
        String updateEntryUuid = entry.getUuid();
        entry = (AuditEntry)entries.getResults().get(1);
        Assert.assertNotNull((Object)entry.getUuid());
        Assert.assertEquals((Object)"artifact:add", (Object)entry.getType());
        Assert.assertNotNull((Object)entry.getWhen());
        Assert.assertEquals((Object)"junituser", (Object)entry.getWho());
        AuditEntry auditEntry = this.auditManager.getArtifactAuditEntry(artifact.getUuid(), entry.getUuid());
        Assert.assertEquals((Object)"artifact:add", (Object)auditEntry.getType());
        Assert.assertNotNull((Object)auditEntry.getWhen());
        Assert.assertEquals((Object)"junituser", (Object)auditEntry.getWho());
        List auditItems = auditEntry.getAuditItem();
        Assert.assertNotNull((Object)auditItems);
        AuditItemType auditItem = AuditUtils.getAuditItem((AuditEntry)auditEntry, (String)"property:added");
        Assert.assertNotNull((Object)auditItem);
        Assert.assertEquals((Object)"property:added", (Object)auditItem.getType());
        List properties = auditItem.getProperty();
        for (AuditItemType.Property property : properties) {
            Assert.assertNotNull((Object)property);
            String name2 = property.getName();
            String value2 = property.getValue();
            if (name2.equals("name")) {
                Assert.assertEquals((Object)"s-ramp-press-release.pdf", (Object)value2);
                continue;
            }
            if (name2.equals("description")) {
                Assert.assertEquals((Object)"Sample description.", (Object)value2);
                continue;
            }
            if (name2.equals("hello")) {
                Assert.assertEquals((Object)"world", (Object)value2);
                continue;
            }
            Assert.fail((String)("No assertion for audited property: " + name2));
        }
        Assert.assertEquals((long)3L, (long)properties.size());
        auditEntry = this.auditManager.getArtifactAuditEntry(artifact.getUuid(), updateEntryUuid);
        Assert.assertEquals((Object)"artifact:update", (Object)auditEntry.getType());
        Assert.assertNotNull((Object)auditEntry.getWhen());
        Assert.assertEquals((Object)"junituser", (Object)auditEntry.getWho());
        auditItems = auditEntry.getAuditItem();
        Assert.assertNotNull((Object)auditItems);
        Assert.assertEquals((long)3L, (long)auditItems.size());
        AuditItemType propAddedItem = AuditUtils.getAuditItem((AuditEntry)auditEntry, (String)"property:added");
        AuditItemType propChangedItem = AuditUtils.getAuditItem((AuditEntry)auditEntry, (String)"property:changed");
        AuditItemType propRemovedItem = AuditUtils.getAuditItem((AuditEntry)auditEntry, (String)"property:removed");
        Assert.assertNotNull((Object)propAddedItem);
        Assert.assertNotNull((Object)propChangedItem);
        Assert.assertNotNull((Object)propRemovedItem);
        Assert.assertEquals((Object)"property:changed", (Object)propChangedItem.getType());
        properties = propChangedItem.getProperty();
        for (AuditItemType.Property property : properties) {
            Assert.assertNotNull((Object)property);
            name = property.getName();
            value = property.getValue();
            if (name.equals("name")) {
                Assert.assertEquals((Object)"S-RAMP Press Release", (Object)value);
                continue;
            }
            Assert.fail((String)("No assertion for audited property: " + name));
        }
        Assert.assertEquals((long)1L, (long)properties.size());
        Assert.assertEquals((Object)"property:added", (Object)propAddedItem.getType());
        properties = propAddedItem.getProperty();
        for (AuditItemType.Property property : properties) {
            Assert.assertNotNull((Object)property);
            name = property.getName();
            value = property.getValue();
            if (name.equals("foo")) {
                Assert.assertEquals((Object)"bar", (Object)value);
                continue;
            }
            Assert.fail((String)("No assertion for audited property: " + name));
        }
        Assert.assertEquals((long)1L, (long)properties.size());
        Assert.assertEquals((Object)"property:removed", (Object)propRemovedItem.getType());
        properties = propRemovedItem.getProperty();
        for (AuditItemType.Property property : properties) {
            Assert.assertNotNull((Object)property);
            name = property.getName();
            if (name.equals("hello")) continue;
            Assert.fail((String)("No assertion for audited property: " + name));
        }
        Assert.assertEquals((long)1L, (long)properties.size());
        entries = this.auditManager.getUserAuditEntries("junituser");
        Assert.assertNotNull((Object)entries);
        Assert.assertEquals((long)3L, (long)entries.getTotalSize());
        this.persistenceManager.printArtifactGraph(artifact.getUuid(), ArtifactType.Document());
    }

    @Test
    public void testWithDerivedArtifacts() throws Exception {
        BaseArtifactType artifact = this.createXsdArtifact();
        PagedResult entries = this.auditManager.getArtifactAuditEntries(artifact.getUuid());
        Assert.assertNotNull((Object)entries);
        Assert.assertEquals((long)1L, (long)entries.getTotalSize());
        entries = this.auditManager.getUserAuditEntries("junituser");
        Assert.assertNotNull((Object)entries);
        Assert.assertEquals((long)7L, (long)entries.getTotalSize());
    }

    @Test
    public void testCustomAuditEntry() throws Exception {
        DatatypeFactory dtFactory = DatatypeFactory.newInstance();
        BaseArtifactType artifact = this.createXsdArtifact();
        XMLGregorianCalendar now = dtFactory.newXMLGregorianCalendar((GregorianCalendar)Calendar.getInstance());
        AuditEntry auditEntry = new AuditEntry();
        auditEntry.setType("junit:test1");
        auditEntry.setWhen(now);
        auditEntry.setWho("junituser");
        AuditItemType item = AuditUtils.getOrCreateAuditItem((AuditEntry)auditEntry, (String)"junit:item");
        AuditUtils.setAuditItemProperty((AuditItemType)item, (String)"foo", (String)"bar");
        AuditUtils.setAuditItemProperty((AuditItemType)item, (String)"hello", (String)"world");
        String auditEntryUuid = this.auditManager.addAuditEntry(artifact.getUuid(), auditEntry).getUuid();
        AuditEntry re = this.auditManager.getArtifactAuditEntry(artifact.getUuid(), auditEntryUuid);
        Assert.assertNotNull((Object)re);
        Assert.assertNotNull((Object)re.getUuid());
        Assert.assertEquals((Object)"junituser", (Object)re.getWho());
        Assert.assertEquals((long)1L, (long)re.getAuditItem().size());
        Assert.assertEquals((Object)"junit:item", (Object)((AuditItemType)re.getAuditItem().iterator().next()).getType());
        Assert.assertEquals((long)2L, (long)((AuditItemType)re.getAuditItem().iterator().next()).getProperty().size());
    }

    private BaseArtifactType createArtifact(Set<String> classifiers, String ... args) throws Exception {
        String artifactFileName = "s-ramp-press-release.pdf";
        InputStream pdf = this.getClass().getResourceAsStream("/sample-files/core/" + artifactFileName);
        Document document = new Document();
        document.setName(artifactFileName);
        document.setArtifactType(BaseArtifactEnum.DOCUMENT);
        document.setDescription("Sample description.");
        if (classifiers != null) {
            for (String classifier : classifiers) {
                document.getClassifiedBy().add(classifier);
            }
        }
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; i += 2) {
                String propName = args[i];
                String propVal = args[i + 1];
                ArtificerModelUtils.setCustomProperty((BaseArtifactType)document, (String)propName, (String)propVal);
            }
        }
        BaseArtifactType artifact = this.persistenceManager.persistArtifact((BaseArtifactType)document, new ArtifactContent(artifactFileName, pdf));
        Assert.assertNotNull((Object)artifact);
        this.log.info("persisted s-ramp-press-release.pdf, returned artifact uuid=" + artifact.getUuid());
        return artifact;
    }

    private BaseArtifactType createXsdArtifact() throws Exception {
        String artifactFileName = "PO.xsd";
        InputStream content = this.getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        XsdDocument document = new XsdDocument();
        document.setName(artifactFileName);
        document.setArtifactType(BaseArtifactEnum.XSD_DOCUMENT);
        BaseArtifactType artifact = this.persistenceManager.persistArtifact((BaseArtifactType)document, new ArtifactContent(artifactFileName, content));
        Assert.assertNotNull((Object)artifact);
        this.log.info("persisted PO.xsd, returned artifact uuid=" + artifact.getUuid());
        return artifact;
    }

    private String createOntology() throws ArtificerException {
        ArtificerOntology ontology = new ArtificerOntology();
        ontology.setBase("urn:example.org/world");
        ontology.setLabel("World Ontology");
        ontology.setComment("This is my test ontology.");
        ArtificerOntologyClass world = this.createClass(ontology, null, "World", "World", "The entire world");
        ArtificerOntologyClass asia = this.createClass(ontology, world, "Asia", "Asia", null);
        ArtificerOntologyClass europe = this.createClass(ontology, world, "Europe", "Europe", "Two world wars");
        ArtificerOntologyClass japan = this.createClass(ontology, asia, "Japan", "Japan", "Samurai *and* ninja?  Not fair.");
        ArtificerOntologyClass china = this.createClass(ontology, asia, "China", "China", "Gunpowder!");
        ArtificerOntologyClass uk = this.createClass(ontology, europe, "UnitedKingdom", "United Kingdom", "The food could be better");
        ArtificerOntologyClass germany = this.createClass(ontology, europe, "Germany", "Germany", "The fatherland");
        ontology.getRootClasses().add(world);
        world.getChildren().add(asia);
        world.getChildren().add(europe);
        asia.getChildren().add(japan);
        asia.getChildren().add(china);
        europe.getChildren().add(uk);
        europe.getChildren().add(germany);
        String uuid = this.persistenceManager.persistOntology(ontology).getUuid();
        return uuid;
    }

    private ArtificerOntologyClass createClass(ArtificerOntology ontology, ArtificerOntologyClass parent, String id, String label, String comment) {
        ArtificerOntologyClass rval = ontology.createClass(id);
        rval.setParent(parent);
        rval.setComment(comment);
        rval.setLabel(label);
        return rval;
    }

    private AuditItemType getAuditItem(List<AuditItemType> items, String type) {
        if (items == null) {
            return null;
        }
        for (AuditItemType auditItemType : items) {
            if (!auditItemType.getType().equals(type.toString())) continue;
            return auditItemType;
        }
        return null;
    }
}

