/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.test;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.artificer.common.ontology.ArtificerOntology;
import org.artificer.common.ontology.ArtificerOntologyClass;
import org.artificer.repository.test.AbstractNoAuditingPersistenceTest;
import org.junit.Assert;
import org.junit.Test;

public class OntologyPersistenceTest
extends AbstractNoAuditingPersistenceTest {
    @Test
    public void testPersistOntology_Empty() throws Exception {
        ArtificerOntology ontology = new ArtificerOntology();
        ontology.setBase("urn:example.org/test1");
        ontology.setLabel("Test Ontology #1");
        ontology.setComment("This is my first test ontology.");
        String uuid = this.persistenceManager.persistOntology(ontology).getUuid();
        Assert.assertNotNull((Object)uuid);
        ArtificerOntology actual = this.persistenceManager.getOntology(uuid);
        Assert.assertEquals((Object)ontology.getUuid(), (Object)actual.getUuid());
        Assert.assertEquals((Object)ontology.getBase(), (Object)actual.getBase());
        Assert.assertEquals((Object)ontology.getLabel(), (Object)actual.getLabel());
        Assert.assertEquals((Object)ontology.getComment(), (Object)actual.getComment());
        Assert.assertEquals((Object)ontology.getId(), (Object)actual.getId());
    }

    @Test
    public void testPersistOntology_Full() throws Exception {
        ArtificerOntology ontology = new ArtificerOntology();
        ontology.setBase("urn:example.org/test2");
        ontology.setLabel("Test Ontology #2");
        ontology.setComment("This is my second test ontology.");
        ArtificerOntologyClass world = this.createClass(ontology, null, "World", "World", "The entire world");
        ArtificerOntologyClass asia = this.createClass(ontology, world, "Asia", "Asia", null);
        ArtificerOntologyClass europe = this.createClass(ontology, world, "Europe", "Europe", "Two world wars");
        ArtificerOntologyClass japan = this.createClass(ontology, asia, "Japan", "Japan", "Samurai *and* ninja?  Not fair.");
        ArtificerOntologyClass china = this.createClass(ontology, asia, "China", "China", "Gunpowder!");
        ArtificerOntologyClass uk = this.createClass(ontology, europe, "UnitedKingdom", "United Kingdom", "The food could be better");
        ArtificerOntologyClass germany = this.createClass(ontology, europe, "Germany", "Germany", "The fatherland");
        ontology.getRootClasses().add(world);
        world.getChildren().add(asia);
        world.getChildren().add(europe);
        asia.getChildren().add(japan);
        asia.getChildren().add(china);
        europe.getChildren().add(uk);
        europe.getChildren().add(germany);
        String uuid = this.persistenceManager.persistOntology(ontology).getUuid();
        Assert.assertNotNull((Object)uuid);
        ArtificerOntology actual = this.persistenceManager.getOntology(uuid);
        Assert.assertEquals((Object)ontology.getUuid(), (Object)actual.getUuid());
        Assert.assertEquals((Object)ontology.getBase(), (Object)actual.getBase());
        Assert.assertEquals((Object)ontology.getLabel(), (Object)actual.getLabel());
        Assert.assertEquals((Object)ontology.getComment(), (Object)actual.getComment());
        Assert.assertEquals((Object)ontology.getId(), (Object)actual.getId());
        Assert.assertEquals((long)1L, (long)actual.getRootClasses().size());
        ArtificerOntologyClass actualWorld = (ArtificerOntologyClass)actual.getRootClasses().get(0);
        Assert.assertEquals((Object)world.getUri(), (Object)actualWorld.getUri());
        Assert.assertEquals((Object)world.getLabel(), (Object)actualWorld.getLabel());
        Assert.assertEquals((Object)world.getComment(), (Object)actualWorld.getComment());
        Assert.assertEquals((Object)world.getId(), (Object)actualWorld.getId());
        Assert.assertNull((Object)actualWorld.getParent());
        Assert.assertEquals((long)2L, (long)actualWorld.getChildren().size());
        ArtificerOntologyClass actualAsia = (ArtificerOntologyClass)actualWorld.getChildren().get(0);
        Assert.assertEquals((Object)asia.getUri(), (Object)actualAsia.getUri());
        Assert.assertEquals((Object)asia.getLabel(), (Object)actualAsia.getLabel());
        Assert.assertEquals((Object)asia.getComment(), (Object)actualAsia.getComment());
        Assert.assertEquals((Object)asia.getId(), (Object)actualAsia.getId());
        Assert.assertNotNull((Object)actualAsia.getParent());
        Assert.assertEquals((Object)actualWorld, (Object)actualAsia.getParent());
        Assert.assertEquals((long)2L, (long)actualAsia.getChildren().size());
        ArtificerOntologyClass actualJapan = (ArtificerOntologyClass)actualAsia.getChildren().get(0);
        Assert.assertEquals((Object)japan.getUri(), (Object)actualJapan.getUri());
        Assert.assertEquals((Object)japan.getLabel(), (Object)actualJapan.getLabel());
        Assert.assertEquals((Object)japan.getComment(), (Object)actualJapan.getComment());
        Assert.assertEquals((Object)japan.getId(), (Object)actualJapan.getId());
        Assert.assertNotNull((Object)actualJapan.getParent());
        Assert.assertEquals((Object)actualAsia, (Object)actualJapan.getParent());
        Assert.assertEquals((long)0L, (long)actualJapan.getChildren().size());
        HashSet<URI> expectedJapanNormalized = new HashSet<URI>();
        expectedJapanNormalized.add(new URI(actualWorld.getUri()));
        expectedJapanNormalized.add(new URI(actualAsia.getUri()));
        expectedJapanNormalized.add(new URI(actualJapan.getUri()));
        Assert.assertEquals(expectedJapanNormalized, (Object)actualJapan.normalize());
    }

    @Test
    public void testGetOntologies() throws Exception {
        List ontologies = this.persistenceManager.getOntologies();
        Assert.assertNotNull((Object)ontologies);
        Assert.assertEquals((long)0L, (long)ontologies.size());
        ArtificerOntology ontology = new ArtificerOntology();
        ontology.setBase("urn:example.org/test3");
        ontology.setLabel("Test Ontology #3");
        ontology.setComment("This is my third test ontology.");
        ArtificerOntologyClass world = this.createClass(ontology, null, "World", "World", "The entire world");
        ArtificerOntologyClass asia = this.createClass(ontology, world, "Asia", "Asia", null);
        ArtificerOntologyClass europe = this.createClass(ontology, world, "Europe", "Europe", "Two world wars");
        ArtificerOntologyClass japan = this.createClass(ontology, asia, "Japan", "Japan", "Samurai *and* ninja?  Not fair.");
        ArtificerOntologyClass china = this.createClass(ontology, asia, "China", "China", "Gunpowder!");
        ArtificerOntologyClass uk = this.createClass(ontology, europe, "UnitedKingdom", "United Kingdom", "The food could be better");
        ArtificerOntologyClass germany = this.createClass(ontology, europe, "Germany", "Germany", "The fatherland");
        ontology.getRootClasses().add(world);
        world.getChildren().add(asia);
        world.getChildren().add(europe);
        asia.getChildren().add(japan);
        asia.getChildren().add(china);
        europe.getChildren().add(uk);
        europe.getChildren().add(germany);
        this.persistenceManager.persistOntology(ontology).getUuid();
        ontologies = this.persistenceManager.getOntologies();
        Assert.assertNotNull((Object)ontologies);
        Assert.assertEquals((long)1L, (long)ontologies.size());
        ArtificerOntology actual = (ArtificerOntology)ontologies.get(0);
        Assert.assertEquals((Object)ontology.getUuid(), (Object)actual.getUuid());
        Assert.assertEquals((Object)ontology.getBase(), (Object)actual.getBase());
        Assert.assertEquals((Object)ontology.getLabel(), (Object)actual.getLabel());
        Assert.assertEquals((Object)ontology.getComment(), (Object)actual.getComment());
        Assert.assertEquals((Object)ontology.getId(), (Object)actual.getId());
        Assert.assertEquals((long)1L, (long)actual.getRootClasses().size());
        ontology = new ArtificerOntology();
        ontology.setBase("urn:example.org/test4");
        ontology.setLabel("Test Ontology #4");
        ArtificerOntologyClass colors = this.createClass(ontology, null, "Colors", "Colors", null);
        ArtificerOntologyClass numbers = this.createClass(ontology, null, "Numbers", "Numbers", null);
        ArtificerOntologyClass red = this.createClass(ontology, colors, "Red", "Red", null);
        ArtificerOntologyClass green = this.createClass(ontology, colors, "Green", "Green", null);
        ArtificerOntologyClass blue = this.createClass(ontology, colors, "Blue", "Blue", null);
        ArtificerOntologyClass one = this.createClass(ontology, numbers, "One", "One", null);
        ArtificerOntologyClass two = this.createClass(ontology, numbers, "Two", "Two", null);
        ArtificerOntologyClass three = this.createClass(ontology, numbers, "Three", "Three", null);
        ontology.getRootClasses().add(colors);
        ontology.getRootClasses().add(numbers);
        colors.getChildren().add(red);
        colors.getChildren().add(green);
        colors.getChildren().add(blue);
        numbers.getChildren().add(one);
        numbers.getChildren().add(two);
        numbers.getChildren().add(three);
        this.persistenceManager.persistOntology(ontology).getUuid();
        ontologies = this.persistenceManager.getOntologies();
        Assert.assertNotNull((Object)ontologies);
        Assert.assertEquals((long)2L, (long)ontologies.size());
    }

    @Test
    public void testDeleteOntologies() throws Exception {
        List ontologies = this.persistenceManager.getOntologies();
        Assert.assertNotNull((Object)ontologies);
        Assert.assertEquals((long)0L, (long)ontologies.size());
        ArtificerOntology ontology = new ArtificerOntology();
        ontology.setBase("urn:example.org/test6");
        ontology.setLabel("Test Ontology #6");
        ontology.setComment("This is my sixth test ontology.");
        ArtificerOntologyClass world = this.createClass(ontology, null, "World", "World", "The entire world");
        ArtificerOntologyClass asia = this.createClass(ontology, world, "Asia", "Asia", null);
        ArtificerOntologyClass japan = this.createClass(ontology, asia, "Japan", "Japan", "Samurai *and* ninja?  Not fair.");
        ArtificerOntologyClass china = this.createClass(ontology, asia, "China", "China", "Gunpowder!");
        ontology.getRootClasses().add(world);
        world.getChildren().add(asia);
        asia.getChildren().add(japan);
        asia.getChildren().add(china);
        this.persistenceManager.persistOntology(ontology).getUuid();
        ontologies = this.persistenceManager.getOntologies();
        Assert.assertNotNull((Object)ontologies);
        Assert.assertEquals((long)1L, (long)ontologies.size());
        ontology = new ArtificerOntology();
        ontology.setBase("urn:example.org/test4");
        ontology.setLabel("Test Ontology #4");
        ArtificerOntologyClass colors = this.createClass(ontology, null, "Colors", "Colors", null);
        ArtificerOntologyClass red = this.createClass(ontology, colors, "Red", "Red", null);
        ArtificerOntologyClass green = this.createClass(ontology, colors, "Green", "Green", null);
        ArtificerOntologyClass blue = this.createClass(ontology, colors, "Blue", "Blue", null);
        ontology.getRootClasses().add(colors);
        colors.getChildren().add(red);
        colors.getChildren().add(green);
        colors.getChildren().add(blue);
        this.persistenceManager.persistOntology(ontology).getUuid();
        ontologies = this.persistenceManager.getOntologies();
        Assert.assertNotNull((Object)ontologies);
        Assert.assertEquals((long)2L, (long)ontologies.size());
        this.persistenceManager.deleteOntology(ontology.getUuid());
        ontologies = this.persistenceManager.getOntologies();
        Assert.assertNotNull((Object)ontologies);
        Assert.assertEquals((long)1L, (long)ontologies.size());
    }

    @Test
    public void testUpdate() throws Exception {
        ArtificerOntology ontology = new ArtificerOntology();
        ontology.setBase("urn:example.org/test2");
        ontology.setLabel("Test Ontology #2");
        ontology.setComment("This is my second test ontology.");
        ArtificerOntologyClass world = this.createClass(ontology, null, "World", "World", "The entire world");
        ArtificerOntologyClass asia = this.createClass(ontology, world, "Asia", "Asia", null);
        ArtificerOntologyClass europe = this.createClass(ontology, world, "Europe", "Europe", "Two world wars");
        ArtificerOntologyClass japan = this.createClass(ontology, asia, "Japan", "Japan", "Samurai *and* ninja?  Not fair.");
        ArtificerOntologyClass china = this.createClass(ontology, asia, "China", "China", "Gunpowder!");
        ArtificerOntologyClass uk = this.createClass(ontology, europe, "UnitedKingdom", "United Kingdom", "The food could be better");
        ArtificerOntologyClass germany = this.createClass(ontology, europe, "Germany", "Germany", "The fatherland");
        ontology.getRootClasses().add(world);
        world.getChildren().add(asia);
        world.getChildren().add(europe);
        asia.getChildren().add(japan);
        asia.getChildren().add(china);
        europe.getChildren().add(uk);
        europe.getChildren().add(germany);
        String uuid = this.persistenceManager.persistOntology(ontology).getUuid();
        Assert.assertNotNull((Object)uuid);
        ArtificerOntology actual = this.persistenceManager.getOntology(uuid);
        Assert.assertEquals((Object)ontology.getUuid(), (Object)actual.getUuid());
        Assert.assertEquals((Object)ontology.getBase(), (Object)actual.getBase());
        Assert.assertEquals((Object)ontology.getLabel(), (Object)actual.getLabel());
        Assert.assertEquals((Object)ontology.getComment(), (Object)actual.getComment());
        Assert.assertEquals((Object)ontology.getId(), (Object)actual.getId());
        Assert.assertEquals((long)1L, (long)actual.getRootClasses().size());
        ArtificerOntologyClass actualWorld = (ArtificerOntologyClass)actual.getRootClasses().get(0);
        Assert.assertEquals((Object)world.getUri(), (Object)actualWorld.getUri());
        Assert.assertEquals((Object)world.getLabel(), (Object)actualWorld.getLabel());
        Assert.assertEquals((Object)world.getComment(), (Object)actualWorld.getComment());
        Assert.assertEquals((Object)world.getId(), (Object)actualWorld.getId());
        Assert.assertNull((Object)actualWorld.getParent());
        Assert.assertEquals((long)2L, (long)actualWorld.getChildren().size());
        ArtificerOntologyClass actualAsia = (ArtificerOntologyClass)actualWorld.getChildren().get(0);
        Assert.assertEquals((Object)asia.getUri(), (Object)actualAsia.getUri());
        Assert.assertEquals((Object)asia.getLabel(), (Object)actualAsia.getLabel());
        Assert.assertEquals((Object)asia.getComment(), (Object)actualAsia.getComment());
        Assert.assertEquals((Object)asia.getId(), (Object)actualAsia.getId());
        Assert.assertNotNull((Object)actualAsia.getParent());
        Assert.assertEquals((Object)actualWorld, (Object)actualAsia.getParent());
        Assert.assertEquals((long)2L, (long)actualAsia.getChildren().size());
        ArtificerOntologyClass actualJapan = (ArtificerOntologyClass)actualAsia.getChildren().get(0);
        Assert.assertEquals((Object)japan.getUri(), (Object)actualJapan.getUri());
        Assert.assertEquals((Object)japan.getLabel(), (Object)actualJapan.getLabel());
        Assert.assertEquals((Object)japan.getComment(), (Object)actualJapan.getComment());
        Assert.assertEquals((Object)japan.getId(), (Object)actualJapan.getId());
        Assert.assertNotNull((Object)actualJapan.getParent());
        Assert.assertEquals((Object)actualAsia, (Object)actualJapan.getParent());
        Assert.assertEquals((long)0L, (long)actualJapan.getChildren().size());
        ArtificerOntologyClass northAmerica = this.createClass(ontology, world, "NorthAmerica", "North America", null);
        ArtificerOntologyClass sweden = this.createClass(ontology, europe, "Sweden", "Sweden", "Bork bork bork");
        ArtificerOntologyClass usa = this.createClass(ontology, northAmerica, "USA", "USA", "Cheeseburger, cheeseburger, cheeseburger...no Pepsi, Coke");
        ArtificerOntologyClass mexico = this.createClass(ontology, northAmerica, "Mexico", "Mexico", null);
        world.getChildren().remove(asia);
        world.getChildren().add(northAmerica);
        northAmerica.getChildren().add(usa);
        northAmerica.getChildren().add(mexico);
        europe.getChildren().remove(germany);
        europe.getChildren().add(sweden);
        this.persistenceManager.updateOntology(ontology);
        actual = this.persistenceManager.getOntology(uuid);
        Map<String, ArtificerOntologyClass> all = this.index((ArtificerOntologyClass)actual.getRootClasses().get(0));
        Assert.assertEquals((long)6L, (long)all.size());
        Assert.assertTrue((boolean)all.containsKey("NorthAmerica"));
        Assert.assertTrue((boolean)all.containsKey("USA"));
        Assert.assertTrue((boolean)all.containsKey("Mexico"));
        Assert.assertTrue((boolean)all.containsKey("Europe"));
        Assert.assertTrue((boolean)all.containsKey("UnitedKingdom"));
        Assert.assertTrue((boolean)all.containsKey("Sweden"));
        Assert.assertFalse((boolean)all.containsKey("Germany"));
        Assert.assertFalse((boolean)all.containsKey("Asia"));
        Assert.assertFalse((boolean)all.containsKey("China"));
        Assert.assertFalse((boolean)all.containsKey("Japan"));
    }

    private ArtificerOntologyClass createClass(ArtificerOntology ontology, ArtificerOntologyClass parent, String id, String label, String comment) {
        ArtificerOntologyClass rval = ontology.createClass(id);
        rval.setParent(parent);
        rval.setComment(comment);
        rval.setLabel(label);
        return rval;
    }

    private Map<String, ArtificerOntologyClass> index(ArtificerOntologyClass actualWorld) {
        HashMap<String, ArtificerOntologyClass> all = new HashMap<String, ArtificerOntologyClass>();
        List children = actualWorld.getChildren();
        for (ArtificerOntologyClass class1 : children) {
            all.put(class1.getId(), class1);
            all.putAll(this.index(class1));
        }
        return all;
    }
}

