/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.test;

import java.io.InputStream;
import java.util.HashSet;
import org.artificer.common.ArtifactContent;
import org.artificer.common.ArtifactType;
import org.artificer.common.ArtificerModelUtils;
import org.artificer.common.error.ArtificerConflictException;
import org.artificer.common.error.ArtificerNotFoundException;
import org.artificer.repository.query.ArtificerQuery;
import org.artificer.repository.query.PagedResult;
import org.artificer.repository.test.AbstractNoAuditingPersistenceTest;
import org.junit.Assert;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Comment;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Document;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DocumentArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Property;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Relationship;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Target;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XmlDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdDocument;

public class PersistenceTest
extends AbstractNoAuditingPersistenceTest {
    @Test
    public void testPersistArtifact_PDF() throws Exception {
        String artifactFileName = "s-ramp-press-release.pdf";
        InputStream pdf = this.getClass().getResourceAsStream("/sample-files/core/" + artifactFileName);
        Document document = new Document();
        document.setName(artifactFileName);
        document.setArtifactType(BaseArtifactEnum.DOCUMENT);
        BaseArtifactType artifact = this.persistenceManager.persistArtifact((BaseArtifactType)document, new ArtifactContent(artifactFileName, pdf));
        Assert.assertNotNull((Object)artifact);
        this.log.info("persisted s-ramp-press-release.pdf, returned artifact uuid=" + artifact.getUuid());
        if (this.log.isDebugEnabled()) {
            this.persistenceManager.printArtifactGraph(artifact.getUuid(), ArtifactType.Document());
        }
        Assert.assertEquals(Document.class, artifact.getClass());
        Assert.assertEquals((Object)new Long(18873L), (Object)((DocumentArtifactType)artifact).getContentSize());
        Assert.assertEquals((Object)"4ee67f4c9f12ebe58c0c6d55d20d9dab91d8ab39", (Object)((DocumentArtifactType)artifact).getContentHash());
    }

    @Test
    public void testPersistDuplicateArtifact() throws Exception {
        String artifactFileName = "s-ramp-press-release.pdf";
        InputStream pdf = this.getClass().getResourceAsStream("/sample-files/core/" + artifactFileName);
        Document document = new Document();
        document.setName(artifactFileName);
        document.setArtifactType(BaseArtifactEnum.DOCUMENT);
        document.setUuid("12345");
        BaseArtifactType artifact = this.persistenceManager.persistArtifact((BaseArtifactType)document, new ArtifactContent(artifactFileName, pdf));
        Assert.assertNotNull((Object)artifact);
        pdf = this.getClass().getResourceAsStream("/sample-files/core/" + artifactFileName);
        document = new Document();
        document.setName(artifactFileName + "-2");
        document.setArtifactType(BaseArtifactEnum.DOCUMENT);
        document.setUuid("12345");
        try {
            this.persistenceManager.persistArtifact((BaseArtifactType)document, new ArtifactContent(artifactFileName, pdf));
            Assert.fail((String)"Expected an ArtifactAlreadyExistsException.");
        }
        catch (ArtificerConflictException e) {
            Assert.assertEquals((Object)"Artifact with UUID 12345 already exists.", (Object)e.getMessage());
        }
        pdf = this.getClass().getResourceAsStream("/sample-files/core/" + artifactFileName);
        ExtendedArtifactType extendedArtifact = new ExtendedArtifactType();
        extendedArtifact.setArtifactType(BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE);
        extendedArtifact.setExtendedType("FooArtifactType");
        extendedArtifact.setName("MyExtendedArtifact");
        extendedArtifact.setUuid("12345");
        try {
            this.persistenceManager.persistArtifact((BaseArtifactType)document, new ArtifactContent(artifactFileName, pdf));
            Assert.fail((String)"Expected an ArtifactAlreadyExistsException.");
        }
        catch (ArtificerConflictException e) {
            Assert.assertEquals((Object)"Artifact with UUID 12345 already exists.", (Object)e.getMessage());
        }
    }

    @Test
    public void testPersistArtifactPO_XSD() throws Exception {
        String artifactFileName = "PO.xsd";
        InputStream POXsd = this.getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        XsdDocument document = new XsdDocument();
        document.setName(artifactFileName);
        document.setArtifactType(BaseArtifactEnum.XSD_DOCUMENT);
        BaseArtifactType artifact = this.persistenceManager.persistArtifact((BaseArtifactType)document, new ArtifactContent(artifactFileName, POXsd));
        Assert.assertNotNull((Object)artifact);
        this.log.info("persisted PO.xsd, returned artifact uuid=" + artifact.getUuid());
        if (this.log.isDebugEnabled()) {
            this.persistenceManager.printArtifactGraph(artifact.getUuid(), ArtifactType.XsdDocument());
        }
        Assert.assertEquals(XsdDocument.class, artifact.getClass());
        long size = ((DocumentArtifactType)artifact).getContentSize();
        Assert.assertTrue((size >= 2376L ? 1 : 0) != 0);
    }

    @Test
    public void testPersistArtifactPO_XML() throws Exception {
        String artifactFileName = "PO.xml";
        InputStream POXml = this.getClass().getResourceAsStream("/sample-files/core/" + artifactFileName);
        Document document = new Document();
        document.setName(artifactFileName);
        document.setArtifactType(BaseArtifactEnum.XML_DOCUMENT);
        BaseArtifactType artifact = this.persistenceManager.persistArtifact((BaseArtifactType)document, new ArtifactContent(artifactFileName, POXml));
        Assert.assertNotNull((Object)artifact);
        this.log.info("persisted PO.xml, returned artifact uuid=" + artifact.getUuid());
        if (this.log.isDebugEnabled()) {
            this.persistenceManager.printArtifactGraph(artifact.getUuid(), ArtifactType.XmlDocument());
        }
        Assert.assertEquals(XmlDocument.class, artifact.getClass());
        long size = ((DocumentArtifactType)artifact).getContentSize();
        Assert.assertTrue((size >= 825L ? 1 : 0) != 0);
    }

    @Test
    public void testPersistArtifact_ExtendedArtifactType() throws Exception {
        ExtendedArtifactType extendedArtifact = new ExtendedArtifactType();
        extendedArtifact.setArtifactType(BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE);
        extendedArtifact.setExtendedType("FooArtifactType");
        extendedArtifact.setName("MyExtendedArtifact");
        extendedArtifact.setDescription("This is a simple description for testing.");
        BaseArtifactType artifact = this.persistenceManager.persistArtifact((BaseArtifactType)extendedArtifact, null);
        Assert.assertNotNull((Object)artifact);
        this.log.info("persisted extended artifact, returned artifact uuid=" + artifact.getUuid());
        if (this.log.isDebugEnabled()) {
            this.persistenceManager.printArtifactGraph(artifact.getUuid(), ArtifactType.XmlDocument());
        }
        Assert.assertEquals(ExtendedArtifactType.class, artifact.getClass());
        String name = ((ExtendedArtifactType)artifact).getName();
        String description = ((ExtendedArtifactType)artifact).getDescription();
        Assert.assertEquals((Object)"MyExtendedArtifact", (Object)name);
        Assert.assertEquals((Object)"This is a simple description for testing.", (Object)description);
    }

    @Test
    public void testGetArtifact_XSD() throws Exception {
        String artifactFileName = "PO.xsd";
        InputStream POXsd = this.getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        Document document = new Document();
        document.setName(artifactFileName);
        document.setArtifactType(BaseArtifactEnum.XSD_DOCUMENT);
        BaseArtifactType artifact = this.persistenceManager.persistArtifact((BaseArtifactType)document, new ArtifactContent(artifactFileName, POXsd));
        Assert.assertNotNull((Object)artifact);
        this.log.info("persisted PO.xsd, returned artifact uuid=" + artifact.getUuid());
        Assert.assertEquals(XsdDocument.class, artifact.getClass());
        long size = ((DocumentArtifactType)artifact).getContentSize();
        Assert.assertTrue((size >= 2376L ? 1 : 0) != 0);
        BaseArtifactType artifact2 = this.persistenceManager.getArtifact(artifact.getUuid(), ArtifactType.XsdDocument());
        Assert.assertEquals((Object)artifact.getUuid(), (Object)artifact2.getUuid());
        Assert.assertEquals((Object)artifact.getCreatedBy(), (Object)artifact2.getCreatedBy());
        Assert.assertEquals((Object)artifact.getDescription(), (Object)artifact2.getDescription());
        Assert.assertEquals((Object)artifact.getLastModifiedBy(), (Object)artifact2.getLastModifiedBy());
        Assert.assertEquals((Object)artifact.getName(), (Object)artifact2.getName());
        Assert.assertEquals((Object)artifact.getVersion(), (Object)artifact2.getVersion());
        Assert.assertEquals((Object)artifact.getLastModifiedTimestamp(), (Object)artifact2.getLastModifiedTimestamp());
    }

    @Test
    public void testUpdateMetaData() throws Exception {
        String artifactFileName = "PO.xsd";
        InputStream POXsd = this.getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        Document document = new Document();
        document.setName(artifactFileName);
        document.setArtifactType(BaseArtifactEnum.XSD_DOCUMENT);
        BaseArtifactType artifact = this.persistenceManager.persistArtifact((BaseArtifactType)document, new ArtifactContent(artifactFileName, POXsd));
        Assert.assertNotNull((Object)artifact);
        this.log.info("persisted PO.xsd, returned artifact uuid=" + artifact.getUuid());
        Assert.assertEquals(XsdDocument.class, artifact.getClass());
        long size = ((DocumentArtifactType)artifact).getContentSize();
        Assert.assertTrue((size >= 2376L ? 1 : 0) != 0);
        Assert.assertEquals((Object)artifactFileName, (Object)artifact.getName());
        artifact = this.persistenceManager.getArtifact(artifact.getUuid(), ArtifactType.XsdDocument());
        artifact.setName("My PO");
        artifact.setDescription("A new description of the PO.xsd artifact.");
        artifact.setVersion("2.0.13");
        this.persistenceManager.updateArtifact(artifact, ArtifactType.XsdDocument());
        artifact = this.persistenceManager.getArtifact(artifact.getUuid(), ArtifactType.XsdDocument());
        Assert.assertEquals((Object)"My PO", (Object)artifact.getName());
        Assert.assertEquals((Object)"A new description of the PO.xsd artifact.", (Object)artifact.getDescription());
        Assert.assertEquals((Object)"2.0.13", (Object)artifact.getVersion());
    }

    @Test
    public void testUpdateProperties() throws Exception {
        String artifactFileName = "PO.xsd";
        InputStream POXsd = this.getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        Document document = new Document();
        document.setName(artifactFileName);
        document.setArtifactType(BaseArtifactEnum.XSD_DOCUMENT);
        BaseArtifactType artifact = this.persistenceManager.persistArtifact((BaseArtifactType)document, new ArtifactContent(artifactFileName, POXsd));
        Assert.assertNotNull((Object)artifact);
        this.log.info("persisted PO.xsd, returned artifact uuid=" + artifact.getUuid());
        Assert.assertEquals(XsdDocument.class, artifact.getClass());
        long size = ((DocumentArtifactType)artifact).getContentSize();
        Assert.assertTrue((size >= 2376L ? 1 : 0) != 0);
        artifact = this.persistenceManager.getArtifact(artifact.getUuid(), ArtifactType.XsdDocument());
        Assert.assertTrue((String)"Expected 0 properties.", (boolean)artifact.getProperty().isEmpty());
        Property prop1 = new Property();
        prop1.setPropertyName("prop1");
        prop1.setPropertyValue("propval1");
        artifact.getProperty().add(prop1);
        Property prop2 = new Property();
        prop2.setPropertyName("prop2");
        prop2.setPropertyValue("propval2");
        artifact.getProperty().add(prop2);
        this.persistenceManager.updateArtifact(artifact, ArtifactType.XsdDocument());
        artifact = this.persistenceManager.getArtifact(artifact.getUuid(), ArtifactType.XsdDocument());
        Assert.assertTrue((String)"Expected 2 properties.", (artifact.getProperty().size() == 2 ? 1 : 0) != 0);
        String p1 = ((Property)artifact.getProperty().get(0)).getPropertyName() + "=" + ((Property)artifact.getProperty().get(0)).getPropertyValue();
        String p2 = ((Property)artifact.getProperty().get(1)).getPropertyName() + "=" + ((Property)artifact.getProperty().get(1)).getPropertyValue();
        HashSet<String> ps = new HashSet<String>();
        ps.add(p1);
        ps.add(p2);
        Assert.assertTrue((String)"Prop1 missing from properties.", (boolean)ps.contains("prop1=propval1"));
        Assert.assertTrue((String)"Prop2 missing from properties.", (boolean)ps.contains("prop2=propval2"));
        Assert.assertFalse((String)"Prop3 somehow existed!.", (boolean)ps.contains("prop3=propval3"));
        artifact.getProperty().clear();
        prop1 = new Property();
        prop1.setPropertyName("prop1");
        prop1.setPropertyValue("propval1-updated");
        artifact.getProperty().add(prop1);
        Property prop3 = new Property();
        prop3.setPropertyName("prop3");
        prop3.setPropertyValue("propval3");
        artifact.getProperty().add(prop3);
        this.persistenceManager.updateArtifact(artifact, ArtifactType.XsdDocument());
        artifact = this.persistenceManager.getArtifact(artifact.getUuid(), ArtifactType.XsdDocument());
        Assert.assertTrue((String)"Expected 2 properties.", (artifact.getProperty().size() == 2 ? 1 : 0) != 0);
        p1 = ((Property)artifact.getProperty().get(0)).getPropertyName() + "=" + ((Property)artifact.getProperty().get(0)).getPropertyValue();
        p2 = ((Property)artifact.getProperty().get(1)).getPropertyName() + "=" + ((Property)artifact.getProperty().get(1)).getPropertyValue();
        ps.clear();
        ps.add(p1);
        ps.add(p2);
        Assert.assertFalse((String)"Prop1 wasn't updated (old value detected).", (boolean)ps.contains("prop1=propval1"));
        Assert.assertTrue((String)"Prop1 wasn't updated (new value not found).", (boolean)ps.contains("prop1=propval1-updated"));
        Assert.assertFalse((String)"Prop2 existed unexpectedly.", (boolean)ps.contains("prop2=propval2"));
        Assert.assertTrue((String)"Prop3 missing from properties.", (boolean)ps.contains("prop3=propval3"));
    }

    @Test
    public void testUpdateProperties_Document() throws Exception {
        String artifactFileName = "s-ramp-press-release.pdf";
        InputStream pdf = this.getClass().getResourceAsStream("/sample-files/core/" + artifactFileName);
        Document document = new Document();
        document.setName(artifactFileName);
        document.setContentType("application/pdf");
        document.setArtifactType(BaseArtifactEnum.DOCUMENT);
        BaseArtifactType artifact = this.persistenceManager.persistArtifact((BaseArtifactType)document, new ArtifactContent(artifactFileName, pdf));
        Assert.assertNotNull((Object)artifact);
        this.log.info("persisted PDF, returned artifact uuid=" + artifact.getUuid());
        Assert.assertEquals(Document.class, artifact.getClass());
        Assert.assertEquals((Object)new Long(18873L), (Object)((DocumentArtifactType)artifact).getContentSize());
        artifact = this.persistenceManager.getArtifact(artifact.getUuid(), ArtifactType.Document());
        Assert.assertTrue((String)"Expected 0 properties.", (boolean)artifact.getProperty().isEmpty());
        Property prop1 = new Property();
        prop1.setPropertyName("prop1");
        prop1.setPropertyValue("propval1");
        artifact.getProperty().add(prop1);
        Property prop2 = new Property();
        prop2.setPropertyName("prop2");
        prop2.setPropertyValue("propval2");
        artifact.getProperty().add(prop2);
        this.persistenceManager.updateArtifact(artifact, ArtifactType.Document());
        artifact = this.persistenceManager.getArtifact(artifact.getUuid(), ArtifactType.Document());
        Assert.assertTrue((String)"Expected 2 properties.", (artifact.getProperty().size() == 2 ? 1 : 0) != 0);
        String p1 = ((Property)artifact.getProperty().get(0)).getPropertyName() + "=" + ((Property)artifact.getProperty().get(0)).getPropertyValue();
        String p2 = ((Property)artifact.getProperty().get(1)).getPropertyName() + "=" + ((Property)artifact.getProperty().get(1)).getPropertyValue();
        HashSet<String> ps = new HashSet<String>();
        ps.add(p1);
        ps.add(p2);
        Assert.assertTrue((String)"Prop1 missing from properties.", (boolean)ps.contains("prop1=propval1"));
        Assert.assertTrue((String)"Prop2 missing from properties.", (boolean)ps.contains("prop2=propval2"));
        Assert.assertFalse((String)"Prop3 somehow existed!.", (boolean)ps.contains("prop3=propval3"));
        artifact.getProperty().clear();
        prop1 = new Property();
        prop1.setPropertyName("prop1");
        prop1.setPropertyValue("propval1-updated");
        artifact.getProperty().add(prop1);
        Property prop3 = new Property();
        prop3.setPropertyName("prop3");
        prop3.setPropertyValue("propval3");
        artifact.getProperty().add(prop3);
        this.persistenceManager.updateArtifact(artifact, ArtifactType.Document());
        artifact = this.persistenceManager.getArtifact(artifact.getUuid(), ArtifactType.Document());
        Assert.assertTrue((String)"Expected 2 properties.", (artifact.getProperty().size() == 2 ? 1 : 0) != 0);
        p1 = ((Property)artifact.getProperty().get(0)).getPropertyName() + "=" + ((Property)artifact.getProperty().get(0)).getPropertyValue();
        p2 = ((Property)artifact.getProperty().get(1)).getPropertyName() + "=" + ((Property)artifact.getProperty().get(1)).getPropertyValue();
        ps.clear();
        ps.add(p1);
        ps.add(p2);
        Assert.assertFalse((String)"Prop1 wasn't updated (old value detected).", (boolean)ps.contains("prop1=propval1"));
        Assert.assertTrue((String)"Prop1 wasn't updated (new value not found).", (boolean)ps.contains("prop1=propval1-updated"));
        Assert.assertFalse((String)"Prop2 existed unexpectedly.", (boolean)ps.contains("prop2=propval2"));
        Assert.assertTrue((String)"Prop3 missing from properties.", (boolean)ps.contains("prop3=propval3"));
    }

    @Test
    public void testGenericRelationships() throws Exception {
        String uuid1 = null;
        String uuid2 = null;
        String uuid3 = null;
        String artifactFileName = "PO.xsd";
        InputStream contentStream = this.getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        Document document = new Document();
        document.setName(artifactFileName);
        document.setArtifactType(BaseArtifactEnum.XSD_DOCUMENT);
        BaseArtifactType artifact = this.persistenceManager.persistArtifact((BaseArtifactType)document, new ArtifactContent(artifactFileName, contentStream));
        Assert.assertNotNull((Object)artifact);
        uuid1 = artifact.getUuid();
        contentStream.close();
        artifact = this.persistenceManager.getArtifact(uuid1, ArtifactType.XsdDocument());
        Assert.assertTrue((String)"Expected 0 relationships.", (boolean)artifact.getRelationship().isEmpty());
        artifactFileName = "XMLSchema.xsd";
        contentStream = this.getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        Document document2 = new Document();
        document2.setName(artifactFileName);
        document2.setArtifactType(BaseArtifactEnum.XSD_DOCUMENT);
        BaseArtifactType artifact2 = this.persistenceManager.persistArtifact((BaseArtifactType)document2, new ArtifactContent(artifactFileName, contentStream));
        Assert.assertNotNull((Object)artifact2);
        uuid2 = artifact2.getUuid();
        ArtificerModelUtils.addGenericRelationship((BaseArtifactType)artifact, (String)"TargetedRelationship", (String)uuid2);
        this.persistenceManager.updateArtifact(artifact, ArtifactType.XsdDocument());
        artifact = this.persistenceManager.getArtifact(uuid1, ArtifactType.XsdDocument());
        Assert.assertEquals((String)"Expected 1 relationship.", (long)1L, (long)artifact.getRelationship().size());
        Relationship relationship = ArtificerModelUtils.getGenericRelationship((BaseArtifactType)artifact, (String)"TargetedRelationship");
        Assert.assertNotNull((Object)relationship);
        Assert.assertEquals((Object)"TargetedRelationship", (Object)relationship.getRelationshipType());
        Assert.assertEquals((long)1L, (long)relationship.getRelationshipTarget().size());
        Assert.assertEquals((Object)uuid2, (Object)((Target)relationship.getRelationshipTarget().get(0)).getValue());
        artifactFileName = "PO.xml";
        contentStream = this.getClass().getResourceAsStream("/sample-files/core/" + artifactFileName);
        Document document3 = new Document();
        document3.setName(artifactFileName);
        document3.setArtifactType(BaseArtifactEnum.XML_DOCUMENT);
        BaseArtifactType artifact3 = this.persistenceManager.persistArtifact((BaseArtifactType)document3, new ArtifactContent(artifactFileName, contentStream));
        Assert.assertNotNull((Object)artifact3);
        uuid3 = artifact3.getUuid();
        ArtificerModelUtils.addGenericRelationship((BaseArtifactType)artifact, (String)"TargetedRelationship", (String)uuid3);
        this.persistenceManager.updateArtifact(artifact, ArtifactType.XsdDocument());
        artifact = this.persistenceManager.getArtifact(uuid1, ArtifactType.XsdDocument());
        Assert.assertEquals((String)"Expected 1 relationships.", (long)1L, (long)artifact.getRelationship().size());
        relationship = ArtificerModelUtils.getGenericRelationship((BaseArtifactType)artifact, (String)"TargetedRelationship");
        Assert.assertNotNull((Object)relationship);
        Assert.assertEquals((Object)"TargetedRelationship", (Object)relationship.getRelationshipType());
        Assert.assertEquals((long)2L, (long)relationship.getRelationshipTarget().size());
        HashSet<String> expected = new HashSet<String>();
        HashSet<String> actual = new HashSet<String>();
        expected.add(uuid2);
        expected.add(uuid3);
        actual.add(((Target)relationship.getRelationshipTarget().get(0)).getValue());
        actual.add(((Target)relationship.getRelationshipTarget().get(1)).getValue());
        Assert.assertEquals(expected, actual);
        ArtificerModelUtils.addGenericRelationship((BaseArtifactType)artifact, (String)"TargetedRelationship", (String)"not-a-valid-uuid");
        try {
            this.persistenceManager.updateArtifact(artifact, ArtifactType.XsdDocument());
            Assert.fail((String)"Expected an update failure.");
        }
        catch (Exception e) {
            Assert.assertEquals(ArtificerNotFoundException.class, e.getClass());
            Assert.assertEquals((Object)"No artifact found with UUID: not-a-valid-uuid", (Object)e.getMessage());
        }
    }

    @Test
    public void testArtifactComments() throws Exception {
        BaseArtifactType artifact = ArtifactType.ExtendedArtifactType((String)"FooType").newArtifactInstance();
        artifact.setName("FooArtifact");
        artifact = this.persistenceManager.persistArtifact(artifact, null);
        this.persistenceManager.addComment(artifact.getUuid(), ArtifactType.valueOf((BaseArtifactType)artifact), "xyz");
        this.persistenceManager.addComment(artifact.getUuid(), ArtifactType.valueOf((BaseArtifactType)artifact), "abc");
        artifact = this.persistenceManager.addComment(artifact.getUuid(), ArtifactType.valueOf((BaseArtifactType)artifact), "lmn");
        Assert.assertEquals((long)3L, (long)artifact.getComment().size());
        this.commentAssertions((Comment)artifact.getComment().get(0), "xyz");
        this.commentAssertions((Comment)artifact.getComment().get(1), "abc");
        this.commentAssertions((Comment)artifact.getComment().get(2), "lmn");
    }

    private void commentAssertions(Comment comment, String text) {
        Assert.assertEquals((Object)text, (Object)comment.getText());
        Assert.assertNotNull((Object)comment.getCreatedTimestamp());
        Assert.assertEquals((Object)"junituser", (Object)comment.getCreatedBy());
    }

    @Test
    public void testDeleteArtifact() throws Exception {
        String artifactFileName = "s-ramp-press-release.pdf";
        InputStream pdf = this.getClass().getResourceAsStream("/sample-files/core/" + artifactFileName);
        Document document = new Document();
        document.setName(artifactFileName);
        document.setArtifactType(BaseArtifactEnum.DOCUMENT);
        BaseArtifactType artifact = this.persistenceManager.persistArtifact((BaseArtifactType)document, new ArtifactContent(artifactFileName, pdf));
        Assert.assertNotNull((Object)artifact);
        Assert.assertEquals(Document.class, artifact.getClass());
        Assert.assertEquals((Object)new Long(18873L), (Object)((DocumentArtifactType)artifact).getContentSize());
        this.log.info("persisted s-ramp-press-release.pdf, returned artifact uuid=" + artifact.getUuid());
        ArtifactType at = ArtifactType.valueOf((BaseArtifactType)artifact);
        this.persistenceManager.deleteArtifact(document.getUuid(), at, false);
        BaseArtifactType deleted = this.persistenceManager.getArtifact(document.getUuid(), at);
        Assert.assertNull((Object)deleted);
        ArtificerQuery query = this.queryManager.createQuery("/s-ramp[@uuid = ?]");
        query.setString(document.getUuid());
        PagedResult artifactSet = query.executeQuery();
        Assert.assertEquals((long)0L, (long)artifactSet.getTotalSize());
        pdf = this.getClass().getResourceAsStream("/sample-files/core/" + artifactFileName);
        BaseArtifactType artifact2 = this.persistenceManager.persistArtifact((BaseArtifactType)document, new ArtifactContent(artifactFileName, pdf));
        Assert.assertEquals((Object)artifact.getUuid(), (Object)artifact2.getUuid());
        this.persistenceManager.deleteArtifact(document.getUuid(), at, false);
        deleted = this.persistenceManager.getArtifact(document.getUuid(), at);
        Assert.assertNull((Object)deleted);
    }
}

