/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.test;

import java.io.InputStream;
import java.util.Date;
import java.util.UUID;
import org.artificer.common.ArtifactContent;
import org.artificer.common.ArtifactType;
import org.artificer.common.ArtificerModelUtils;
import org.artificer.common.query.ArtifactSummary;
import org.artificer.repository.query.ArtificerQuery;
import org.artificer.repository.query.PagedResult;
import org.artificer.repository.test.AbstractNoAuditingPersistenceTest;
import org.junit.Assert;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XmlDocument;

public class QueryManagerTest
extends AbstractNoAuditingPersistenceTest {
    @Test
    public void testQueryManager() throws Exception {
        BaseArtifactType artifact = this.createXmlDocument("PO.xml", 1);
        this.log.info("persisted, returned artifact uuid=" + artifact.getUuid());
        ArtificerQuery query = this.queryManager.createQuery("/s-ramp/core/XmlDocument");
        PagedResult artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        ArtifactSummary found = (ArtifactSummary)artifactSet.getResults().get(0);
        Assert.assertNotNull((String)"Expected artifact not found in artifact set.", (Object)found);
        Assert.assertEquals((Object)artifact.getUuid(), (Object)found.getUuid());
        Assert.assertEquals((Object)artifact.getName(), (Object)found.getName());
        Assert.assertEquals((Object)artifact.getDescription(), (Object)found.getDescription());
    }

    @Test
    public void testQueryByProperty() throws Exception {
        String uniquePropVal1 = UUID.randomUUID().toString();
        String uniquePropVal2 = UUID.randomUUID().toString();
        String uniquePropVal3 = UUID.randomUUID().toString();
        BaseArtifactType artifact1 = this.createXmlDocument("PO.xml", 1);
        BaseArtifactType artifact2 = this.createXmlDocument("PO.xml", 2);
        BaseArtifactType artifact3 = this.createXmlDocument("PO.xml", 3);
        ArtificerModelUtils.setCustomProperty((BaseArtifactType)artifact1, (String)"prop1", (String)uniquePropVal1);
        ArtificerModelUtils.setCustomProperty((BaseArtifactType)artifact1, (String)"prop2", (String)uniquePropVal2);
        ArtificerModelUtils.setCustomProperty((BaseArtifactType)artifact1, (String)"prop3", (String)uniquePropVal3);
        ArtificerModelUtils.setCustomProperty((BaseArtifactType)artifact2, (String)"prop2", (String)uniquePropVal2);
        ArtificerModelUtils.setCustomProperty((BaseArtifactType)artifact2, (String)"prop3", (String)uniquePropVal3);
        ArtificerModelUtils.setCustomProperty((BaseArtifactType)artifact3, (String)"prop3", (String)uniquePropVal3);
        this.persistenceManager.updateArtifact(artifact1, ArtifactType.XmlDocument());
        this.persistenceManager.updateArtifact(artifact2, ArtifactType.XmlDocument());
        this.persistenceManager.updateArtifact(artifact3, ArtifactType.XmlDocument());
        this.persistenceManager.printArtifactGraph(artifact1.getUuid(), ArtifactType.XmlDocument());
        ArtificerQuery query = this.queryManager.createQuery("/s-ramp/core/XmlDocument[@prop1 = ?]");
        query.setString(uniquePropVal1);
        PagedResult artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/core/XmlDocument[@prop2 = ?]");
        query.setString(uniquePropVal2);
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)2L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/core/XmlDocument[@prop3 = ?]");
        query.setString(uniquePropVal3);
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)3L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/core/XmlDocument[@prop1 = ?]");
        query.setString("nomatches");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)0L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/core/XmlDocument[@prop2]");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)2L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/core/XmlDocument[@prop1 = ? and @prop2 = ?]");
        query.setString(uniquePropVal1);
        query.setString(uniquePropVal2);
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/core/XmlDocument[@prop1 = ? or @prop2 = ?]");
        query.setString(uniquePropVal1);
        query.setString(uniquePropVal2);
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)2L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/core/XmlDocument[@version = ?]");
        query.setString("1.0.3");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)3L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/core/XmlDocument[@lastModifiedTimestamp < ?]");
        query.setDate(new Date(System.currentTimeMillis() + 86400000L));
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertTrue((artifactSet.getTotalSize() >= 3L ? 1 : 0) != 0);
        query = this.queryManager.createQuery("/s-ramp/core/XmlDocument[@lastModifiedTimestamp > ?]");
        query.setDate(new Date(System.currentTimeMillis() + 86400000L));
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)0L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/core/XmlDocument[xp2:not(@prop1)]");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)2L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/core/XmlDocument[xp2:not(@prop1 = ?)]");
        query.setString("nomatches");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)3L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/core/XmlDocument[xp2:not(@prop1 = ? and @prop2 = ?)]");
        query.setString(uniquePropVal1);
        query.setString(uniquePropVal2);
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)2L, (long)artifactSet.getTotalSize());
    }

    @Test
    public void testCustomPropertyBooleanValue() throws Exception {
        BaseArtifactType artifact = this.createXmlDocument("PO.xml", 1);
        ArtificerModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"prop1", (String)"true");
        this.persistenceManager.updateArtifact(artifact, ArtifactType.XmlDocument());
        this.persistenceManager.printArtifactGraph(artifact.getUuid(), ArtifactType.XmlDocument());
        ArtificerQuery query = this.queryManager.createQuery("/s-ramp/core/XmlDocument[@prop1 = ?]");
        query.setString("true");
        PagedResult artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        this.persistenceManager.printArtifactGraph(artifact.getUuid(), ArtifactType.XmlDocument());
        query = this.queryManager.createQuery("/s-ramp/core/XmlDocument[@prop1 = ?]");
        query.setString("false");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)0L, (long)artifactSet.getTotalSize());
        this.persistenceManager.printArtifactGraph(artifact.getUuid(), ArtifactType.XmlDocument());
        query = this.queryManager.createQuery("/s-ramp/core/XmlDocument[@prop1 = ?]");
        query.setString("invalid");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)0L, (long)artifactSet.getTotalSize());
    }

    @Test
    public void testFreeTextSearch() throws Exception {
        BaseArtifactType artifact1 = this.createXmlDocument("PO.xml", 1);
        BaseArtifactType artifact2 = this.createXmlDocument("PO.xml", 2);
        BaseArtifactType artifact3 = this.createXmlDocument("PO2.xml", 3);
        BaseArtifactType artifact4 = this.addExtendedArtifact("FooType", "FooArtifact");
        ArtificerModelUtils.setCustomProperty((BaseArtifactType)artifact1, (String)"prop1", (String)"fizz test");
        ArtificerModelUtils.setCustomProperty((BaseArtifactType)artifact2, (String)"prop1", (String)"buzz test");
        ArtificerModelUtils.setCustomProperty((BaseArtifactType)artifact3, (String)"prop1", (String)"fizz buzz test");
        ArtificerModelUtils.setCustomProperty((BaseArtifactType)artifact4, (String)"prop1", (String)"fizz buzz test");
        this.persistenceManager.updateArtifact(artifact1, ArtifactType.XmlDocument());
        this.persistenceManager.updateArtifact(artifact2, ArtifactType.XmlDocument());
        this.persistenceManager.updateArtifact(artifact3, ArtifactType.XmlDocument());
        this.persistenceManager.updateArtifact(artifact4, ArtifactType.valueOf((BaseArtifactType)artifact4));
        ArtificerQuery query = this.queryManager.createQuery("/s-ramp[xp2:matches(., ?)]");
        query.setString("fizz");
        PagedResult artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)3L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp[xp2:matches(., ?)]");
        query.setString("buzz");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)3L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp[xp2:matches(., ?)]");
        query.setString("test");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)4L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp[xp2:matches(., ?)]");
        query.setString("Lawn Mower");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)2L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp[xp2:matches(., ?)]");
        query.setString("Leaf Blower");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp[xp2:matches(., ?)]");
        query.setString("Baby Monitor");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)3L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp[xp2:matches(., ?) and @name = ?]");
        query.setString("fizz");
        query.setString(artifact1.getName());
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/core/XmlDocument[xp2:matches(., ?)]");
        query.setString("fizz");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)2L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/ext/FooType[xp2:matches(., ?)]");
        query.setString("fizz");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
    }

    private BaseArtifactType createXmlDocument(String artifactFileName, int idx) throws Exception {
        InputStream content = this.getClass().getResourceAsStream("/sample-files/core/" + artifactFileName);
        XmlDocument document = (XmlDocument)ArtifactType.XmlDocument().newArtifactInstance();
        document.setName(artifactFileName + "-" + idx);
        document.setVersion("1.0.3");
        document.setArtifactType(BaseArtifactEnum.XML_DOCUMENT);
        BaseArtifactType artifact1 = this.persistenceManager.persistArtifact((BaseArtifactType)document, new ArtifactContent(artifactFileName, content));
        Assert.assertNotNull((Object)artifact1);
        return artifact1;
    }
}

