/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.test;

import java.util.List;
import org.artificer.common.ArtifactTypeEnum;
import org.artificer.repository.test.AbstractNoAuditingPersistenceTest;
import org.junit.Assert;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Binding;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperation;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationFault;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationFaultTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationInput;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationOutput;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ComplexTypeDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ElementDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Fault;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.FaultTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Message;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Operation;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationInput;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationOutput;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Part;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Port;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PortType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.SimpleTypeDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.SoapAddress;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.SoapBinding;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Target;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlService;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XmlDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdDocument;

public class WsdlDocumentPersistenceTest
extends AbstractNoAuditingPersistenceTest {
    @Test
    public void testWsdlDocument() throws Exception {
        String uuid = this.addArtifact("/sample-files/wsdl/", "jcr-sample.wsdl", (XmlDocument)new WsdlDocument(), BaseArtifactEnum.WSDL_DOCUMENT).getUuid();
        WsdlDocument wsdl = (WsdlDocument)this.getArtifactByUUID(uuid);
        Assert.assertNotNull((Object)wsdl);
        Assert.assertEquals((Object)"jcr-sample.wsdl", (Object)wsdl.getName());
        Assert.assertEquals((Object)"http://ewittman.redhat.com/sample/2012/09/wsdl/sample.wsdl", (Object)wsdl.getTargetNamespace());
        SimpleTypeDeclaration keywordType = (SimpleTypeDeclaration)this.assertSingleArtifact(ArtifactTypeEnum.SimpleTypeDeclaration, "keywordType");
        ElementDeclaration findElement = (ElementDeclaration)this.assertSingleArtifact(ArtifactTypeEnum.ElementDeclaration, "find");
        ElementDeclaration findResponseElement = (ElementDeclaration)this.assertSingleArtifact(ArtifactTypeEnum.ElementDeclaration, "findResponse");
        Message findRequestMessage = (Message)this.assertSingleArtifact(ArtifactTypeEnum.Message, "findRequest");
        Message findResponseMessage = (Message)this.assertSingleArtifact(ArtifactTypeEnum.Message, "findResponse");
        Message findRequestSimpleMessage = (Message)this.assertSingleArtifact(ArtifactTypeEnum.Message, "findRequestSimple");
        Message findResponseSimpleMessage = (Message)this.assertSingleArtifact(ArtifactTypeEnum.Message, "findResponseSimple");
        Message faultMessage = (Message)this.assertSingleArtifact(ArtifactTypeEnum.Message, "faultMessage");
        PortType samplePortType = (PortType)this.assertSingleArtifact(ArtifactTypeEnum.PortType, "SamplePortType");
        Operation findOp = (Operation)this.assertSingleArtifact(ArtifactTypeEnum.Operation, "find");
        Operation findSimpleOp = (Operation)this.assertSingleArtifact(ArtifactTypeEnum.Operation, "findSimple");
        Fault errorFault = (Fault)this.assertSingleArtifact(ArtifactTypeEnum.Fault, "errorFault");
        Fault unknownFault = (Fault)this.assertSingleArtifact(ArtifactTypeEnum.Fault, "unknownFault");
        Binding binding = (Binding)this.assertSingleArtifact(ArtifactTypeEnum.Binding, "SampleBinding");
        WsdlService service = (WsdlService)this.assertSingleArtifact(ArtifactTypeEnum.WsdlService, "SampleService");
        Part part = (Part)this.getArtifactByTarget((Target)findRequestMessage.getPart().get(0));
        Assert.assertNull((Object)part.getType());
        ElementDeclaration elem = (ElementDeclaration)this.getArtifactByTarget((Target)part.getElement());
        Assert.assertEquals((Object)findElement.getUuid(), (Object)elem.getUuid());
        part = (Part)this.getArtifactByTarget((Target)findResponseMessage.getPart().get(0));
        Assert.assertNull((Object)part.getType());
        elem = (ElementDeclaration)this.getArtifactByTarget((Target)part.getElement());
        Assert.assertEquals((Object)findResponseElement.getUuid(), (Object)elem.getUuid());
        part = (Part)this.getArtifactByTarget((Target)findRequestSimpleMessage.getPart().get(0));
        Assert.assertNull((Object)part.getElement());
        SimpleTypeDeclaration type = (SimpleTypeDeclaration)this.getArtifactByTarget((Target)part.getType());
        Assert.assertEquals((Object)keywordType.getUuid(), (Object)type.getUuid());
        part = (Part)this.getArtifactByTarget((Target)findResponseSimpleMessage.getPart().get(0));
        Assert.assertNull((Object)part.getType());
        elem = (ElementDeclaration)this.getArtifactByTarget((Target)part.getElement());
        Assert.assertEquals((Object)findResponseElement.getUuid(), (Object)elem.getUuid());
        part = (Part)this.getArtifactByTarget((Target)faultMessage.getPart().get(0));
        Assert.assertNull((Object)part.getType());
        Assert.assertNull((Object)part.getElement());
        List operations = samplePortType.getOperation();
        Assert.assertNotNull((Object)operations);
        Assert.assertEquals((long)2L, (long)operations.size());
        Operation operation = this.assertHasOperation(samplePortType, "find");
        Assert.assertEquals((Object)findOp.getUuid(), (Object)operation.getUuid());
        OperationInput input = (OperationInput)this.getArtifactByTarget((Target)operation.getInput());
        Assert.assertEquals((Object)"findRequest", (Object)input.getNCName());
        Message msg = (Message)this.getArtifactByTarget((Target)input.getMessage());
        Assert.assertEquals((Object)findRequestMessage.getUuid(), (Object)msg.getUuid());
        OperationOutput output = (OperationOutput)this.getArtifactByTarget((Target)operation.getOutput());
        Assert.assertEquals((Object)"findResponse", (Object)output.getNCName());
        msg = (Message)this.getArtifactByTarget((Target)output.getMessage());
        Assert.assertEquals((Object)findResponseMessage.getUuid(), (Object)msg.getUuid());
        List faults = operation.getFault();
        Assert.assertEquals((long)2L, (long)faults.size());
        Fault fault = this.assertHasFault(operation, "errorFault");
        Assert.assertEquals((Object)errorFault.getUuid(), (Object)fault.getUuid());
        msg = (Message)this.getArtifactByTarget((Target)fault.getMessage());
        Assert.assertEquals((Object)faultMessage.getUuid(), (Object)msg.getUuid());
        fault = this.assertHasFault(operation, "unknownFault");
        Assert.assertEquals((Object)unknownFault.getUuid(), (Object)fault.getUuid());
        operation = this.assertHasOperation(samplePortType, "findSimple");
        Assert.assertEquals((Object)findSimpleOp.getUuid(), (Object)operation.getUuid());
        input = (OperationInput)this.getArtifactByTarget((Target)operation.getInput());
        output = (OperationOutput)this.getArtifactByTarget((Target)operation.getOutput());
        faults = operation.getFault();
        Assert.assertEquals((long)0L, (long)faults.size());
        Assert.assertEquals((long)1L, (long)binding.getExtension().size());
        SoapBinding soapBinding = (SoapBinding)this.getArtifactByTarget((Target)binding.getExtension().get(0));
        Assert.assertNotNull((Object)soapBinding);
        Assert.assertEquals((Object)"document", (Object)soapBinding.getStyle());
        Assert.assertEquals((Object)"http://schemas.xmlsoap.org/soap/http", (Object)soapBinding.getTransport());
        PortType pt = (PortType)this.getArtifactByTarget((Target)binding.getPortType());
        Assert.assertNotNull((Object)pt);
        Assert.assertEquals((Object)samplePortType.getUuid(), (Object)pt.getUuid());
        BindingOperation bindingOperation = this.assertHasOperation(binding, "find");
        BindingOperationInput bindingInput = (BindingOperationInput)this.getArtifactByTarget((Target)bindingOperation.getInput());
        Assert.assertEquals((Object)"findRequest", (Object)bindingInput.getNCName());
        BindingOperationOutput bindingOutput = (BindingOperationOutput)this.getArtifactByTarget((Target)bindingOperation.getOutput());
        Assert.assertEquals((Object)"findResponse", (Object)bindingOutput.getNCName());
        List bfaults = bindingOperation.getFault();
        Assert.assertEquals((long)2L, (long)bfaults.size());
        this.assertHasFault(bindingOperation, "errorFault");
        this.assertHasFault(bindingOperation, "unknownFault");
        Operation op = (Operation)this.getArtifactByTarget((Target)bindingOperation.getOperation());
        Assert.assertNotNull((Object)op);
        Assert.assertEquals((Object)findOp.getUuid(), (Object)op.getUuid());
        Assert.assertEquals((long)1L, (long)service.getPort().size());
        Port port = (Port)this.getArtifactByTarget((Target)service.getPort().get(0));
        Assert.assertNotNull((Object)port);
        Binding b = (Binding)this.getArtifactByTarget((Target)port.getBinding());
        Assert.assertEquals((Object)binding.getUuid(), (Object)b.getUuid());
        Assert.assertEquals((long)1L, (long)port.getExtension().size());
        SoapAddress soapAddress = (SoapAddress)this.getArtifactByTarget((Target)port.getExtension().get(0));
        Assert.assertNotNull((Object)soapAddress);
        Assert.assertEquals((Object)"http://localhost:8080/sample/sampleEP", (Object)soapAddress.getSoapLocation());
    }

    private Fault assertHasFault(Operation operation, String faultName) throws Exception {
        List faults = operation.getFault();
        for (FaultTarget t : faults) {
            Fault fault = (Fault)this.getArtifactByTarget((Target)t);
            if (!fault.getNCName().equals(faultName)) continue;
            return fault;
        }
        Assert.fail((String)("Failed to find fault with name: " + faultName));
        return null;
    }

    private BindingOperationFault assertHasFault(BindingOperation operation, String faultName) throws Exception {
        List faults = operation.getFault();
        for (BindingOperationFaultTarget t : faults) {
            BindingOperationFault fault = (BindingOperationFault)this.getArtifactByTarget((Target)t);
            if (!fault.getNCName().equals(faultName)) continue;
            return fault;
        }
        Assert.fail((String)("Failed to find fault with name: " + faultName));
        return null;
    }

    private Operation assertHasOperation(PortType portType, String operationName) throws Exception {
        List operation = portType.getOperation();
        for (OperationTarget t : operation) {
            Operation op = (Operation)this.getArtifactByTarget((Target)t);
            if (!op.getNCName().equals(operationName)) continue;
            return op;
        }
        Assert.fail((String)("Failed to find operation with name: " + operationName));
        return null;
    }

    private BindingOperation assertHasOperation(Binding binding, String operationName) throws Exception {
        List operation = binding.getBindingOperation();
        for (BindingOperationTarget t : operation) {
            BindingOperation op = (BindingOperation)this.getArtifactByTarget((Target)t);
            if (!op.getNCName().equals(operationName)) continue;
            return op;
        }
        Assert.fail((String)("Failed to find operation with name: " + operationName));
        return null;
    }

    @Test
    public void testWsdlDocumentWithExternalRefs() throws Exception {
        String xsdUuid = this.addArtifact("/sample-files/wsdl/", "jcr-sample-externalrefs.xsd", (XmlDocument)new XsdDocument(), BaseArtifactEnum.XSD_DOCUMENT).getUuid();
        String uuid = this.addArtifact("/sample-files/wsdl/", "jcr-sample-externalrefs.wsdl", (XmlDocument)new WsdlDocument(), BaseArtifactEnum.WSDL_DOCUMENT).getUuid();
        XsdDocument xsd = (XsdDocument)this.getArtifactByUUID(xsdUuid);
        Assert.assertNotNull((Object)xsd);
        Assert.assertEquals((Object)"urn:s-ramp:test:jcr-sample-externalrefs:types", (Object)xsd.getTargetNamespace());
        WsdlDocument wsdl = (WsdlDocument)this.getArtifactByUUID(uuid);
        Assert.assertNotNull((Object)wsdl);
        Assert.assertEquals((Object)"jcr-sample-externalrefs.wsdl", (Object)wsdl.getName());
        Assert.assertEquals((Object)"http://ewittman.redhat.com/sample/2012/09/wsdl/sample.wsdl", (Object)wsdl.getTargetNamespace());
        ElementDeclaration extInput = (ElementDeclaration)this.assertSingleArtifact(ArtifactTypeEnum.ElementDeclaration, "extInput");
        ComplexTypeDeclaration extOutputType = (ComplexTypeDeclaration)this.assertSingleArtifact(ArtifactTypeEnum.ComplexTypeDeclaration, "extOutputType");
        SimpleTypeDeclaration extSimpleType = (SimpleTypeDeclaration)this.assertSingleArtifact(ArtifactTypeEnum.SimpleTypeDeclaration, "extSimpleType");
        Message findRequestMessage = (Message)this.assertSingleArtifact(ArtifactTypeEnum.Message, "findRequest");
        Message findResponseMessage = (Message)this.assertSingleArtifact(ArtifactTypeEnum.Message, "findResponse");
        Message findRequestSimpleMessage = (Message)this.assertSingleArtifact(ArtifactTypeEnum.Message, "findRequestSimple");
        Part part = (Part)this.getArtifactByTarget((Target)findRequestMessage.getPart().get(0));
        Assert.assertNull((Object)part.getType());
        ElementDeclaration elem = (ElementDeclaration)this.getArtifactByTarget((Target)part.getElement());
        Assert.assertEquals((Object)extInput.getUuid(), (Object)elem.getUuid());
        part = (Part)this.getArtifactByTarget((Target)findResponseMessage.getPart().get(0));
        Assert.assertNull((Object)part.getElement());
        ComplexTypeDeclaration complexType = (ComplexTypeDeclaration)this.getArtifactByTarget((Target)part.getType());
        Assert.assertEquals((Object)extOutputType.getUuid(), (Object)complexType.getUuid());
        part = (Part)this.getArtifactByTarget((Target)findRequestSimpleMessage.getPart().get(0));
        Assert.assertNull((Object)part.getElement());
        SimpleTypeDeclaration type = (SimpleTypeDeclaration)this.getArtifactByTarget((Target)part.getType());
        Assert.assertEquals((Object)extSimpleType.getUuid(), (Object)type.getUuid());
    }
}

