/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.test.hibernate;

import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.artificer.repository.filter.ServletCredentialsFilter;
import org.artificer.repository.hibernate.HibernateUtil;
import org.artificer.repository.hibernate.entity.ArtificerArtifact;
import org.artificer.repository.hibernate.file.FileManagerFactory;
import org.artificer.repository.test.RepositoryTestProvider;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.Search;

public class HibernateRepositoryTestProvider
implements RepositoryTestProvider {
    private final Map<String, String> extraProperties;

    public HibernateRepositoryTestProvider(Map<String, String> extraProperties) {
        this.extraProperties = extraProperties;
    }

    @Override
    public void before() throws Exception {
        HibernateUtil.setPersistenceUnit((String)"ArtificerTest");
        System.setProperty("hibernate.dialect", "org.hibernate.dialect.H2Dialect");
        System.setProperty("hibernate.connection.driver_class", "org.h2.Driver");
        System.setProperty("hibernate.connection.url", "jdbc:h2:mem:dbHibernateTest;DB_CLOSE_DELAY=-1;MVCC=true");
        System.setProperty("hibernate.connection.username", "sa");
        System.setProperty("hibernate.cache.use_second_level_cache", "true");
        System.setProperty("hibernate.cache.region.factory_class", "org.hibernate.testing.cache.CachingRegionFactory");
        System.setProperty("hibernate.cache.use_query_cache", "true");
        System.setProperty("hibernate.search.default.directory_provider", "ram");
        if (this.extraProperties != null) {
            for (String key : this.extraProperties.keySet()) {
                String value = this.extraProperties.get(key);
                System.setProperty(key, value);
            }
        }
        FileManagerFactory.reset();
        ServletCredentialsFilter.setUsername((String)"junituser");
        new HibernateUtil.HibernateTask<Void>(){

            protected Void doExecute(EntityManager entityManager) throws Exception {
                entityManager.createNativeQuery("SET REFERENTIAL_INTEGRITY FALSE").executeUpdate();
                entityManager.createNativeQuery("SET LOCK_MODE 0").executeUpdate();
                List tables = entityManager.createNativeQuery("SHOW TABLES").getResultList();
                for (Object[] table : tables) {
                    entityManager.createNativeQuery("TRUNCATE TABLE " + table[0]).executeUpdate();
                }
                entityManager.createNativeQuery("SET REFERENTIAL_INTEGRITY true").executeUpdate();
                entityManager.createNativeQuery("SET LOCK_MODE 3").executeUpdate();
                FullTextEntityManager fullTextEntityManager = Search.getFullTextEntityManager((EntityManager)entityManager);
                fullTextEntityManager.purgeAll(ArtificerArtifact.class);
                return null;
            }
        }.execute();
    }

    @Override
    public void after() throws Exception {
    }
}

