/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.test.query;

import java.math.BigInteger;
import java.util.Arrays;
import org.artificer.common.error.ArtificerUserException;
import org.artificer.repository.query.AbstractArtificerQueryImpl;
import org.artificer.repository.query.NumberReplacementParam;
import org.artificer.repository.query.QueryReplacementParam;
import org.artificer.repository.query.StringReplacementParam;
import org.junit.Assert;
import org.junit.Test;

public class AbstractArtificerQueryImplTest {
    @Test
    public void testFormatQuery() throws ArtificerUserException {
        this.doFormatQueryTest("/s-ramp/xsd/XsdDocument", "/s-ramp/xsd/XsdDocument", new QueryReplacementParam[0]);
        this.doFormatQueryTest("/s-ramp/xsd/XsdDocument[@prop = ?]", "/s-ramp/xsd/XsdDocument[@prop = 'hello-world']", new QueryReplacementParam[]{new StringReplacementParam("hello-world")});
        this.doFormatQueryTest("/s-ramp/xsd/XsdDocument[@size = ?]", "/s-ramp/xsd/XsdDocument[@size = 10]", new QueryReplacementParam[]{new NumberReplacementParam((Number)10)});
        this.doFormatQueryTest("/s-ramp/xsd/XsdDocument[@size = ?]", "/s-ramp/xsd/XsdDocument[@size = 1.0]", new QueryReplacementParam[]{new NumberReplacementParam((Number)1.0)});
        this.doFormatQueryTest("/s-ramp/xsd/XsdDocument[@size = ?]", "/s-ramp/xsd/XsdDocument[@size = 12345123451234512345123451234512345]", new QueryReplacementParam[]{new NumberReplacementParam((Number)new BigInteger("12345123451234512345123451234512345"))});
        this.doFormatQueryTest("/s-ramp/xsd/XsdDocument[@size = ?]", "/s-ramp/xsd/XsdDocument[@size = 123456789012345]", new QueryReplacementParam[]{new NumberReplacementParam((Number)123456789012345L)});
        this.doFormatQueryTest("/s-ramp/xsd/XsdDocument[@prop1 = ? and @prop2 = ? and @prop3 = ?]", "/s-ramp/xsd/XsdDocument[@prop1 = 'val1' and @prop2 = 'val2' and @prop3 = 17]", new QueryReplacementParam[]{new StringReplacementParam("val1"), new StringReplacementParam("val2"), new NumberReplacementParam((Number)17)});
    }

    @Test(expected=ArtificerUserException.class)
    public void testFormatQuery_tooManyParams() throws ArtificerUserException {
        this.doFormatQueryTest("/s-ramp/xsd/XsdDocument", null, new QueryReplacementParam[]{new StringReplacementParam("val1")});
    }

    @Test(expected=ArtificerUserException.class)
    public void testFormatQuery_notEnoughParams() throws ArtificerUserException {
        this.doFormatQueryTest("/s-ramp/xsd/XsdDocument[@prop1 = ? or @prop2 = ?]", null, new QueryReplacementParam[]{new StringReplacementParam("val1")});
    }

    private void doFormatQueryTest(String xpathTemplate, String expectedXpath, QueryReplacementParam<?> ... params) throws ArtificerUserException {
        String formattedQuery = AbstractArtificerQueryImpl.formatQuery((String)xpathTemplate, Arrays.asList(params));
        Assert.assertEquals((Object)expectedXpath, (Object)formattedQuery);
    }
}

