/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.test;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.artificer.common.ArtifactContent;
import org.artificer.common.ArtifactType;
import org.artificer.common.ArtifactTypeEnum;
import org.artificer.common.query.ArtifactSummary;
import org.artificer.repository.AuditManager;
import org.artificer.repository.PersistenceManager;
import org.artificer.repository.QueryManager;
import org.artificer.repository.RepositoryProvider;
import org.artificer.repository.RepositoryProviderFactory;
import org.artificer.repository.hibernate.HibernateAuditManager;
import org.artificer.repository.hibernate.HibernatePersistenceManager;
import org.artificer.repository.hibernate.HibernateQueryManager;
import org.artificer.repository.query.ArtificerQuery;
import org.artificer.repository.query.PagedResult;
import org.artificer.repository.test.RepositoryTestProvider;
import org.artificer.repository.test.hibernate.HibernateRepositoryTestProvider;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Target;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XmlDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public abstract class AbstractPersistenceTest {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Parameterized.Parameter(value=0)
    public TestType testType;
    protected PersistenceManager persistenceManager;
    protected QueryManager queryManager;
    protected AuditManager auditManager;
    protected RepositoryTestProvider repositoryTestProvider;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        data.add(new Object[]{TestType.HIBERNATE_BLOB});
        data.add(new Object[]{TestType.HIBERNATE_FILESYSTEM});
        return data;
    }

    @Before
    public void before() throws Exception {
        HashMap<String, String> extraProperties = new HashMap<String, String>();
        switch (this.testType) {
            case HIBERNATE_BLOB: {
                this.persistenceManager = new HibernatePersistenceManager();
                this.queryManager = new HibernateQueryManager();
                this.auditManager = new HibernateAuditManager();
                extraProperties.put("artificer.file.storage", "blob");
                this.repositoryTestProvider = new HibernateRepositoryTestProvider(extraProperties);
                break;
            }
            case HIBERNATE_FILESYSTEM: {
                this.persistenceManager = new HibernatePersistenceManager();
                this.queryManager = new HibernateQueryManager();
                this.auditManager = new HibernateAuditManager();
                extraProperties.put("artificer.file.storage", "filesystem");
                extraProperties.put("artificer.file.storage.filesystem.path", "target/test/artificer-data");
                this.repositoryTestProvider = new HibernateRepositoryTestProvider(extraProperties);
            }
        }
        RepositoryProviderFactory.overrideProvider((RepositoryProvider)new RepositoryProvider(){

            public String name() {
                return null;
            }

            public PersistenceManager persistenceManager() {
                return AbstractPersistenceTest.this.persistenceManager;
            }

            public QueryManager queryManager() {
                return AbstractPersistenceTest.this.queryManager;
            }

            public AuditManager auditManager() {
                return AbstractPersistenceTest.this.auditManager;
            }
        });
        this.repositoryTestProvider.before();
    }

    @After
    public void after() throws Exception {
        this.persistenceManager.shutdown();
        this.repositoryTestProvider.after();
    }

    @AfterClass
    public static void cleanup() {
        System.clearProperty("artificer.config.auditing.enabled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseArtifactType addArtifact(String resourcePath, String filename, XmlDocument document, BaseArtifactEnum type) throws Exception {
        InputStream contentStream = this.getClass().getResourceAsStream(resourcePath + filename);
        BaseArtifactType artifact = null;
        try {
            document.setArtifactType(type);
            document.setName(filename);
            document.setContentType("application/xml");
            artifact = this.persistenceManager.persistArtifact((BaseArtifactType)document, new ArtifactContent(filename, contentStream));
            Assert.assertNotNull((Object)artifact);
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
        return artifact;
    }

    protected BaseArtifactType addExtendedArtifact(String type, String name) throws Exception {
        BaseArtifactType artifact = ArtifactType.ExtendedArtifactType((String)type).newArtifactInstance();
        artifact.setName(name);
        artifact = this.persistenceManager.persistArtifact(artifact, null);
        Assert.assertNotNull((Object)artifact);
        return artifact;
    }

    protected BaseArtifactType assertSingleArtifact(ArtifactTypeEnum type, String name) throws Exception {
        String q = String.format("/s-ramp/%1$s/%2$s[@name = ?]", type.getModel(), type.getType());
        ArtificerQuery query = this.queryManager.createQuery(q);
        query.setString(name);
        PagedResult artifactSet = query.executeQuery();
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        ArtifactSummary arty = (ArtifactSummary)artifactSet.getResults().get(0);
        Assert.assertEquals((Object)name, (Object)arty.getName());
        return this.initArtifactAssociations(arty);
    }

    protected void assertBasic(BaseArtifactType artifact, BaseArtifactType expected) {
        Assert.assertNotNull((Object)artifact);
        Assert.assertNotNull((Object)artifact.getUuid());
        Assert.assertEquals((Object)expected.getArtifactType(), (Object)artifact.getArtifactType());
        Assert.assertEquals((Object)expected.getName(), (Object)artifact.getName());
    }

    protected BaseArtifactType getArtifactByUUID(String uuid) throws Exception {
        ArtificerQuery query = this.queryManager.createQuery("/s-ramp[@uuid = ?]");
        query.setString(uuid);
        PagedResult artifactSet = query.executeQuery();
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        return this.initArtifactAssociations((ArtifactSummary)artifactSet.getResults().get(0));
    }

    protected BaseArtifactType getArtifactByTarget(Target target) throws Exception {
        Assert.assertNotNull((String)"Missing target/relationship.", (Object)target);
        return this.getArtifactByUUID(target.getValue());
    }

    protected BaseArtifactType initArtifactAssociations(ArtifactSummary artifact) throws Exception {
        return this.persistenceManager.getArtifact(artifact.getUuid(), artifact.getArtifactType());
    }

    public static enum TestType {
        HIBERNATE_BLOB,
        HIBERNATE_FILESYSTEM;

    }
}

