/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.test;

import java.io.InputStream;
import java.net.URL;
import org.artificer.common.ArtifactContent;
import org.artificer.common.ArtifactType;
import org.artificer.common.ArtificerConstants;
import org.artificer.common.query.ArtifactSummary;
import org.artificer.repository.query.ArtificerQuery;
import org.artificer.repository.query.PagedResult;
import org.artificer.repository.test.AbstractNoAuditingPersistenceTest;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.impl.base.exporter.zip.ZipExporterImpl;
import org.junit.Assert;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;

public class ArchiveExpansionTest
extends AbstractNoAuditingPersistenceTest {
    @Test
    public void testArchiveExpansion() throws Exception {
        GenericArchive archive = (GenericArchive)ShrinkWrap.create(GenericArchive.class, (String)"test.zip");
        URL xsdUrl = this.getClass().getResource("/sample-files/wsdl/jcr-sample-externalrefs.xsd");
        URL wsdlUrl = this.getClass().getResource("/sample-files/wsdl/jcr-sample-externalrefs.wsdl");
        archive.add((Asset)new UrlAsset(xsdUrl), "foo/path/jcr-sample-externalrefs.xsd");
        archive.add((Asset)new UrlAsset(wsdlUrl), "foo/path/jcr-sample-externalrefs.wsdl");
        InputStream is = new ZipExporterImpl((Archive)archive).exportAsInputStream();
        BaseArtifactType archiveArtifact = ArtifactType.ExtendedArtifactType((String)"FooArchive").newArtifactInstance();
        archiveArtifact = this.persistenceManager.persistArtifact(archiveArtifact, new ArtifactContent("test.zip", is));
        BaseArtifactType xsdArtifact = ArtifactType.XsdDocument().newArtifactInstance();
        xsdArtifact.getOtherAttributes().put(ArtificerConstants.ARTIFICER_EXPANDED_FROM_ARCHIVE_UUID_QNAME, archiveArtifact.getUuid());
        xsdArtifact.getOtherAttributes().put(ArtificerConstants.ARTIFICER_EXPANDED_FROM_ARCHIVE_PATH_QNAME, "foo/path/jcr-sample-externalrefs.xsd");
        xsdArtifact = this.persistenceManager.persistArtifact(xsdArtifact, new ArtifactContent("foo/path/jcr-sample-externalrefs.xsd", xsdUrl.openStream()));
        BaseArtifactType wsdlArtifact = ArtifactType.WsdlDocument().newArtifactInstance();
        wsdlArtifact.getOtherAttributes().put(ArtificerConstants.ARTIFICER_EXPANDED_FROM_ARCHIVE_UUID_QNAME, archiveArtifact.getUuid());
        wsdlArtifact.getOtherAttributes().put(ArtificerConstants.ARTIFICER_EXPANDED_FROM_ARCHIVE_PATH_QNAME, "foo/path/jcr-sample-externalrefs.wsdl");
        wsdlArtifact = this.persistenceManager.persistArtifact(wsdlArtifact, new ArtifactContent("foo/path/jcr-sample-externalrefs.wsdl", wsdlUrl.openStream()));
        ArtificerQuery query = this.queryManager.createQuery("/s-ramp[@derived = 'false' and @expandedFromArchive = 'false']");
        PagedResult results = query.executeQuery();
        Assert.assertEquals((long)1L, (long)results.getTotalSize());
        Assert.assertEquals((Object)archiveArtifact.getUuid(), (Object)((ArtifactSummary)results.getResults().get(0)).getUuid());
        query = this.queryManager.createQuery("/s-ramp/xsd/XsdDocument[@derived = 'false' and @expandedFromArchive = 'true']");
        results = query.executeQuery();
        Assert.assertEquals((long)1L, (long)results.getTotalSize());
        Assert.assertEquals((Object)xsdArtifact.getUuid(), (Object)((ArtifactSummary)results.getResults().get(0)).getUuid());
        query = this.queryManager.createQuery("/s-ramp/wsdl/WsdlDocument[@derived = 'false' and @expandedFromArchive = 'true']");
        results = query.executeQuery();
        Assert.assertEquals((long)1L, (long)results.getTotalSize());
        Assert.assertEquals((Object)wsdlArtifact.getUuid(), (Object)((ArtifactSummary)results.getResults().get(0)).getUuid());
        query = this.queryManager.createQuery("/s-ramp[expandedFromArchive[@uuid=?]]");
        query.setString(archiveArtifact.getUuid());
        results = query.executeQuery();
        Assert.assertEquals((long)2L, (long)results.getTotalSize());
    }
}

