/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.test;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.artificer.common.ArtifactContent;
import org.artificer.common.ArtifactTypeEnum;
import org.artificer.repository.PersistenceManager;
import org.artificer.repository.test.AbstractNoAuditingPersistenceTest;
import org.junit.Assert;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ComplexTypeDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Document;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DocumentArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ElementDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Message;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Part;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.SimpleTypeDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Target;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdDocument;

public class BatchPersistenceTest
extends AbstractNoAuditingPersistenceTest {
    @Test
    public void testSimpleBatch() throws Exception {
        ArrayList<PersistenceManager.BatchItem> items = new ArrayList<PersistenceManager.BatchItem>();
        PersistenceManager.BatchItem item = this.createBatchItem("/sample-files/batch/simple-1.txt", (DocumentArtifactType)new Document(), BaseArtifactEnum.DOCUMENT);
        items.add(item);
        item = this.createBatchItem("/sample-files/batch/simple-2.txt", (DocumentArtifactType)new Document(), BaseArtifactEnum.DOCUMENT);
        items.add(item);
        List response = this.persistenceManager.persistBatch(items);
        BaseArtifactType simple1 = (BaseArtifactType)response.get(0);
        BaseArtifactType simple2 = (BaseArtifactType)response.get(1);
        Assert.assertEquals((Object)"simple-1.txt", (Object)simple1.getName());
        Assert.assertEquals((Object)"simple-2.txt", (Object)simple2.getName());
    }

    @Test
    public void testWsdlBatch() throws Exception {
        ArrayList<PersistenceManager.BatchItem> items = new ArrayList<PersistenceManager.BatchItem>();
        PersistenceManager.BatchItem item = this.createBatchItem("/sample-files/wsdl/jcr-sample-externalrefs.xsd", (DocumentArtifactType)new XsdDocument(), BaseArtifactEnum.XSD_DOCUMENT);
        items.add(item);
        item = this.createBatchItem("/sample-files/wsdl/jcr-sample-externalrefs.wsdl", (DocumentArtifactType)new WsdlDocument(), BaseArtifactEnum.WSDL_DOCUMENT);
        items.add(item);
        List response = this.persistenceManager.persistBatch(items);
        XsdDocument xsd = (XsdDocument)response.get(0);
        Assert.assertNotNull((Object)xsd);
        Assert.assertEquals((Object)"jcr-sample-externalrefs.xsd", (Object)xsd.getName());
        Assert.assertEquals((Object)"urn:s-ramp:test:jcr-sample-externalrefs:types", (Object)xsd.getTargetNamespace());
        WsdlDocument wsdl = (WsdlDocument)response.get(1);
        Assert.assertNotNull((Object)wsdl);
        Assert.assertEquals((Object)"jcr-sample-externalrefs.wsdl", (Object)wsdl.getName());
        Assert.assertEquals((Object)"http://ewittman.redhat.com/sample/2012/09/wsdl/sample.wsdl", (Object)wsdl.getTargetNamespace());
        ElementDeclaration extInput = (ElementDeclaration)this.assertSingleArtifact(ArtifactTypeEnum.ElementDeclaration, "extInput");
        ComplexTypeDeclaration extOutputType = (ComplexTypeDeclaration)this.assertSingleArtifact(ArtifactTypeEnum.ComplexTypeDeclaration, "extOutputType");
        SimpleTypeDeclaration extSimpleType = (SimpleTypeDeclaration)this.assertSingleArtifact(ArtifactTypeEnum.SimpleTypeDeclaration, "extSimpleType");
        Message findRequestMessage = (Message)this.assertSingleArtifact(ArtifactTypeEnum.Message, "findRequest");
        Message findResponseMessage = (Message)this.assertSingleArtifact(ArtifactTypeEnum.Message, "findResponse");
        Message findRequestSimpleMessage = (Message)this.assertSingleArtifact(ArtifactTypeEnum.Message, "findRequestSimple");
        Part part = (Part)this.getArtifactByTarget((Target)findRequestMessage.getPart().get(0));
        Assert.assertNull((Object)part.getType());
        ElementDeclaration elem = (ElementDeclaration)this.getArtifactByTarget((Target)part.getElement());
        Assert.assertEquals((Object)extInput.getUuid(), (Object)elem.getUuid());
        part = (Part)this.getArtifactByTarget((Target)findResponseMessage.getPart().get(0));
        Assert.assertNull((Object)part.getElement());
        ComplexTypeDeclaration complexType = (ComplexTypeDeclaration)this.getArtifactByTarget((Target)part.getType());
        Assert.assertEquals((Object)extOutputType.getUuid(), (Object)complexType.getUuid());
        part = (Part)this.getArtifactByTarget((Target)findRequestSimpleMessage.getPart().get(0));
        Assert.assertNull((Object)part.getElement());
        SimpleTypeDeclaration type = (SimpleTypeDeclaration)this.getArtifactByTarget((Target)part.getType());
        Assert.assertEquals((Object)extSimpleType.getUuid(), (Object)type.getUuid());
    }

    private PersistenceManager.BatchItem createBatchItem(String filePath, DocumentArtifactType document, BaseArtifactEnum type) throws Exception {
        String artifactFileName = filePath.substring(filePath.lastIndexOf(47) + 1);
        InputStream contentStream = this.getClass().getResourceAsStream(filePath);
        document.setArtifactType(type);
        document.setName(artifactFileName);
        return new PersistenceManager.BatchItem(filePath, (BaseArtifactType)document, new ArtifactContent(artifactFileName, contentStream));
    }
}

