/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.test;

import java.io.InputStream;
import org.artificer.common.ArtifactContent;
import org.artificer.common.ArtifactType;
import org.artificer.common.ArtificerException;
import org.artificer.common.ontology.ArtificerOntology;
import org.artificer.common.ontology.ArtificerOntologyClass;
import org.artificer.repository.test.AbstractNoAuditingPersistenceTest;
import org.junit.Assert;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Document;

public class ClassificationPersistenceTest
extends AbstractNoAuditingPersistenceTest {
    @Test
    public void testPersistClassifications() throws Exception {
        ArtificerOntology ontology = this.createOntology();
        String artifactFileName = "s-ramp-press-release.pdf";
        InputStream contentStream = this.getClass().getResourceAsStream("/sample-files/core/" + artifactFileName);
        Document document = new Document();
        document.setName(artifactFileName);
        document.setArtifactType(BaseArtifactEnum.DOCUMENT);
        document.getClassifiedBy().add(ontology.findClass("China").getUri());
        BaseArtifactType artifact = this.persistenceManager.persistArtifact((BaseArtifactType)document, new ArtifactContent(artifactFileName, contentStream));
        Assert.assertNotNull((Object)artifact);
        if (this.log.isDebugEnabled()) {
            this.persistenceManager.printArtifactGraph(artifact.getUuid(), ArtifactType.Document());
        }
        artifact = this.persistenceManager.getArtifact(artifact.getUuid(), ArtifactType.Document());
        Assert.assertNotNull((Object)artifact.getClassifiedBy());
        Assert.assertEquals((long)1L, (long)artifact.getClassifiedBy().size());
        Assert.assertEquals((Object)"urn:example.org/test2#China", artifact.getClassifiedBy().get(0));
    }

    private ArtificerOntology createOntology() throws ArtificerException {
        ArtificerOntology ontology = new ArtificerOntology();
        ontology.setBase("urn:example.org/test2");
        ontology.setLabel("Test Ontology #2");
        ontology.setComment("This is my second test ontology.");
        ArtificerOntologyClass world = this.createClass(ontology, null, "World", "World", "The entire world");
        ArtificerOntologyClass asia = this.createClass(ontology, world, "Asia", "Asia", null);
        ArtificerOntologyClass europe = this.createClass(ontology, world, "Europe", "Europe", "Two world wars");
        ArtificerOntologyClass japan = this.createClass(ontology, asia, "Japan", "Japan", "Samurai *and* ninja?  Not fair.");
        ArtificerOntologyClass china = this.createClass(ontology, asia, "China", "China", "Gunpowder!");
        ArtificerOntologyClass uk = this.createClass(ontology, europe, "UnitedKingdom", "United Kingdom", "The food could be better");
        ArtificerOntologyClass germany = this.createClass(ontology, europe, "Germany", "Germany", "The fatherland");
        ontology.getRootClasses().add(world);
        world.getChildren().add(asia);
        world.getChildren().add(europe);
        asia.getChildren().add(japan);
        asia.getChildren().add(china);
        europe.getChildren().add(uk);
        europe.getChildren().add(germany);
        return this.persistenceManager.persistOntology(ontology);
    }

    private ArtificerOntologyClass createClass(ArtificerOntology ontology, ArtificerOntologyClass parent, String id, String label, String comment) {
        ArtificerOntologyClass rval = ontology.createClass(id);
        rval.setParent(parent);
        rval.setComment(comment);
        rval.setLabel(label);
        return rval;
    }
}

