/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.test;

import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.artificer.common.ArtifactContent;
import org.artificer.common.ArtificerException;
import org.artificer.common.ontology.ArtificerOntology;
import org.artificer.common.ontology.ArtificerOntologyClass;
import org.artificer.common.query.ArtifactSummary;
import org.artificer.repository.query.ArtificerQuery;
import org.artificer.repository.query.PagedResult;
import org.artificer.repository.test.AbstractNoAuditingPersistenceTest;
import org.junit.Assert;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Document;

public class ClassificationQueryTest
extends AbstractNoAuditingPersistenceTest {
    @Test
    public void testDerivedRelationshipQueries() throws Exception {
        this.createOntology();
        Document doc = this.addDocument("no-classifications", new String[0]);
        Document docChina = this.addDocument("one-classification: china", "China");
        Document docJapan = this.addDocument("one-classification: japan", "Japan");
        Document docGermany = this.addDocument("one-classification: germany", "Germany");
        ArtificerQuery query = this.queryManager.createQuery("/s-ramp/core/Document");
        PagedResult artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)4L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/core/Document[@name = ?]");
        query.setString("no-classifications");
        artifactSet = query.executeQuery();
        this.assertResults((PagedResult<ArtifactSummary>)artifactSet, doc);
        query = this.queryManager.createQuery("/s-ramp/core/Document[s-ramp:exactlyClassifiedByAllOf(., 'China')]");
        artifactSet = query.executeQuery();
        this.assertResults((PagedResult<ArtifactSummary>)artifactSet, docChina);
        query = this.queryManager.createQuery("/s-ramp/core/Document[s-ramp:exactlyClassifiedByAllOf(., 'Asia')]");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)0L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/core/Document[s-ramp:exactlyClassifiedByAllOf(., 'Germany')]");
        artifactSet = query.executeQuery();
        this.assertResults((PagedResult<ArtifactSummary>)artifactSet, docGermany);
        query = this.queryManager.createQuery("/s-ramp/core/Document[s-ramp:exactlyClassifiedByAllOf(., 'China', 'Germany')]");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)0L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/core/Document[s-ramp:classifiedByAllOf(., 'World')]");
        artifactSet = query.executeQuery();
        this.assertResults((PagedResult<ArtifactSummary>)artifactSet, docJapan, docChina, docGermany);
        query = this.queryManager.createQuery("/s-ramp/core/Document[s-ramp:classifiedByAllOf(., 'Asia')]");
        artifactSet = query.executeQuery();
        this.assertResults((PagedResult<ArtifactSummary>)artifactSet, docJapan, docChina);
        query = this.queryManager.createQuery("/s-ramp/core/Document[s-ramp:classifiedByAnyOf(., 'Japan', 'China')]");
        artifactSet = query.executeQuery();
        this.assertResults((PagedResult<ArtifactSummary>)artifactSet, docJapan, docChina);
        query = this.queryManager.createQuery("/s-ramp/core/Document[xp2:not(s-ramp:classifiedByAnyOf(., 'Japan', 'China'))]");
        artifactSet = query.executeQuery();
        this.assertResults((PagedResult<ArtifactSummary>)artifactSet, doc, docGermany);
    }

    private void assertResults(PagedResult<ArtifactSummary> artifactSet, Document ... docs) throws Exception {
        Assert.assertNotNull(artifactSet);
        Assert.assertEquals((long)docs.length, (long)artifactSet.getTotalSize());
        List artifacts = artifactSet.getResults();
        for (ArtifactSummary artifact : artifacts) {
            boolean found = false;
            for (Document doc : docs) {
                if (!doc.getUuid().equals(artifact.getUuid())) continue;
                found = true;
            }
            Assert.assertTrue((boolean)found);
        }
    }

    private ArtificerOntology createOntology() throws ArtificerException {
        ArtificerOntology ontology = new ArtificerOntology();
        ontology.setBase("urn:example.org/test2");
        ontology.setLabel("Test Ontology #2");
        ontology.setComment("This is my second test ontology.");
        ArtificerOntologyClass world = this.createClass(ontology, null, "World", "World", "The entire world");
        ArtificerOntologyClass asia = this.createClass(ontology, world, "Asia", "Asia", null);
        ArtificerOntologyClass europe = this.createClass(ontology, world, "Europe", "Europe", "Two world wars");
        ArtificerOntologyClass japan = this.createClass(ontology, asia, "Japan", "Japan", "Samurai *and* ninja?  Not fair.");
        ArtificerOntologyClass china = this.createClass(ontology, asia, "China", "China", "Gunpowder!");
        ArtificerOntologyClass uk = this.createClass(ontology, europe, "UnitedKingdom", "United Kingdom", "The food could be better");
        ArtificerOntologyClass germany = this.createClass(ontology, europe, "Germany", "Germany", "The fatherland");
        ontology.getRootClasses().add(world);
        world.getChildren().add(asia);
        world.getChildren().add(europe);
        asia.getChildren().add(japan);
        asia.getChildren().add(china);
        europe.getChildren().add(uk);
        europe.getChildren().add(germany);
        return this.persistenceManager.persistOntology(ontology);
    }

    private ArtificerOntologyClass createClass(ArtificerOntology ontology, ArtificerOntologyClass parent, String id, String label, String comment) {
        ArtificerOntologyClass rval = ontology.createClass(id);
        rval.setParent(parent);
        rval.setComment(comment);
        rval.setLabel(label);
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document addDocument(String name, String ... classifications) throws Exception {
        Document document;
        InputStream contentStream = null;
        try {
            String artifactFileName = "s-ramp-press-release.pdf";
            contentStream = this.getClass().getResourceAsStream("/sample-files/core/" + artifactFileName);
            Document document2 = new Document();
            document2.setName(name);
            document2.setArtifactType(BaseArtifactEnum.DOCUMENT);
            for (String classification : classifications) {
                document2.getClassifiedBy().add(classification);
            }
            document = (Document)this.persistenceManager.persistArtifact((BaseArtifactType)document2, new ArtifactContent(artifactFileName, contentStream));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(contentStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)contentStream);
        return document;
    }
}

