/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.test;

import java.io.InputStream;
import org.artificer.common.ArtifactContent;
import org.artificer.common.ArtifactType;
import org.artificer.common.ArtificerModelUtils;
import org.artificer.common.error.ArtificerConflictException;
import org.artificer.common.query.ArtifactSummary;
import org.artificer.repository.query.PagedResult;
import org.artificer.repository.test.AbstractNoAuditingPersistenceTest;
import org.junit.Assert;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Actor;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Task;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.TaskEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.TaskTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdDocument;

public class ConstraintTest
extends AbstractNoAuditingPersistenceTest {
    @Test
    public void testDelete() throws Exception {
        Task task = new Task();
        task.setArtifactType(BaseArtifactEnum.TASK);
        task = (Task)this.persistenceManager.persistArtifact((BaseArtifactType)task, null);
        Actor actor = new Actor();
        actor.setArtifactType(BaseArtifactEnum.ACTOR);
        ArtificerModelUtils.addGenericRelationship((BaseArtifactType)actor, (String)"fooRelationship", (String)task.getUuid());
        actor = (Actor)this.persistenceManager.persistArtifact((BaseArtifactType)actor, null);
        boolean caught = false;
        try {
            this.persistenceManager.deleteArtifact(task.getUuid(), ArtifactType.valueOf((BaseArtifactType)task), false);
        }
        catch (ArtificerConflictException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        actor.getRelationship().clear();
        TaskTarget taskTarget = new TaskTarget();
        taskTarget.setArtifactType(TaskEnum.TASK);
        taskTarget.setValue(task.getUuid());
        actor.getDoes().add(taskTarget);
        this.persistenceManager.updateArtifact((BaseArtifactType)actor, ArtifactType.valueOf((BaseArtifactType)task));
        caught = false;
        try {
            this.persistenceManager.deleteArtifact(task.getUuid(), ArtifactType.valueOf((BaseArtifactType)task), false);
        }
        catch (ArtificerConflictException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        actor.getDoes().clear();
        this.persistenceManager.updateArtifact((BaseArtifactType)actor, ArtifactType.valueOf((BaseArtifactType)task));
        this.persistenceManager.deleteArtifact(task.getUuid(), ArtifactType.valueOf((BaseArtifactType)task), false);
    }

    @Test
    public void testDeleteWithDerived() throws Exception {
        XsdDocument xsd = this.addXsd();
        WsdlDocument wsdl = this.addWsdl();
        BaseArtifactType fooArtifact = this.addWithGenericRelationship();
        boolean caught = false;
        try {
            this.persistenceManager.deleteArtifact(xsd.getUuid(), ArtifactType.valueOf((BaseArtifactType)xsd), false);
        }
        catch (ArtificerConflictException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        this.persistenceManager.deleteArtifact(fooArtifact.getUuid(), ArtifactType.valueOf((BaseArtifactType)fooArtifact), false);
        caught = false;
        try {
            this.persistenceManager.deleteArtifact(xsd.getUuid(), ArtifactType.valueOf((BaseArtifactType)xsd), false);
        }
        catch (ArtificerConflictException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        this.persistenceManager.deleteArtifact(wsdl.getUuid(), ArtifactType.valueOf((BaseArtifactType)wsdl), false);
        this.persistenceManager.deleteArtifact(xsd.getUuid(), ArtifactType.valueOf((BaseArtifactType)xsd), false);
        PagedResult derived = this.queryManager.createQuery("/s-ramp/xsd/ComplexTypeDeclaration").executeQuery();
        Assert.assertEquals((long)0L, (long)derived.getTotalSize());
    }

    @Test
    public void testForceDeleteWithDerived() throws Exception {
        XsdDocument xsd = this.addXsd();
        this.addWsdl();
        this.addWithGenericRelationship();
        this.persistenceManager.deleteArtifact(xsd.getUuid(), ArtifactType.valueOf((BaseArtifactType)xsd), true);
        PagedResult derived = this.queryManager.createQuery("/s-ramp/xsd/ComplexTypeDeclaration").executeQuery();
        Assert.assertEquals((long)0L, (long)derived.getTotalSize());
    }

    private XsdDocument addXsd() throws Exception {
        String xsdFileName = "jcr-sample-externalrefs.xsd";
        InputStream is = this.getClass().getResourceAsStream("/sample-files/wsdl/" + xsdFileName);
        XsdDocument xsd = new XsdDocument();
        xsd.setName(xsdFileName);
        xsd.setArtifactType(BaseArtifactEnum.XSD_DOCUMENT);
        return (XsdDocument)this.persistenceManager.persistArtifact((BaseArtifactType)xsd, new ArtifactContent(xsdFileName, is));
    }

    private WsdlDocument addWsdl() throws Exception {
        String wsdlFileName = "jcr-sample-externalrefs.wsdl";
        InputStream is = this.getClass().getResourceAsStream("/sample-files/wsdl/" + wsdlFileName);
        WsdlDocument wsdl = new WsdlDocument();
        wsdl.setName(wsdlFileName);
        wsdl.setArtifactType(BaseArtifactEnum.WSDL_DOCUMENT);
        return (WsdlDocument)this.persistenceManager.persistArtifact((BaseArtifactType)wsdl, new ArtifactContent(wsdlFileName, is));
    }

    private BaseArtifactType addWithGenericRelationship() throws Exception {
        ArtifactSummary complexType = (ArtifactSummary)this.queryManager.createQuery("/s-ramp/xsd/ComplexTypeDeclaration").executeQuery().getResults().get(0);
        BaseArtifactType fooArtifact = ArtifactType.ExtendedArtifactType((String)"FooType", (boolean)false).newArtifactInstance();
        ArtificerModelUtils.addGenericRelationship((BaseArtifactType)fooArtifact, (String)"fooRelationship", (String)complexType.getUuid());
        return this.persistenceManager.persistArtifact(fooArtifact, null);
    }
}

