/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.test;

import java.io.InputStream;
import org.artificer.common.ArtifactContent;
import org.artificer.repository.query.ArtificerQuery;
import org.artificer.repository.query.PagedResult;
import org.artificer.repository.test.AbstractNoAuditingPersistenceTest;
import org.junit.Assert;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedDocument;

public class ExtendedArtifactDeriverTest
extends AbstractNoAuditingPersistenceTest {
    @Test
    public void testExtendedArtifactDeriver() throws Exception {
        String artifactFileName = "gtgjrdih.xml";
        InputStream pdf = this.getClass().getResourceAsStream("/sample-files/ext/" + artifactFileName);
        ExtendedDocument artifact = new ExtendedDocument();
        artifact.setArtifactType(BaseArtifactEnum.EXTENDED_DOCUMENT);
        artifact.setExtendedType("ExtendedArtifactDeriverTestDocument");
        artifact.setName("jrd");
        BaseArtifactType pa = this.persistenceManager.persistArtifact((BaseArtifactType)artifact, new ArtifactContent(artifactFileName, pdf));
        Assert.assertNotNull((Object)pa);
        this.log.info("persisted gtgjrdih.xml, returned artifact uuid=" + pa.getUuid());
        Assert.assertEquals(ExtendedDocument.class, artifact.getClass());
        ArtificerQuery query = this.queryManager.createQuery("/s-ramp/ext/ActingCredit");
        PagedResult artifactSet = query.executeQuery();
        Assert.assertEquals((long)4L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp[@derived='true']");
        artifactSet = query.executeQuery();
        Assert.assertEquals((long)4L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/ext[relatedDocument[@name='jrd']]");
        artifactSet = query.executeQuery();
        Assert.assertEquals((long)4L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/ext[relatedDocument[@name='jrd'] and @name='Rising Storm']");
        artifactSet = query.executeQuery();
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/ext[hasCredit[@name='Rising Storm']]");
        artifactSet = query.executeQuery();
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/ext[hasCredit[@name='Army of Darkness']]");
        artifactSet = query.executeQuery();
        Assert.assertEquals((long)0L, (long)artifactSet.getTotalSize());
    }
}

