/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.test;

import java.util.List;
import org.artificer.common.ArtifactTypeEnum;
import org.artificer.repository.test.AbstractNoAuditingPersistenceTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Actor;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ActorEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ActorTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Choreography;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ChoreographyProcess;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Collaboration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.CollaborationProcess;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Composition;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DerivedArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DerivedArtifactTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DocumentArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DocumentArtifactTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Effect;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.EffectEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.EffectTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Element;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ElementEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ElementTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Event;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.EventEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.EventTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.InformationType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Operation;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Orchestration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OrchestrationEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OrchestrationProcess;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OrchestrationProcessEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OrchestrationProcessTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OrchestrationTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Organization;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Policy;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PolicyEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PolicySubject;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PolicyTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Port;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PortType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Process;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Service;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceComposition;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceContract;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceContractEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceContractTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceEndpoint;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceImplementationModelEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceImplementationModelTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceInstance;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceInstanceEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceInstanceTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceInterface;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceInterfaceEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceInterfaceTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceOperation;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceOperationEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceOperationTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.SoaModelType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.SoapAddress;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.System;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Target;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Task;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.TaskEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.TaskTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XmlDocument;

public class LogicalModelTest
extends AbstractNoAuditingPersistenceTest {
    private WsdlDocument wsdl;
    private Operation operation;
    private Port port;
    private ServiceEndpoint serviceEndpoint;
    private ServiceInstance serviceInstance;
    private ServiceOperation serviceOperation;
    private DerivedArtifactTarget derivedOperationTarget;
    private DerivedArtifactTarget derivedPortTarget;
    private DerivedArtifactTarget derivedPortTypeTarget;
    private DocumentArtifactTarget documentationTarget;
    private Element element1;
    private ElementTarget elementTarget1;
    private Element element2;
    private ElementTarget elementTarget2;
    private Event event1;
    private EventTarget eventTarget1;
    private Event event2;
    private EventTarget eventTarget2;
    private Event event3;
    private EventTarget eventTarget3;
    private Orchestration orchestration1;
    private OrchestrationTarget orchestrationTarget1;
    private OrchestrationProcess orchestrationProcess1;
    private OrchestrationProcessTarget orchestrationProcessTarget1;
    private Policy policy1;
    private PolicyTarget policyTarget1;
    private Service service1;
    private ServiceTarget serviceTarget1;
    private Task task1;
    private TaskTarget taskTarget1;
    private int counter = 0;

    @Test
    public void testServiceImplementationModel() throws Exception {
        ServiceEndpoint persistedServiceEndpoint = (ServiceEndpoint)this.getArtifactByUUID(this.serviceEndpoint.getUuid());
        this.assertBasic((BaseArtifactType)persistedServiceEndpoint, (BaseArtifactType)this.serviceEndpoint);
        this.assertDocumentation(persistedServiceEndpoint.getDocumentation());
        Assert.assertEquals((Object)this.serviceEndpoint.getUrl(), (Object)persistedServiceEndpoint.getUrl());
        Port portByTarget = (Port)this.getArtifactByTarget((Target)persistedServiceEndpoint.getEndpointDefinedBy());
        this.assertBasic((BaseArtifactType)portByTarget, (BaseArtifactType)this.port);
        ServiceInstance persistedServiceInstance = (ServiceInstance)this.getArtifactByUUID(this.serviceInstance.getUuid());
        this.assertBasic((BaseArtifactType)persistedServiceInstance, (BaseArtifactType)this.serviceInstance);
        this.assertDocumentation(persistedServiceInstance.getDocumentation());
        this.assertTargets(persistedServiceInstance.getUses(), 1, new BaseArtifactType[]{this.port});
        this.assertTargets(persistedServiceInstance.getDescribedBy(), 1, new BaseArtifactType[]{this.wsdl});
        ServiceOperation persistedServiceOperation = (ServiceOperation)this.getArtifactByUUID(this.serviceOperation.getUuid());
        this.assertBasic((BaseArtifactType)persistedServiceOperation, (BaseArtifactType)this.serviceOperation);
        this.assertDocumentation(persistedServiceOperation.getDocumentation());
        Operation operationByTarget = (Operation)this.getArtifactByTarget((Target)persistedServiceOperation.getOperationDefinedBy());
        this.assertBasic((BaseArtifactType)operationByTarget, (BaseArtifactType)this.operation);
    }

    @Test
    public void testSOAModel() throws Exception {
        this.insertSoaArtifacts();
        Effect effect = new Effect();
        effect.setArtifactType(BaseArtifactEnum.EFFECT);
        this.persistAndAssert(effect);
        EffectTarget effectTarget = new EffectTarget();
        effectTarget.setArtifactType(EffectEnum.EFFECT);
        effectTarget.setValue(effect.getUuid());
        Event event = new Event();
        event.setArtifactType(BaseArtifactEnum.EVENT);
        this.persistAndAssert(event);
        InformationType informationType = new InformationType();
        informationType.setArtifactType(BaseArtifactEnum.INFORMATION_TYPE);
        this.persistAndAssert(informationType);
        Policy policy = new Policy();
        policy.setArtifactType(BaseArtifactEnum.POLICY);
        this.persistAndAssert(policy);
        PolicySubject policySubject = new PolicySubject();
        policySubject.setArtifactType(BaseArtifactEnum.POLICY_SUBJECT);
        this.persistAndAssert(policySubject);
        Element element = new Element();
        element.setArtifactType(BaseArtifactEnum.ELEMENT);
        this.persistAndAssertElement(element);
        Actor actor = new Actor();
        actor.setArtifactType(BaseArtifactEnum.ACTOR);
        this.persistAndAssertActor(actor);
        ActorTarget actorTarget = new ActorTarget();
        actorTarget.setArtifactType(ActorEnum.ACTOR);
        actorTarget.setValue(actor.getUuid());
        Organization organization = new Organization();
        organization.setArtifactType(BaseArtifactEnum.ORGANIZATION);
        ServiceImplementationModelTarget serviceImplementationModelTarget = new ServiceImplementationModelTarget();
        serviceImplementationModelTarget.setArtifactType(ServiceImplementationModelEnum.SERVICE_ENDPOINT);
        serviceImplementationModelTarget.setValue(this.serviceEndpoint.getUuid());
        organization.getProvides().add(serviceImplementationModelTarget);
        organization = (Organization)this.persistAndAssertActor((Actor)organization);
        this.assertTargets(organization.getProvides(), 1, new BaseArtifactType[]{this.serviceEndpoint});
        ServiceContract serviceContract = new ServiceContract();
        serviceContract.setArtifactType(BaseArtifactEnum.SERVICE_CONTRACT);
        serviceContract.getInvolvesParty().add(actorTarget);
        serviceContract.getSpecifies().add(effectTarget);
        serviceContract = this.persistAndAssert(serviceContract);
        this.assertTargets(serviceContract.getInvolvesParty(), 1, new BaseArtifactType[]{actor});
        this.assertTargets(serviceContract.getSpecifies(), 1, new BaseArtifactType[]{effect});
        ServiceContractTarget serviceContractTarget = new ServiceContractTarget();
        serviceContractTarget.setArtifactType(ServiceContractEnum.SERVICE_CONTRACT);
        serviceContractTarget.setValue(serviceContract.getUuid());
        ServiceInterface serviceInterface = new ServiceInterface();
        serviceInterface.setArtifactType(BaseArtifactEnum.SERVICE_INTERFACE);
        serviceInterface.setInterfaceDefinedBy(this.derivedPortTypeTarget);
        ServiceOperationTarget serviceOperationTarget = new ServiceOperationTarget();
        serviceOperationTarget.setArtifactType(ServiceOperationEnum.SERVICE_OPERATION);
        serviceOperationTarget.setValue(this.serviceOperation.getUuid());
        serviceInterface.setHasOperation(serviceOperationTarget);
        serviceInterface = this.persistAndAssert(serviceInterface);
        this.assertTarget(serviceInterface.getHasOperation(), (BaseArtifactType)this.serviceOperation);
        ServiceInterfaceTarget serviceInterfaceTarget = new ServiceInterfaceTarget();
        serviceInterfaceTarget.setArtifactType(ServiceInterfaceEnum.SERVICE_INTERFACE);
        serviceInterfaceTarget.setValue(serviceInterface.getUuid());
        Service service = new Service();
        service.setArtifactType(BaseArtifactEnum.SERVICE);
        service.getHasContract().add(serviceContractTarget);
        service.getHasInterface().add(serviceInterfaceTarget);
        ServiceInstanceTarget serviceInstanceTarget = new ServiceInstanceTarget();
        serviceInstanceTarget.setArtifactType(ServiceInstanceEnum.SERVICE_INSTANCE);
        serviceInstanceTarget.setValue(this.serviceInstance.getUuid());
        service.setHasInstance(serviceInstanceTarget);
        service = (Service)this.persistAndAssertElement((Element)service);
        this.assertTargets(service.getHasContract(), 1, new BaseArtifactType[]{serviceContract});
        this.assertTargets(service.getHasInterface(), 1, new BaseArtifactType[]{serviceInterface});
        this.assertTarget(service.getHasInstance(), (BaseArtifactType)this.serviceInstance);
        System system = new System();
        system.setArtifactType(BaseArtifactEnum.SYSTEM);
        this.persistAndAssertElement((Element)system);
        Composition composition = new Composition();
        composition.setArtifactType(BaseArtifactEnum.COMPOSITION);
        this.persistAndAssertElement((Element)composition);
        Choreography choreography = new Choreography();
        choreography.setArtifactType(BaseArtifactEnum.CHOREOGRAPHY);
        this.persistAndAssertElement((Element)choreography);
        Collaboration collaboration = new Collaboration();
        collaboration.setArtifactType(BaseArtifactEnum.COLLABORATION);
        this.persistAndAssertElement((Element)collaboration);
        Orchestration orchestration = new Orchestration();
        orchestration.setArtifactType(BaseArtifactEnum.ORCHESTRATION);
        this.persistAndAssertElement((Element)orchestration);
        Process process = new Process();
        process.setArtifactType(BaseArtifactEnum.PROCESS);
        this.persistAndAssertElement((Element)process);
        ChoreographyProcess choreographyProcess = new ChoreographyProcess();
        choreographyProcess.setArtifactType(BaseArtifactEnum.CHOREOGRAPHY_PROCESS);
        this.persistAndAssertElement((Element)choreographyProcess);
        CollaborationProcess collaborationProcess = new CollaborationProcess();
        collaborationProcess.setArtifactType(BaseArtifactEnum.COLLABORATION_PROCESS);
        this.persistAndAssertElement((Element)collaborationProcess);
        OrchestrationProcess orchestrationProcess = new OrchestrationProcess();
        orchestrationProcess.setArtifactType(BaseArtifactEnum.ORCHESTRATION_PROCESS);
        this.persistAndAssertElement((Element)orchestrationProcess);
        ServiceComposition serviceComposition = new ServiceComposition();
        serviceComposition.setArtifactType(BaseArtifactEnum.SERVICE_COMPOSITION);
        this.persistAndAssertElement((Element)serviceComposition);
        Task task = new Task();
        task.setArtifactType(BaseArtifactEnum.TASK);
        this.persistAndAssertElement((Element)task);
    }

    @Before
    public void insertArtifacts() throws Exception {
        this.wsdl = (WsdlDocument)this.addArtifact("/sample-files/wsdl/", "jcr-sample.wsdl", (XmlDocument)new WsdlDocument(), BaseArtifactEnum.WSDL_DOCUMENT);
        PortType portType = (PortType)this.assertSingleArtifact(ArtifactTypeEnum.PortType, "SamplePortType");
        this.operation = (Operation)this.assertSingleArtifact(ArtifactTypeEnum.Operation, "findSimple");
        this.port = (Port)this.assertSingleArtifact(ArtifactTypeEnum.Port, "SamplePort");
        SoapAddress soapAddress = (SoapAddress)this.getArtifactByTarget((Target)this.port.getExtension().get(0));
        this.derivedPortTypeTarget = new DerivedArtifactTarget();
        this.derivedPortTypeTarget.setArtifactType(DerivedArtifactEnum.PORT_TYPE);
        this.derivedPortTypeTarget.setValue(portType.getUuid());
        this.documentationTarget = new DocumentArtifactTarget();
        this.documentationTarget.setArtifactType(DocumentArtifactEnum.WSDL_DOCUMENT);
        this.documentationTarget.setValue(this.wsdl.getUuid());
        this.serviceEndpoint = new ServiceEndpoint();
        this.serviceEndpoint.setArtifactType(BaseArtifactEnum.SERVICE_ENDPOINT);
        this.serviceEndpoint.setName("SampleServiceEndpoint");
        this.serviceEndpoint.setUrl(soapAddress.getSoapLocation());
        this.serviceEndpoint.getDocumentation().add(this.documentationTarget);
        this.derivedPortTarget = new DerivedArtifactTarget();
        this.derivedPortTarget.setArtifactType(DerivedArtifactEnum.PORT);
        this.derivedPortTarget.setValue(this.port.getUuid());
        this.serviceEndpoint.setEndpointDefinedBy(this.derivedPortTarget);
        this.serviceEndpoint = (ServiceEndpoint)this.persistenceManager.persistArtifact((BaseArtifactType)this.serviceEndpoint, null);
        this.serviceInstance = new ServiceInstance();
        this.serviceInstance.setArtifactType(BaseArtifactEnum.SERVICE_INSTANCE);
        this.serviceInstance.setName("SampleServiceInstance");
        this.serviceInstance.getDocumentation().add(this.documentationTarget);
        BaseArtifactTarget portTarget = new BaseArtifactTarget();
        portTarget.setArtifactType(BaseArtifactEnum.PORT);
        portTarget.setValue(this.port.getUuid());
        this.serviceInstance.getUses().add(portTarget);
        BaseArtifactTarget wsdlTarget = new BaseArtifactTarget();
        wsdlTarget.setArtifactType(BaseArtifactEnum.WSDL_DOCUMENT);
        wsdlTarget.setValue(this.wsdl.getUuid());
        this.serviceInstance.getDescribedBy().add(wsdlTarget);
        this.serviceInstance = (ServiceInstance)this.persistenceManager.persistArtifact((BaseArtifactType)this.serviceInstance, null);
        this.serviceOperation = new ServiceOperation();
        this.serviceOperation.setArtifactType(BaseArtifactEnum.SERVICE_OPERATION);
        this.serviceOperation.setName("SampleServiceOperation");
        this.serviceOperation.getDocumentation().add(this.documentationTarget);
        this.derivedOperationTarget = new DerivedArtifactTarget();
        this.derivedOperationTarget.setArtifactType(DerivedArtifactEnum.OPERATION);
        this.derivedOperationTarget.setValue(this.operation.getUuid());
        this.serviceOperation.setOperationDefinedBy(this.derivedOperationTarget);
        this.serviceOperation = (ServiceOperation)this.persistenceManager.persistArtifact((BaseArtifactType)this.serviceOperation, null);
    }

    private void insertSoaArtifacts() throws Exception {
        this.element1 = new Element();
        this.element1.setArtifactType(BaseArtifactEnum.ELEMENT);
        this.element1 = this.persistAndAssert(this.element1);
        this.elementTarget1 = new ElementTarget();
        this.elementTarget1.setArtifactType(ElementEnum.ELEMENT);
        this.elementTarget1.setValue(this.element1.getUuid());
        this.element2 = new Element();
        this.element2.setArtifactType(BaseArtifactEnum.ELEMENT);
        this.element2 = this.persistAndAssert(this.element2);
        this.elementTarget2 = new ElementTarget();
        this.elementTarget2.setArtifactType(ElementEnum.ELEMENT);
        this.elementTarget2.setValue(this.element2.getUuid());
        this.event1 = new Event();
        this.event1.setArtifactType(BaseArtifactEnum.EVENT);
        this.event1 = this.persistAndAssert(this.event1);
        this.eventTarget1 = new EventTarget();
        this.eventTarget1.setArtifactType(EventEnum.EVENT);
        this.eventTarget1.setValue(this.event1.getUuid());
        this.event2 = new Event();
        this.event2.setArtifactType(BaseArtifactEnum.EVENT);
        this.event2 = this.persistAndAssert(this.event2);
        this.eventTarget2 = new EventTarget();
        this.eventTarget2.setArtifactType(EventEnum.EVENT);
        this.eventTarget2.setValue(this.event2.getUuid());
        this.event3 = new Event();
        this.event3.setArtifactType(BaseArtifactEnum.EVENT);
        this.event3 = this.persistAndAssert(this.event3);
        this.eventTarget3 = new EventTarget();
        this.eventTarget3.setArtifactType(EventEnum.EVENT);
        this.eventTarget3.setValue(this.event3.getUuid());
        this.orchestration1 = new Orchestration();
        this.orchestration1.setArtifactType(BaseArtifactEnum.ORCHESTRATION);
        this.orchestration1 = this.persistAndAssert(this.orchestration1);
        this.orchestrationTarget1 = new OrchestrationTarget();
        this.orchestrationTarget1.setArtifactType(OrchestrationEnum.ORCHESTRATION);
        this.orchestrationTarget1.setValue(this.orchestration1.getUuid());
        this.orchestrationProcess1 = new OrchestrationProcess();
        this.orchestrationProcess1.setArtifactType(BaseArtifactEnum.ORCHESTRATION_PROCESS);
        this.orchestrationProcess1 = this.persistAndAssert(this.orchestrationProcess1);
        this.orchestrationProcessTarget1 = new OrchestrationProcessTarget();
        this.orchestrationProcessTarget1.setArtifactType(OrchestrationProcessEnum.ORCHESTRATION_PROCESS);
        this.orchestrationProcessTarget1.setValue(this.orchestrationProcess1.getUuid());
        this.policy1 = new Policy();
        this.policy1.setArtifactType(BaseArtifactEnum.POLICY);
        this.policy1 = this.persistAndAssert(this.policy1);
        this.policyTarget1 = new PolicyTarget();
        this.policyTarget1.setArtifactType(PolicyEnum.POLICY);
        this.policyTarget1.setValue(this.policy1.getUuid());
        this.service1 = new Service();
        this.service1.setArtifactType(BaseArtifactEnum.SERVICE);
        this.service1 = this.persistAndAssert(this.service1);
        this.serviceTarget1 = new ServiceTarget();
        this.serviceTarget1.setArtifactType(ServiceEnum.SERVICE);
        this.serviceTarget1.setValue(this.service1.getUuid());
        this.task1 = new Task();
        this.task1.setArtifactType(BaseArtifactEnum.TASK);
        this.task1 = this.persistAndAssert(this.task1);
        this.taskTarget1 = new TaskTarget();
        this.taskTarget1.setArtifactType(TaskEnum.TASK);
        this.taskTarget1.setValue(this.task1.getUuid());
    }

    private <T extends SoaModelType> T persistAndAssert(T artifact) throws Exception {
        artifact.setName("Sample" + artifact.getClass().getSimpleName() + this.counter++);
        artifact.getDocumentation().add(this.documentationTarget);
        artifact = (SoaModelType)this.persistenceManager.persistArtifact(artifact, null);
        SoaModelType persistedArtifact = (SoaModelType)this.getArtifactByUUID(artifact.getUuid());
        this.assertBasic((BaseArtifactType)persistedArtifact, (BaseArtifactType)artifact);
        this.assertDocumentation(persistedArtifact.getDocumentation());
        return (T)persistedArtifact;
    }

    private Element persistAndAssertElement(Element artifact) throws Exception {
        artifact.getRepresents().add(this.elementTarget1);
        artifact.getUses().add(this.elementTarget2);
        artifact.getPerforms().add(this.serviceTarget1);
        artifact.setDirectsOrchestration(this.orchestrationTarget1);
        artifact.setDirectsOrchestrationProcess(this.orchestrationProcessTarget1);
        artifact.getGenerates().add(this.eventTarget1);
        artifact.getRespondsTo().add(this.eventTarget2);
        artifact.getRespondsTo().add(this.eventTarget3);
        artifact = this.persistAndAssert(artifact);
        this.assertTargets(artifact.getRepresents(), 1, new BaseArtifactType[]{this.element1});
        this.assertTargets(artifact.getUses(), 1, new BaseArtifactType[]{this.element2});
        this.assertTargets(artifact.getPerforms(), 1, new BaseArtifactType[]{this.service1});
        this.assertTarget(artifact.getDirectsOrchestration(), (BaseArtifactType)this.orchestration1);
        this.assertTarget(artifact.getDirectsOrchestrationProcess(), (BaseArtifactType)this.orchestrationProcess1);
        this.assertTargets(artifact.getGenerates(), 1, new BaseArtifactType[]{this.event1});
        this.assertTargets(artifact.getRespondsTo(), 2, new BaseArtifactType[]{this.event2, this.event3});
        return artifact;
    }

    private Actor persistAndAssertActor(Actor artifact) throws Exception {
        artifact.getDoes().add(this.taskTarget1);
        artifact.getSetsPolicy().add(this.policyTarget1);
        artifact = (Actor)this.persistAndAssertElement((Element)artifact);
        this.assertTargets(artifact.getDoes(), 1, new BaseArtifactType[]{this.task1});
        this.assertTargets(artifact.getSetsPolicy(), 1, new BaseArtifactType[]{this.policy1});
        return artifact;
    }

    private void assertDocumentation(List<DocumentArtifactTarget> documentation) throws Exception {
        Assert.assertNotNull(documentation);
        Assert.assertTrue((documentation.size() > 0 ? 1 : 0) != 0);
        for (DocumentArtifactTarget target : documentation) {
            WsdlDocument wsdlByTarget = (WsdlDocument)this.getArtifactByTarget((Target)target);
            Assert.assertEquals((Object)this.wsdl.getUuid(), (Object)wsdlByTarget.getUuid());
        }
    }

    private <T extends Target> void assertTargets(List<T> elementTargets, int expectedSize, BaseArtifactType ... expectedArtifacts) throws Exception {
        Assert.assertNotNull(elementTargets);
        Assert.assertEquals((long)expectedSize, (long)elementTargets.size());
        for (int i = 0; i < elementTargets.size(); ++i) {
            this.assertTarget((Target)elementTargets.get(i), expectedArtifacts[i]);
        }
    }

    private <T extends Target> void assertTarget(T elementTarget, BaseArtifactType expectedArtifact) throws Exception {
        BaseArtifactType artifactByTarget = this.getArtifactByTarget(elementTarget);
        this.assertBasic(artifactByTarget, expectedArtifact);
    }
}

