/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.test;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.io.IOUtils;
import org.artificer.common.ArtifactContent;
import org.artificer.common.ArtifactType;
import org.artificer.common.ArtificerModelUtils;
import org.artificer.common.query.ArtifactSummary;
import org.artificer.common.query.ReverseRelationship;
import org.artificer.repository.query.ArtificerQuery;
import org.artificer.repository.query.PagedResult;
import org.artificer.repository.test.AbstractNoAuditingPersistenceTest;
import org.junit.Assert;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Property;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdDocument;

public class RelationshipQueryTest
extends AbstractNoAuditingPersistenceTest {
    @Test
    public void testDerivedRelationshipQueries() throws Exception {
        WsdlDocument wsdlDoc = this.addWsdlDoc();
        ArtificerQuery query = this.queryManager.createQuery("/s-ramp/wsdl/Part[element]");
        PagedResult artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)3L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/wsdl/Part[element[@name = 'find']]");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/wsdl/Message[part]");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)5L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/wsdl/Operation[fault]");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/wsdl/Operation[fault[@name = 'foo']]");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)0L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/wsdl/Fault");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)2L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/wsdl/PortType[@name = 'SamplePortType']/operation");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)2L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/wsdl/PortType[@name = 'SamplePortType']/operation[@name = 'findSimple']");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/wsdl/Part[xp2:not(element)]");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)2L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery(String.format("/s-ramp/wsdl/Part[relatedDocument[@uuid = '%1$s'] and element]", wsdlDoc.getUuid()));
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)3L, (long)artifactSet.getTotalSize());
    }

    @Test
    public void testGenericRelationshipQueries() throws Exception {
        XsdDocument xsdDoc = this.addXsdDoc();
        WsdlDocument wsdlDoc1 = this.addWsdlDoc();
        WsdlDocument wsdlDoc2 = this.addWsdlDoc();
        ArtificerModelUtils.addGenericRelationship((BaseArtifactType)xsdDoc, (String)"importedBy", (String)wsdlDoc1.getUuid());
        ArtificerModelUtils.addGenericRelationship((BaseArtifactType)xsdDoc, (String)"importedBy", (String)wsdlDoc2.getUuid());
        this.persistenceManager.updateArtifact((BaseArtifactType)xsdDoc, ArtifactType.XsdDocument());
        ArtificerQuery query = this.queryManager.createQuery("/s-ramp/xsd/XsdDocument[importedBy]");
        PagedResult artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/xsd/XsdDocument[importedBy[@uuid = ?]]");
        query.setString(wsdlDoc1.getUuid());
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/xsd/XsdDocument[noSuchRel]");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)0L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/wsdl/WsdlDocument[importedBy]");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)0L, (long)artifactSet.getTotalSize());
    }

    @Test
    public void testGenericRelationshipAttributeQueries() throws Exception {
        XsdDocument xsdDoc = this.addXsdDoc();
        WsdlDocument wsdlDoc1 = this.addWsdlDoc();
        WsdlDocument wsdlDoc2 = this.addWsdlDoc();
        WsdlDocument wsdlDoc3 = this.addWsdlDoc();
        HashMap<QName, String> otherAttributes = new HashMap<QName, String>();
        otherAttributes.put(QName.valueOf("FooKey"), "FooValue");
        ArtificerModelUtils.addGenericRelationship((BaseArtifactType)xsdDoc, (String)"relWithAttr", (String)wsdlDoc1.getUuid(), otherAttributes, (Map)Collections.EMPTY_MAP);
        ArtificerModelUtils.addGenericRelationship((BaseArtifactType)xsdDoc, (String)"relWithAttr", (String)wsdlDoc2.getUuid(), otherAttributes, (Map)Collections.EMPTY_MAP);
        HashMap<QName, String> otherAttributes2 = new HashMap<QName, String>();
        otherAttributes2.put(QName.valueOf("FooKey2"), "FooValue2");
        ArtificerModelUtils.addGenericRelationship((BaseArtifactType)xsdDoc, (String)"relWithAttr2", (String)wsdlDoc3.getUuid(), otherAttributes2, (Map)Collections.EMPTY_MAP);
        xsdDoc = (XsdDocument)this.persistenceManager.updateArtifact((BaseArtifactType)xsdDoc, ArtifactType.XsdDocument());
        Property prop = new Property();
        prop.setPropertyName("FooProperty");
        prop.setPropertyValue("FooValue");
        wsdlDoc1.getProperty().add(prop);
        wsdlDoc1 = (WsdlDocument)this.persistenceManager.updateArtifact((BaseArtifactType)wsdlDoc1, ArtifactType.WsdlDocument());
        ArtificerQuery query = this.queryManager.createQuery("/s-ramp/xsd/XsdDocument[relWithAttr[s-ramp:getRelationshipAttribute(., 'FooKey')]]");
        PagedResult artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/xsd/XsdDocument[relWithAttr[s-ramp:getRelationshipAttribute(., 'FooKey') = 'FooValue']]");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/xsd/XsdDocument[relWithAttr[s-ramp:getRelationshipAttribute(., 'InvalidKey')]]");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)0L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/xsd/XsdDocument[relWithAttr[s-ramp:getRelationshipAttribute(., 'FooKey') = 'FooValue' and @FooProperty = 'FooValue']]");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/xsd/XsdDocument[relWithAttr[s-ramp:getRelationshipAttribute(., 'FooKey') = 'FooValue' and @InvalidProperty]]");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)0L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/xsd/XsdDocument[relWithAttr[s-ramp:getRelationshipAttribute(., 'FooKey') = 'FooValue' or @FooProperty = 'FooValue']]");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/xsd/XsdDocument[relWithAttr[s-ramp:getRelationshipAttribute(., 'FooKey') = 'InvalidValue' or @FooProperty = 'FooValue']]");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/xsd/XsdDocument[relWithAttr[s-ramp:getRelationshipAttribute(., 'FooKey') = 'InvalidValue' or @FooProperty = 'FooValue']]");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/xsd/XsdDocument[@uuid = ?]/relWithAttr2");
        query.setString(xsdDoc.getUuid());
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        Assert.assertEquals((Object)wsdlDoc3.getUuid(), (Object)((ArtifactSummary)artifactSet.getResults().get(0)).getUuid());
        query = this.queryManager.createQuery("/s-ramp/xsd/XsdDocument[@uuid = ?]/relWithAttr2[s-ramp:getRelationshipAttribute(., 'FooKey2')]");
        query.setString(xsdDoc.getUuid());
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        Assert.assertEquals((Object)wsdlDoc3.getUuid(), (Object)((ArtifactSummary)artifactSet.getResults().get(0)).getUuid());
        query = this.queryManager.createQuery("/s-ramp/xsd/XsdDocument[@uuid = ?]/relWithAttr2[s-ramp:getRelationshipAttribute(., 'FooKey2') = 'FooValue2']");
        query.setString(xsdDoc.getUuid());
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        Assert.assertEquals((Object)wsdlDoc3.getUuid(), (Object)((ArtifactSummary)artifactSet.getResults().get(0)).getUuid());
        query = this.queryManager.createQuery("/s-ramp/xsd/XsdDocument[@uuid = ?]/relWithAttr2[s-ramp:getRelationshipAttribute(., 'InvalidKey')]");
        query.setString(xsdDoc.getUuid());
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)0L, (long)artifactSet.getTotalSize());
    }

    @Test
    public void testGenericTargetAttributeQueries() throws Exception {
        XsdDocument xsdDoc = this.addXsdDoc();
        WsdlDocument wsdlDoc1 = this.addWsdlDoc();
        WsdlDocument wsdlDoc2 = this.addWsdlDoc();
        WsdlDocument wsdlDoc3 = this.addWsdlDoc();
        HashMap<QName, String> otherAttributes = new HashMap<QName, String>();
        otherAttributes.put(QName.valueOf("FooKey"), "FooValue");
        ArtificerModelUtils.addGenericRelationship((BaseArtifactType)xsdDoc, (String)"relWithAttr", (String)wsdlDoc1.getUuid(), (Map)Collections.EMPTY_MAP, otherAttributes);
        ArtificerModelUtils.addGenericRelationship((BaseArtifactType)xsdDoc, (String)"relWithAttr", (String)wsdlDoc2.getUuid(), (Map)Collections.EMPTY_MAP, otherAttributes);
        HashMap<QName, String> otherAttributes2 = new HashMap<QName, String>();
        otherAttributes2.put(QName.valueOf("FooKey2"), "FooValue2");
        ArtificerModelUtils.addGenericRelationship((BaseArtifactType)xsdDoc, (String)"relWithAttr2", (String)wsdlDoc3.getUuid(), (Map)Collections.EMPTY_MAP, otherAttributes2);
        xsdDoc = (XsdDocument)this.persistenceManager.updateArtifact((BaseArtifactType)xsdDoc, ArtifactType.XsdDocument());
        Property prop = new Property();
        prop.setPropertyName("FooProperty");
        prop.setPropertyValue("FooValue");
        wsdlDoc1.getProperty().add(prop);
        wsdlDoc1 = (WsdlDocument)this.persistenceManager.updateArtifact((BaseArtifactType)wsdlDoc1, ArtifactType.WsdlDocument());
        ArtificerQuery query = this.queryManager.createQuery("/s-ramp/xsd/XsdDocument[relWithAttr[s-ramp:getTargetAttribute(., 'FooKey')]]");
        PagedResult artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/xsd/XsdDocument[relWithAttr[s-ramp:getTargetAttribute(., 'FooKey') = 'FooValue']]");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/xsd/XsdDocument[relWithAttr[s-ramp:getTargetAttribute(., 'InvalidKey')]]");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)0L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/xsd/XsdDocument[relWithAttr[s-ramp:getTargetAttribute(., 'FooKey') = 'FooValue' and @FooProperty = 'FooValue']]");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/xsd/XsdDocument[relWithAttr[s-ramp:getTargetAttribute(., 'FooKey') = 'FooValue' and @InvalidProperty]]");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)0L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/xsd/XsdDocument[relWithAttr[s-ramp:getTargetAttribute(., 'FooKey') = 'FooValue' or @FooProperty = 'FooValue']]");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/xsd/XsdDocument[relWithAttr[s-ramp:getTargetAttribute(., 'FooKey') = 'InvalidValue' or @FooProperty = 'FooValue']]");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/xsd/XsdDocument[relWithAttr[s-ramp:getTargetAttribute(., 'FooKey') = 'InvalidValue' or @FooProperty = 'FooValue']]");
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/xsd/XsdDocument[@uuid = ?]/relWithAttr2");
        query.setString(xsdDoc.getUuid());
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        query = this.queryManager.createQuery("/s-ramp/xsd/XsdDocument[@uuid = ?]/relWithAttr2[s-ramp:getTargetAttribute(., 'FooKey2')]");
        query.setString(xsdDoc.getUuid());
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        Assert.assertEquals((Object)wsdlDoc3.getUuid(), (Object)((ArtifactSummary)artifactSet.getResults().get(0)).getUuid());
        query = this.queryManager.createQuery("/s-ramp/xsd/XsdDocument[@uuid = ?]/relWithAttr2[s-ramp:getTargetAttribute(., 'FooKey2') = 'FooValue2']");
        query.setString(xsdDoc.getUuid());
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)1L, (long)artifactSet.getTotalSize());
        Assert.assertEquals((Object)wsdlDoc3.getUuid(), (Object)((ArtifactSummary)artifactSet.getResults().get(0)).getUuid());
        query = this.queryManager.createQuery("/s-ramp/xsd/XsdDocument[@uuid = ?]/relWithAttr2[s-ramp:getTargetAttribute(., 'InvalidKey')]");
        query.setString(xsdDoc.getUuid());
        artifactSet = query.executeQuery();
        Assert.assertNotNull((Object)artifactSet);
        Assert.assertEquals((long)0L, (long)artifactSet.getTotalSize());
    }

    @Test
    public void testReverseRelationships() throws Exception {
        WsdlDocument wsdlDoc = this.addWsdlDoc();
        ArtificerQuery query = this.queryManager.createQuery("/s-ramp/wsdl/Part");
        PagedResult artifactSet = query.executeQuery();
        ArtifactSummary partSummary = (ArtifactSummary)artifactSet.getResults().get(0);
        BaseArtifactType part = this.persistenceManager.getArtifact(partSummary.getUuid(), partSummary.getArtifactType());
        ArtificerModelUtils.addGenericRelationship((BaseArtifactType)part, (String)"fooRel", (String)wsdlDoc.getUuid());
        this.persistenceManager.updateArtifact(part, ArtifactType.valueOf((BaseArtifactType)part));
        List reverseRelationships = this.queryManager.reverseRelationships(wsdlDoc.getUuid());
        Assert.assertTrue((boolean)this.hasRelationship(reverseRelationships, part.getUuid(), "fooRel"));
        Assert.assertTrue((boolean)this.hasRelationship(reverseRelationships, part.getUuid(), "relatedDocument"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WsdlDocument addWsdlDoc() throws Exception {
        String artifactFileName = "jcr-sample.wsdl";
        InputStream contentStream = this.getClass().getResourceAsStream("/sample-files/wsdl/" + artifactFileName);
        try {
            WsdlDocument wsdlDoc = new WsdlDocument();
            wsdlDoc.setArtifactType(BaseArtifactEnum.WSDL_DOCUMENT);
            wsdlDoc.setName(artifactFileName);
            wsdlDoc.setContentEncoding("application/xml");
            BaseArtifactType artifact = this.persistenceManager.persistArtifact((BaseArtifactType)wsdlDoc, new ArtifactContent(artifactFileName, contentStream));
            Assert.assertNotNull((Object)artifact);
            WsdlDocument wsdlDocument = (WsdlDocument)artifact;
            return wsdlDocument;
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XsdDocument addXsdDoc() throws Exception {
        String artifactFileName = "PO.xsd";
        InputStream contentStream = this.getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        try {
            XsdDocument xsdDoc = new XsdDocument();
            xsdDoc.setArtifactType(BaseArtifactEnum.XSD_DOCUMENT);
            xsdDoc.setName(artifactFileName);
            xsdDoc.setContentEncoding("application/xml");
            BaseArtifactType artifact = this.persistenceManager.persistArtifact((BaseArtifactType)xsdDoc, new ArtifactContent(artifactFileName, contentStream));
            Assert.assertNotNull((Object)artifact);
            XsdDocument xsdDocument = (XsdDocument)artifact;
            return xsdDocument;
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
    }

    private boolean hasRelationship(List<ReverseRelationship> reverseRelationships, String sourceUuid, String relType) {
        for (ReverseRelationship reverseRelationship : reverseRelationships) {
            if (!reverseRelationship.getSourceArtifact().getUuid().equals(sourceUuid) || !reverseRelationship.getName().equals(relType)) continue;
            return true;
        }
        return false;
    }
}

