/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.artificer.common.ArtificerException;
import org.artificer.common.error.ArtificerUserException;
import org.artificer.common.ontology.ArtificerOntology;
import org.artificer.common.ontology.ArtificerOntologyClass;
import org.artificer.repository.ClassificationHelper;
import org.artificer.repository.PersistenceManager;

public abstract class AbstractPersistenceManager
implements PersistenceManager,
ClassificationHelper {
    @Override
    public URI resolve(String classifiedBy) throws ArtificerException {
        try {
            URI classifiedUri = new URI(classifiedBy);
            List<ArtificerOntology> ontologies = this.getOntologies();
            for (ArtificerOntology ontology : ontologies) {
                ArtificerOntologyClass sclass = ontology.findClass(classifiedBy);
                if (sclass == null) {
                    sclass = ontology.findClass(classifiedUri);
                }
                if (sclass == null) continue;
                return new URI(sclass.getUri());
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        throw ArtificerUserException.invalidClassifiedBy((String)classifiedBy);
    }

    @Override
    public Collection<URI> normalize(URI classification) throws ArtificerException {
        try {
            List<ArtificerOntology> ontologies = this.getOntologies();
            for (ArtificerOntology ontology : ontologies) {
                ArtificerOntologyClass sclass = ontology.findClass(classification);
                if (sclass == null) continue;
                return sclass.normalize();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        throw ArtificerUserException.invalidClassifiedBy((String)classification.toString());
    }

    @Override
    public Collection<URI> resolveAll(Collection<String> classifiedBy) throws ArtificerException {
        HashSet<URI> resolved = new HashSet<URI>(classifiedBy.size());
        for (String classification : classifiedBy) {
            resolved.add(this.resolve(classification));
        }
        return resolved;
    }

    @Override
    public Collection<URI> normalizeAll(Collection<URI> classifications) throws ArtificerException {
        HashSet<URI> resolved = new HashSet<URI>(classifications.size());
        for (URI classification : classifications) {
            resolved.addAll(this.normalize(classification));
        }
        return resolved;
    }
}

