/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.server;

import java.util.List;
import javax.ejb.Remote;
import javax.ejb.Stateful;
import org.artificer.repository.AuditManager;
import org.artificer.repository.audit.AuditEntrySet;
import org.artificer.server.AbstractServiceImpl;
import org.artificer.server.core.api.AuditService;
import org.artificer.server.core.api.PagedResult;
import org.jboss.downloads.artificer._2013.auditing.AuditEntry;

@Stateful(name="AuditService")
@Remote(value={AuditService.class})
public class AuditServiceImpl
extends AbstractServiceImpl
implements AuditService {
    public AuditEntry create(String artifactUuid, AuditEntry auditEntry) throws Exception {
        AuditManager auditManager = this.auditManager();
        return auditManager.addAuditEntry(artifactUuid, auditEntry);
    }

    public AuditEntry get(String artifactUuid, String auditEntryUuid) throws Exception {
        AuditManager auditManager = this.auditManager();
        return auditManager.getArtifactAuditEntry(artifactUuid, auditEntryUuid);
    }

    public List<AuditEntry> queryByArtifact(String artifactUuid) throws Exception {
        AuditManager auditManager = this.auditManager();
        AuditEntrySet results = auditManager.getArtifactAuditEntries(artifactUuid);
        return results.list();
    }

    public PagedResult<AuditEntry> queryByArtifact(String artifactUuid, Integer startPage, Integer startIndex, Integer count) throws Exception {
        AuditManager auditManager = this.auditManager();
        AuditEntrySet results = auditManager.getArtifactAuditEntries(artifactUuid);
        return this.doPaging(results, startPage, startIndex, count);
    }

    public List<AuditEntry> queryByUser(String username) throws Exception {
        AuditManager auditManager = this.auditManager();
        AuditEntrySet results = auditManager.getUserAuditEntries(username);
        return results.list();
    }

    public PagedResult<AuditEntry> queryByUser(String username, Integer startPage, Integer startIndex, Integer count) throws Exception {
        AuditManager auditManager = this.auditManager();
        AuditEntrySet results = auditManager.getUserAuditEntries(username);
        return this.doPaging(results, startPage, startIndex, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PagedResult<AuditEntry> doPaging(AuditEntrySet results, Integer startPage, Integer startIndex, Integer count) throws Exception {
        startIndex = this.startIndex(startPage, startIndex, count);
        if (count == null) {
            count = 100;
        }
        int startIdx = startIndex;
        int endIdx = startIdx + count - 1;
        try {
            List entries = results.pagedList((long)startIdx, (long)endIdx);
            PagedResult pagedResult = new PagedResult(entries, "", results.size(), startIndex.intValue(), count.intValue(), "", true);
            return pagedResult;
        }
        finally {
            results.close();
        }
    }
}

