/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.server;

import java.util.List;
import javax.ejb.Remote;
import javax.ejb.Stateful;
import org.artificer.common.ReverseRelationship;
import org.artificer.repository.QueryManager;
import org.artificer.repository.query.ArtifactSet;
import org.artificer.repository.query.ArtificerQuery;
import org.artificer.server.AbstractServiceImpl;
import org.artificer.server.core.api.PagedResult;
import org.artificer.server.core.api.QueryService;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.StoredQuery;

@Stateful(name="QueryService")
@Remote(value={QueryService.class})
public class QueryServiceImpl
extends AbstractServiceImpl
implements QueryService {
    public List<BaseArtifactType> query(String query) throws Exception {
        return this.query(query, "name", Boolean.valueOf(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BaseArtifactType> query(String query, String orderBy, Boolean ascending) throws Exception {
        String xpath = query;
        if (!xpath.startsWith("/s-ramp")) {
            xpath = query.startsWith("/") ? "/s-ramp" + query : "/s-ramp/" + query;
        }
        if (orderBy == null) {
            orderBy = "name";
        }
        if (ascending == null) {
            ascending = true;
        }
        ArtifactSet artifactSet = this.executeQuery(xpath, orderBy, ascending);
        try {
            List list = artifactSet.list();
            return list;
        }
        finally {
            artifactSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PagedResult<BaseArtifactType> query(String query, Integer startPage, Integer startIndex, Integer count, String orderBy, Boolean ascending) throws Exception {
        String xpath = query;
        if (!xpath.startsWith("/s-ramp")) {
            xpath = query.startsWith("/") ? "/s-ramp" + query : "/s-ramp/" + query;
        }
        if (orderBy == null) {
            orderBy = "name";
        }
        if (ascending == null) {
            ascending = true;
        }
        ArtifactSet artifactSet = this.executeQuery(xpath, orderBy, ascending);
        startIndex = this.startIndex(startPage, startIndex, count);
        if (count == null) {
            count = 100;
        }
        int startIdx = startIndex;
        int endIdx = startIdx + count - 1;
        try {
            List results = artifactSet.pagedList((long)startIdx, (long)endIdx);
            PagedResult pagedResult = new PagedResult(results, xpath, artifactSet.size(), startIndex.intValue(), count.intValue(), orderBy, ascending.booleanValue());
            return pagedResult;
        }
        finally {
            artifactSet.close();
        }
    }

    private ArtifactSet executeQuery(String query, String orderBy, Boolean ascending) throws Exception {
        QueryManager queryManager = this.queryManager();
        ArtificerQuery artificerQuery = queryManager.createQuery(query, orderBy, ascending.booleanValue());
        return artificerQuery.executeQuery();
    }

    public StoredQuery createStoredQuery(StoredQuery storedQuery) throws Exception {
        return this.persistenceManager().persistStoredQuery(storedQuery);
    }

    public void updateStoredQuery(String queryName, StoredQuery storedQuery) throws Exception {
        this.persistenceManager().updateStoredQuery(queryName, storedQuery);
    }

    public StoredQuery getStoredQuery(String queryName) throws Exception {
        return this.persistenceManager().getStoredQuery(queryName);
    }

    public List<StoredQuery> getStoredQueries() throws Exception {
        return this.persistenceManager().getStoredQueries();
    }

    public void deleteStoredQuery(String queryName) throws Exception {
        this.persistenceManager().deleteStoredQuery(queryName);
    }

    public List<ReverseRelationship> reverseRelationships(String uuid) throws Exception {
        return this.queryManager().reverseRelationships(uuid);
    }
}

