/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.server.atom.services;

import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.artificer.atom.visitors.ArtifactToSummaryAtomEntryVisitor;
import org.artificer.common.ArtificerConfig;
import org.artificer.common.ArtificerConstants;
import org.artificer.common.ReverseRelationship;
import org.artificer.common.visitors.ArtifactVisitor;
import org.artificer.common.visitors.ArtifactVisitorHelper;
import org.artificer.server.atom.services.AbstractFeedResource;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.jboss.resteasy.plugins.providers.atom.Person;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;

@Path(value="/artificer")
public class ArtificerResource
extends AbstractFeedResource {
    @GET
    @Path(value="reverseRelationship/{uuid}")
    @Produces(value={"application/atom+xml;type=feed"})
    public Feed reverseRelationship(@Context HttpServletRequest request, @PathParam(value="uuid") String uuid) throws Exception {
        String baseUrl = ArtificerConfig.getBaseUrl((String)request.getRequestURL().toString());
        Feed feed = new Feed();
        feed.getExtensionAttributes().put(ArtificerConstants.SRAMP_PROVIDER_QNAME, "Artificer");
        feed.setId(new URI("urn:uuid:" + UUID.randomUUID().toString()));
        feed.setTitle("Artificer");
        feed.setSubtitle("Reverse Relationships");
        feed.setUpdated(new Date());
        feed.getAuthors().add(new Person("anonymous"));
        ArtifactToSummaryAtomEntryVisitor visitor = new ArtifactToSummaryAtomEntryVisitor(baseUrl, null);
        List relationships = this.queryService.reverseRelationships(uuid);
        for (ReverseRelationship relationship : relationships) {
            BaseArtifactType artifact = relationship.getSourceArtifact();
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifact);
            Entry entry = visitor.getAtomEntry();
            entry.getExtensionAttributes().put(ArtificerConstants.ARTIFICER_RELATIONSHIP_TYPE_QNAME, String.valueOf(relationship.getRelationshipType()));
            feed.getEntries().add(entry);
            visitor.reset();
        }
        return feed;
    }
}

