/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.server;

import org.apache.commons.lang.StringUtils;
import org.artificer.repository.AuditManager;
import org.artificer.repository.PersistenceManager;
import org.artificer.repository.QueryManager;
import org.artificer.repository.RepositoryProviderFactory;
import org.artificer.server.core.api.AbstractService;

public abstract class AbstractServiceImpl
implements AbstractService {
    private String username;
    private String password;

    public void login(String username, String password) {
        this.username = username;
        this.password = password;
    }

    protected PersistenceManager persistenceManager() {
        PersistenceManager persistenceManager = RepositoryProviderFactory.persistenceManager();
        if (StringUtils.isNotBlank((String)this.username) && StringUtils.isNotBlank((String)this.password)) {
            persistenceManager.login(this.username, this.password);
        }
        return persistenceManager;
    }

    protected AuditManager auditManager() {
        AuditManager auditManager = RepositoryProviderFactory.auditManager();
        if (StringUtils.isNotBlank((String)this.username) && StringUtils.isNotBlank((String)this.password)) {
            auditManager.login(this.username, this.password);
        }
        return auditManager;
    }

    protected QueryManager queryManager() {
        QueryManager queryManager = RepositoryProviderFactory.queryManager();
        if (StringUtils.isNotBlank((String)this.username) && StringUtils.isNotBlank((String)this.password)) {
            queryManager.login(this.username, this.password);
        }
        return queryManager;
    }
}

