/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.server;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.ejb.Remote;
import javax.ejb.Stateful;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.ws.rs.core.MediaType;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.artificer.atom.visitors.ArtifactContentTypeVisitor;
import org.artificer.common.ArtifactContent;
import org.artificer.common.ArtifactType;
import org.artificer.common.ArtifactTypeEnum;
import org.artificer.common.ArtifactVerifier;
import org.artificer.common.ArtificerConstants;
import org.artificer.common.error.ArtificerNotFoundException;
import org.artificer.common.error.ArtificerUserException;
import org.artificer.common.visitors.ArtifactVisitor;
import org.artificer.common.visitors.ArtifactVisitorHelper;
import org.artificer.events.EventProducer;
import org.artificer.events.EventProducerFactory;
import org.artificer.integration.ArchiveContext;
import org.artificer.integration.ExtensionFactory;
import org.artificer.repository.PersistenceManager;
import org.artificer.server.AbstractServiceImpl;
import org.artificer.server.BatchCreate;
import org.artificer.server.core.api.ArtifactService;
import org.artificer.server.i18n.Messages;
import org.artificer.server.mime.MimeTypes;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DocumentArtifactType;

@Stateful(name="ArtifactService")
@Remote(value={ArtifactService.class})
@TransactionManagement(value=TransactionManagementType.BEAN)
public class ArtifactServiceImpl
extends AbstractServiceImpl
implements ArtifactService {
    public BaseArtifactType create(BaseArtifactType artifact) throws Exception {
        ArtifactType artifactType = ArtifactType.valueOf((BaseArtifactType)artifact);
        return this.create(artifactType, artifact);
    }

    public BaseArtifactType create(ArtifactType artifactType, BaseArtifactType artifact) throws Exception {
        ArtifactVerifier verifier = new ArtifactVerifier(artifactType);
        ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)verifier, (BaseArtifactType)artifact);
        verifier.throwError();
        if (artifactType.isDerived()) {
            throw ArtificerUserException.derivedArtifactCreate((ArtifactTypeEnum)artifactType.getArtifactType());
        }
        if (artifactType.isDocument()) {
            throw new ArtificerUserException(Messages.i18n.format("INVALID_DOCARTY_CREATE", new Object[0]));
        }
        PersistenceManager persistenceManager = this.persistenceManager();
        BaseArtifactType persistedArtifact = persistenceManager.persistArtifact(artifact, null);
        Set eventProducers = EventProducerFactory.getEventProducers();
        for (EventProducer eventProducer : eventProducers) {
            eventProducer.artifactCreated(persistedArtifact);
        }
        return persistedArtifact;
    }

    public BaseArtifactType upload(String model, String type, String fileName, InputStream is) throws Exception {
        ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type, (Boolean)true);
        return this.upload(artifactType, fileName, is);
    }

    public BaseArtifactType upload(String fileName, InputStream is) throws Exception {
        return this.upload(null, fileName, is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseArtifactType upload(ArtifactType artifactType, String fileName, InputStream is) throws Exception {
        if (fileName == null) {
            fileName = artifactType.getArtifactType() == ArtifactTypeEnum.Document ? "newartifact.bin" : (artifactType.getArtifactType() == ArtifactTypeEnum.XmlDocument ? "newartifact.xml" : "newartifact." + artifactType.getArtifactType().getModel());
        }
        ArtifactContent content = null;
        ArchiveContext archiveContext = null;
        try {
            content = new ArtifactContent(fileName, is);
            if (ExtensionFactory.isArchive((ArtifactContent)content)) {
                archiveContext = ArchiveContext.createArchiveContext((ArtifactContent)content);
                if (artifactType == null) {
                    artifactType = ExtensionFactory.detect((ArtifactContent)content, (ArchiveContext)archiveContext);
                }
            } else if (artifactType == null) {
                artifactType = ExtensionFactory.detect((ArtifactContent)content);
            }
            if (artifactType == null) {
                BaseArtifactType baseArtifactType = null;
                return baseArtifactType;
            }
            if (artifactType.isDerived()) {
                throw ArtificerUserException.derivedArtifactCreate((ArtifactTypeEnum)artifactType.getArtifactType());
            }
            if (!artifactType.isDocument()) {
                throw new ArtificerUserException(Messages.i18n.format("INVALID_DOCARTY_CREATE", new Object[0]));
            }
            PersistenceManager persistenceManager = this.persistenceManager();
            String mimeType = MimeTypes.determineMimeType((String)fileName, (InputStream)content.getInputStream(), (ArtifactType)artifactType);
            artifactType.setMimeType(mimeType);
            BaseArtifactType artifact = artifactType.newArtifactInstance();
            artifact.setName(fileName);
            BatchCreate creates = new BatchCreate();
            if (archiveContext != null) {
                String parentUuid = UUID.randomUUID().toString();
                artifact.setUuid(parentUuid);
                archiveContext.setArchiveArtifactType(artifactType);
                Collection subFiles = archiveContext.expand();
                for (File subFile : subFiles) {
                    ArtifactType subArtifactType;
                    String pathInArchive = archiveContext.stripWorkDir(subFile.getAbsolutePath());
                    ArtifactContent subArtifactContent = new ArtifactContent(pathInArchive, subFile);
                    if (!ExtensionFactory.allowExpansionFromArchive((ArtifactContent)subArtifactContent, (ArchiveContext)archiveContext) || (subArtifactType = ExtensionFactory.detect((ArtifactContent)subArtifactContent, (ArchiveContext)archiveContext)) == null) continue;
                    String subMimeType = MimeTypes.determineMimeType((String)subFile.getName(), (InputStream)subArtifactContent.getInputStream(), (ArtifactType)subArtifactType);
                    subArtifactType.setMimeType(subMimeType);
                    BaseArtifactType subArtifact = subArtifactType.newArtifactInstance();
                    subArtifact.setName(subFile.getName());
                    subArtifact.getOtherAttributes().put(ArtificerConstants.ARTIFICER_EXPANDED_FROM_ARCHIVE_UUID_QNAME, parentUuid);
                    subArtifact.getOtherAttributes().put(ArtificerConstants.ARTIFICER_EXPANDED_FROM_ARCHIVE_PATH_QNAME, pathInArchive);
                    creates.add(subArtifact, subArtifactContent, subArtifactContent.getPath());
                }
            }
            artifact = persistenceManager.persistArtifact(artifact, content);
            this.doUploadEvent(artifact);
            List results = creates.execute(persistenceManager);
            for (BaseArtifactType result : results) {
                this.doUploadEvent(result);
            }
            BaseArtifactType baseArtifactType = artifact;
            return baseArtifactType;
        }
        finally {
            if (content != null) {
                content.cleanup();
            }
            if (archiveContext != null) {
                archiveContext.cleanup();
            }
        }
    }

    private void doUploadEvent(BaseArtifactType artifact) {
        Set eventProducers = EventProducerFactory.getEventProducers();
        for (EventProducer eventProducer : eventProducers) {
            eventProducer.artifactCreated(artifact);
        }
    }

    public BaseArtifactType upload(String model, String type, String fileName, byte[] contentBytes) throws Exception {
        return this.upload(model, type, fileName, (InputStream)new ByteArrayInputStream(contentBytes));
    }

    public BaseArtifactType upload(String fileName, byte[] contentBytes) throws Exception {
        return this.upload(fileName, (InputStream)new ByteArrayInputStream(contentBytes));
    }

    public BaseArtifactType upload(ArtifactType artifactType, String fileName, byte[] contentBytes) throws Exception {
        return this.upload(artifactType, fileName, (InputStream)new ByteArrayInputStream(contentBytes));
    }

    public void updateMetaData(String model, String type, String uuid, BaseArtifactType updatedArtifact) throws Exception {
        ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type, null);
        this.updateMetaData(artifactType, uuid, updatedArtifact);
    }

    public void updateMetaData(BaseArtifactType updatedArtifact) throws Exception {
        ArtifactType artifactType = ArtifactType.valueOf((BaseArtifactType)updatedArtifact);
        this.updateMetaData(artifactType, updatedArtifact.getUuid(), updatedArtifact);
    }

    public void updateMetaData(ArtifactType artifactType, String uuid, BaseArtifactType updatedArtifact) throws Exception {
        PersistenceManager persistenceManager = this.persistenceManager();
        BaseArtifactType oldArtifact = persistenceManager.getArtifact(uuid, artifactType);
        if (oldArtifact == null) {
            throw ArtificerNotFoundException.artifactNotFound((String)uuid);
        }
        ArtifactVerifier verifier = new ArtifactVerifier(oldArtifact, artifactType);
        ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)verifier, (BaseArtifactType)updatedArtifact);
        verifier.throwError();
        updatedArtifact = persistenceManager.updateArtifact(updatedArtifact, artifactType);
        Set eventProducers = EventProducerFactory.getEventProducers();
        for (EventProducer eventProducer : eventProducers) {
            eventProducer.artifactUpdated(updatedArtifact, oldArtifact);
        }
    }

    public BaseArtifactType addComment(ArtifactType artifactType, String uuid, String text) throws Exception {
        return this.persistenceManager().addComment(uuid, artifactType, text);
    }

    public BaseArtifactType getMetaData(String model, String type, String uuid) throws Exception {
        ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type, (Boolean)false);
        return this.getMetaData(artifactType, uuid);
    }

    public BaseArtifactType getMetaData(ArtifactType artifactType, String uuid) throws Exception {
        PersistenceManager persistenceManager = this.persistenceManager();
        BaseArtifactType artifact = persistenceManager.getArtifact(uuid, artifactType);
        if (!(artifact != null && (artifactType.getArtifactType().getApiType().equals((Object)artifact.getArtifactType()) || artifactType.getArtifactType().equals((Object)ArtifactTypeEnum.ExtendedArtifactType) && artifact.getArtifactType().equals((Object)BaseArtifactEnum.EXTENDED_DOCUMENT)))) {
            throw ArtificerNotFoundException.artifactNotFound((String)uuid);
        }
        return artifact;
    }

    public InputStream getContent(String model, String type, String uuid) throws Exception {
        ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type, (Boolean)true);
        BaseArtifactType artifact = this.getMetaData(artifactType, uuid);
        return this.getContent(artifactType, artifact);
    }

    public InputStream getContent(ArtifactType artifactType, String uuid) throws Exception {
        BaseArtifactType artifact = this.getMetaData(artifactType, uuid);
        return this.getContent(artifactType, artifact);
    }

    public InputStream getContent(ArtifactType artifactType, BaseArtifactType artifact) throws Exception {
        if (!(artifact instanceof DocumentArtifactType)) {
            throw ArtificerNotFoundException.contentNotFound((String)artifact.getUuid());
        }
        DocumentArtifactType documentArtifact = (DocumentArtifactType)artifact;
        if (documentArtifact.getContentSize() == 0L || StringUtils.isEmpty((String)documentArtifact.getContentHash())) {
            throw ArtificerNotFoundException.contentNotFound((String)artifact.getUuid());
        }
        PersistenceManager persistenceManager = this.persistenceManager();
        ArtifactContentTypeVisitor ctVizzy = new ArtifactContentTypeVisitor();
        ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)ctVizzy, (BaseArtifactType)artifact);
        MediaType mediaType = ctVizzy.getContentType();
        artifactType.setMimeType(mediaType.toString());
        return persistenceManager.getArtifactContent(artifact.getUuid(), artifactType);
    }

    public byte[] getContentBytes(String model, String type, String uuid) throws Exception {
        return IOUtils.toByteArray((InputStream)this.getContent(model, type, uuid));
    }

    public byte[] getContentBytes(ArtifactType artifactType, String uuid) throws Exception {
        return IOUtils.toByteArray((InputStream)this.getContent(artifactType, uuid));
    }

    public byte[] getContentBytes(ArtifactType artifactType, BaseArtifactType artifact) throws Exception {
        return IOUtils.toByteArray((InputStream)this.getContent(artifactType, artifact));
    }

    public void delete(String model, String type, String uuid) throws Exception {
        this.delete(model, type, uuid, false);
    }

    public void delete(String model, String type, String uuid, boolean force) throws Exception {
        ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type, null);
        this.delete(artifactType, uuid, force);
    }

    public void delete(ArtifactType artifactType, String uuid) throws Exception {
        this.delete(artifactType, uuid, false);
    }

    public void delete(ArtifactType artifactType, String uuid, boolean force) throws Exception {
        if (artifactType.isDerived()) {
            throw ArtificerUserException.derivedArtifactDelete((ArtifactTypeEnum)artifactType.getArtifactType());
        }
        PersistenceManager persistenceManager = this.persistenceManager();
        BaseArtifactType artifact = persistenceManager.deleteArtifact(uuid, artifactType, force);
        Set eventProducers = EventProducerFactory.getEventProducers();
        for (EventProducer eventProducer : eventProducers) {
            eventProducer.artifactDeleted(artifact);
        }
    }
}

