/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.server.atom.workspaces;

import java.util.List;
import org.artificer.common.ArtificerException;
import org.artificer.repository.PersistenceFactory;
import org.artificer.repository.PersistenceManager;
import org.artificer.server.atom.workspaces.AbstractWorkspace;
import org.artificer.server.i18n.Messages;
import org.jboss.resteasy.plugins.providers.atom.app.AppCollection;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.StoredQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoredQueryWorkspace
extends AbstractWorkspace {
    private static final long serialVersionUID = 9119601241133543724L;
    private static Logger LOGGER = LoggerFactory.getLogger(StoredQueryWorkspace.class);

    public StoredQueryWorkspace(String hrefBase) {
        super(hrefBase, "Query Model");
    }

    @Override
    protected void configureWorkspace() {
        AppCollection collection = this.addCollection("/s-ramp/query", "Query Model", "application/zip");
        this.addCategory(collection, "query", "StoredQuery");
        try {
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            List storedQueries = persistenceManager.getStoredQueries();
            for (StoredQuery storedQuery : storedQueries) {
                AppCollection queryCollection = this.addCollection("/s-ramp/query/" + storedQuery.getQueryName(), storedQuery.getQueryName(), "");
                this.addCategory(queryCollection, "query", "StoredQuery");
            }
        }
        catch (ArtificerException e) {
            LOGGER.error(Messages.i18n.format("ERROR_GETTING_STOREDQUERIES", new Object[0]), (Throwable)e);
        }
    }
}

