/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.server.mvn.services;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.artificer.common.ArtifactType;
import org.artificer.common.ArtificerConfig;
import org.artificer.common.ArtificerModelUtils;
import org.artificer.common.maven.MavenGavInfo;
import org.artificer.common.maven.MavenUtil;
import org.artificer.server.ArtifactServiceImpl;
import org.artificer.server.QueryServiceImpl;
import org.artificer.server.i18n.Messages;
import org.artificer.server.mvn.services.MavenRepositoryException;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenFacadeServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenFacadeServlet.class);
    private static final boolean SNAPSHOT_ALLOWED = ArtificerConfig.isSnapshotAllowed();
    private final ArtifactServiceImpl artifactService = new ArtifactServiceImpl();
    private final QueryServiceImpl queryService = new QueryServiceImpl();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            MavenGavInfo gavInfo = MavenGavInfo.fromUrl((String)req.getRequestURI());
            if (gavInfo.isMavenMetaData() && gavInfo.getVersion() == null) {
                this.writeResponse(this.doGenerateArtifactDirMavenMetaData(gavInfo), gavInfo, resp);
            } else if (gavInfo.isMavenMetaData() && gavInfo.getVersion() != null) {
                this.writeResponse(this.doGenerateSnapshotMavenMetaData(gavInfo), gavInfo, resp);
            } else if (gavInfo.isHash()) {
                this.writeResponse(this.doGetHash(gavInfo, req), gavInfo, resp);
            } else {
                this.writeResponse(this.findExistingArtifact(gavInfo), gavInfo, resp);
            }
        }
        catch (MavenRepositoryException e) {
            LOGGER.warn(Messages.i18n.format("MAVEN_GET_ERROR", new Object[0]), (Throwable)((Object)e));
            resp.sendError(400, e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error(Messages.i18n.format("MAVEN_GET_ERROR", new Object[0]), (Throwable)e);
            resp.sendError(500, e.getMessage());
        }
    }

    private void writeResponse(String rval, MavenGavInfo gavInfo, HttpServletResponse resp) throws Exception {
        if (rval != null) {
            resp.addHeader("Content-Disposition", "attachment; filename=" + gavInfo.getName());
            resp.getWriter().write(rval);
            resp.getWriter().flush();
            resp.getWriter().close();
        }
    }

    private void writeResponse(BaseArtifactType artifact, MavenGavInfo gavInfo, HttpServletResponse resp) throws Exception {
        if (artifact != null) {
            ArtifactType artifactType = ArtifactType.valueOf((BaseArtifactType)artifact);
            resp.setContentType(artifactType.getMimeType());
            resp.addHeader("Content-Disposition", "attachment; filename=" + gavInfo.getName());
            IOUtils.copy((InputStream)this.artifactService.getContent(artifactType, artifact), (OutputStream)resp.getOutputStream());
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            MavenGavInfo gavInfo = MavenGavInfo.fromUrl((String)req.getRequestURI());
            this.upload(gavInfo, req);
        }
        catch (MavenRepositoryException e) {
            LOGGER.warn(Messages.i18n.format("MAVEN_UPLOAD_ERROR", new Object[0]), (Throwable)((Object)e));
            resp.sendError(400, e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error(Messages.i18n.format("MAVEN_UPLOAD_ERROR", new Object[0]), (Throwable)e);
            resp.sendError(500, e.getMessage());
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            MavenGavInfo gavInfo = MavenGavInfo.fromUrl((String)req.getRequestURI());
            this.upload(gavInfo, req);
        }
        catch (MavenRepositoryException e) {
            LOGGER.warn(Messages.i18n.format("MAVEN_UPLOAD_ERROR", new Object[0]), (Throwable)((Object)e));
            resp.sendError(400, e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error(Messages.i18n.format("MAVEN_UPLOAD_ERROR", new Object[0]), (Throwable)e);
            resp.sendError(500, e.getMessage());
        }
    }

    private String doGenerateArtifactDirMavenMetaData(MavenGavInfo gavInfo) throws Exception {
        List<BaseArtifactType> artifacts = this.queryService.query("/s-ramp[@maven.groupId = '" + gavInfo.getGroupId() + "' and @maven.artifactId = '" + gavInfo.getArtifactId() + "']", "createdTimestamp", true);
        if (artifacts.size() == 0) {
            return null;
        }
        String groupId = gavInfo.getGroupId();
        String artifactId = gavInfo.getArtifactId();
        String latest = null;
        String release = null;
        String lastUpdated = null;
        LinkedHashSet<String> versions = new LinkedHashSet<String>();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        for (BaseArtifactType artifact : artifacts) {
            String version = ArtificerModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"maven.version");
            if (versions.add(version)) {
                latest = version;
                if (!version.endsWith("-SNAPSHOT")) {
                    release = version;
                }
            }
            lastUpdated = format.format(artifact.getCreatedTimestamp().toGregorianCalendar().getTime());
        }
        StringBuilder mavenMetadata = new StringBuilder();
        mavenMetadata.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        mavenMetadata.append("<metadata>\n");
        mavenMetadata.append("  <groupId>").append(groupId).append("</groupId>\n");
        mavenMetadata.append("  <artifactId>").append(artifactId).append("</artifactId>\n");
        mavenMetadata.append("  <versioning>\n");
        mavenMetadata.append("    <latest>").append(latest).append("</latest>\n");
        mavenMetadata.append("    <release>").append(release).append("</release>\n");
        mavenMetadata.append("    <versions>\n");
        for (String version : versions) {
            mavenMetadata.append("      <version>").append(version).append("</version>\n");
        }
        mavenMetadata.append("    </versions>\n");
        mavenMetadata.append("    <lastUpdated>").append(lastUpdated).append("</lastUpdated>\n");
        mavenMetadata.append("  </versioning>\n");
        mavenMetadata.append("</metadata>\n");
        if (!gavInfo.isHash()) {
            return mavenMetadata.toString();
        }
        return this.generateHash(mavenMetadata.toString(), gavInfo.getHashAlgorithm());
    }

    private String doGenerateSnapshotMavenMetaData(MavenGavInfo gavInfo) throws Exception {
        List<BaseArtifactType> artifacts = this.queryService.query("/s-ramp[@maven.groupId = '" + gavInfo.getGroupId() + "'" + " and @maven.artifactId = '" + gavInfo.getArtifactId() + "'" + " and @maven.version = '" + gavInfo.getVersion() + "']", "createdTimestamp", true);
        if (artifacts.size() == 0) {
            return null;
        }
        SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyyMMdd.HHmmss");
        SimpleDateFormat updatedFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        StringBuilder snapshotVersions = new StringBuilder();
        snapshotVersions.append("    <snapshotVersions>\n");
        HashSet<String> processed = new HashSet<String>();
        Calendar latestDate = null;
        for (BaseArtifactType artifact : artifacts) {
            String extension = ArtificerModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"maven.type");
            String classifier = ArtificerModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"maven.classifier");
            String value = gavInfo.getVersion();
            GregorianCalendar updatedDate = artifact.getLastModifiedTimestamp().toGregorianCalendar();
            String updated = updatedFormat.format(updatedDate.getTime());
            String pkey = classifier + "::" + extension;
            if (!processed.add(pkey)) continue;
            snapshotVersions.append("      <snapshotVersion>\n");
            if (classifier != null) {
                snapshotVersions.append("        <classifier>").append(classifier).append("</classifier>\n");
            }
            snapshotVersions.append("        <extension>").append(extension).append("</extension>\n");
            snapshotVersions.append("        <value>").append(value).append("</value>\n");
            snapshotVersions.append("        <updated>").append(updated).append("</updated>\n");
            snapshotVersions.append("      </snapshotVersion>\n");
            if (latestDate != null && !latestDate.before(updatedDate)) continue;
            latestDate = updatedDate;
        }
        snapshotVersions.append("    </snapshotVersions>\n");
        String groupId = gavInfo.getGroupId();
        String artifactId = gavInfo.getArtifactId();
        String version = gavInfo.getVersion();
        String lastUpdated = updatedFormat.format(latestDate.getTime());
        StringBuilder mavenMetadata = new StringBuilder();
        mavenMetadata.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        mavenMetadata.append("<metadata>\n");
        mavenMetadata.append("  <groupId>").append(groupId).append("</groupId>\n");
        mavenMetadata.append("  <artifactId>").append(artifactId).append("</artifactId>\n");
        mavenMetadata.append("  <version>").append(version).append("</version>\n");
        mavenMetadata.append("  <versioning>\n");
        mavenMetadata.append("    <snapshot>\n");
        mavenMetadata.append("      <timestamp>").append(timestampFormat.format(latestDate.getTime())).append("</timestamp>\n");
        mavenMetadata.append("      <buildNumber>1</buildNumber>\n");
        mavenMetadata.append("    </snapshot>\n");
        mavenMetadata.append("    <lastUpdated>").append(lastUpdated).append("</lastUpdated>\n");
        mavenMetadata.append(snapshotVersions.toString());
        mavenMetadata.append("  </versioning>\n");
        mavenMetadata.append("</metadata>\n");
        if (!gavInfo.isHash()) {
            return mavenMetadata.toString();
        }
        return this.generateHash(mavenMetadata.toString(), gavInfo.getHashAlgorithm());
    }

    private String doGetHash(MavenGavInfo gavInfo, HttpServletRequest req) throws Exception {
        String hashPropName;
        int hashExtensionLength;
        if (gavInfo.getType().endsWith(".md5")) {
            hashExtensionLength = 4;
            hashPropName = "maven.hash.md5";
        } else {
            hashExtensionLength = 5;
            hashPropName = "maven.hash.sha1";
        }
        MavenGavInfo primaryGavInfo = this.gavWithoutHash(req, hashExtensionLength);
        BaseArtifactType artifact = this.findExistingArtifact(primaryGavInfo);
        if (artifact == null) {
            return null;
        }
        return ArtificerModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)hashPropName);
    }

    private BaseArtifactType findExistingArtifact(MavenGavInfo gavInfo) throws Exception {
        BaseArtifactType artifact = this.findExistingArtifactByGAV(gavInfo);
        if (artifact == null) {
            artifact = this.findExistingArtifactByUniversal(gavInfo);
        }
        return artifact;
    }

    private BaseArtifactType findExistingArtifactByGAV(MavenGavInfo gavInfo) throws Exception {
        String query = MavenUtil.gavQuery((MavenGavInfo)gavInfo);
        List<BaseArtifactType> artifacts = this.queryService.query(query, "createdTimestamp", false);
        if (artifacts.size() > 0) {
            for (BaseArtifactType artifact : artifacts) {
                if (gavInfo.getClassifier() == null) {
                    String artyClassifier = ArtificerModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"maven.classifier");
                    if (artyClassifier != null) continue;
                    return artifact;
                }
                return artifact;
            }
        }
        return null;
    }

    private BaseArtifactType findExistingArtifactByUniversal(MavenGavInfo gavInfo) throws Exception {
        String artifactType = gavInfo.getGroupId().substring(gavInfo.getGroupId().indexOf(46) + 1);
        String uuid = gavInfo.getArtifactId();
        try {
            return this.artifactService.getMetaData(ArtifactType.valueOf((String)artifactType, (boolean)true), uuid);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void upload(MavenGavInfo gavInfo, HttpServletRequest req) throws Exception {
        if (SNAPSHOT_ALLOWED || !gavInfo.isSnapshot()) {
            if (!gavInfo.getName().contains("maven-metadata.xml")) {
                if (gavInfo.isHash()) {
                    this.uploadHash(gavInfo, req);
                } else {
                    this.uploadArtifact(gavInfo, req);
                }
            }
        } else {
            throw new MavenRepositoryException(Messages.i18n.format("MAVEN_UPLOAD_SNAPSHOT", new Object[0]));
        }
    }

    private void uploadHash(MavenGavInfo gavInfo, HttpServletRequest req) throws Exception {
        String hashPropName;
        int hashExtensionLength;
        if (gavInfo.getType().endsWith(".md5")) {
            hashExtensionLength = 4;
            hashPropName = "maven.hash.md5";
        } else {
            hashExtensionLength = 5;
            hashPropName = "maven.hash.sha1";
        }
        String hashValue = IOUtils.toString((InputStream)req.getInputStream());
        MavenGavInfo primaryGavInfo = this.gavWithoutHash(req, hashExtensionLength);
        BaseArtifactType artifact = this.findExistingArtifactByGAV(primaryGavInfo);
        ArtificerModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)hashPropName, (String)hashValue);
        this.artifactService.updateMetaData(artifact);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void uploadArtifact(MavenGavInfo gavInfo, HttpServletRequest req) throws Exception {
        BaseArtifactType artifact = this.findExistingArtifactByGAV(gavInfo);
        if (artifact != null) {
            if (!gavInfo.isSnapshot()) throw new MavenRepositoryException(Messages.i18n.format("MAVEN_UPLOAD_ARTIFACT_EXISTS", new Object[0]));
            this.artifactService.updateContent(ArtifactType.valueOf((BaseArtifactType)artifact), artifact.getUuid(), gavInfo.getName(), (InputStream)req.getInputStream());
            this.updateGavProperties(gavInfo, artifact);
            return;
        } else {
            ArtifactType artifactType = this.getArtifactType(gavInfo, req);
            artifact = this.artifactService.upload(artifactType, gavInfo.getName(), (InputStream)req.getInputStream());
            this.updateGavProperties(gavInfo, artifact);
        }
    }

    private void updateGavProperties(MavenGavInfo gavInfo, BaseArtifactType artifact) throws Exception {
        ArtificerModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.groupId", (String)gavInfo.getGroupId());
        ArtificerModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.artifactId", (String)gavInfo.getArtifactId());
        ArtificerModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.version", (String)gavInfo.getVersion());
        artifact.setVersion(gavInfo.getVersion());
        if (gavInfo.getClassifier() != null) {
            ArtificerModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.classifier", (String)gavInfo.getClassifier());
        }
        if (gavInfo.getSnapshotId() != null && !gavInfo.getSnapshotId().equals("")) {
            ArtificerModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.snapshot.id", (String)gavInfo.getSnapshotId());
        }
        ArtificerModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.type", (String)gavInfo.getType());
        this.artifactService.updateMetaData(artifact);
    }

    private MavenGavInfo gavWithoutHash(HttpServletRequest req, int hashExtensionLength) {
        MavenGavInfo primaryGavInfo = MavenGavInfo.fromUrl((String)req.getRequestURI());
        primaryGavInfo.setType(primaryGavInfo.getType().substring(0, primaryGavInfo.getType().length() - hashExtensionLength));
        return primaryGavInfo;
    }

    private String generateHash(String string, String hashAlgorithm) throws Exception {
        InputStream inputStream = IOUtils.toInputStream((String)string);
        MessageDigest md = MessageDigest.getInstance(hashAlgorithm);
        byte[] dataBytes = new byte[1024];
        int nread = 0;
        while ((nread = inputStream.read(dataBytes)) != -1) {
            md.update(dataBytes, 0, nread);
        }
        byte[] mdbytes = md.digest();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < mdbytes.length; ++i) {
            sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    private ArtifactType getArtifactType(MavenGavInfo gavInfo, HttpServletRequest req) {
        String customAT = req.getParameter("artifactType");
        if (gavInfo.getType().equals("pom")) {
            return ArtifactType.valueOf((String)"MavenPom", (boolean)true);
        }
        if (this.isPrimaryArtifact(gavInfo) && customAT != null) {
            return ArtifactType.valueOf((String)customAT, (boolean)true);
        }
        return null;
    }

    private boolean isPrimaryArtifact(MavenGavInfo gavInfo) {
        return gavInfo.getClassifier() == null;
    }
}

