/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.server;

import javax.ejb.Remote;
import javax.ejb.Stateful;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import org.artificer.repository.AuditManager;
import org.artificer.repository.query.ArtificerQueryArgs;
import org.artificer.repository.query.PagedResult;
import org.artificer.server.AbstractServiceImpl;
import org.artificer.server.core.api.AuditService;
import org.jboss.downloads.artificer._2013.auditing.AuditEntry;

@Stateful(name="AuditService")
@Remote(value={AuditService.class})
@TransactionManagement(value=TransactionManagementType.BEAN)
public class AuditServiceImpl
extends AbstractServiceImpl
implements AuditService {
    public AuditEntry create(String artifactUuid, AuditEntry auditEntry) throws Exception {
        AuditManager auditManager = this.auditManager();
        return auditManager.addAuditEntry(artifactUuid, auditEntry);
    }

    public AuditEntry get(String artifactUuid, String auditEntryUuid) throws Exception {
        AuditManager auditManager = this.auditManager();
        return auditManager.getArtifactAuditEntry(artifactUuid, auditEntryUuid);
    }

    public PagedResult<AuditEntry> queryByArtifact(String artifactUuid) throws Exception {
        AuditManager auditManager = this.auditManager();
        return auditManager.getArtifactAuditEntries(artifactUuid, new ArtificerQueryArgs());
    }

    public PagedResult<AuditEntry> queryByArtifact(String artifactUuid, Integer startPage, Integer startIndex, Integer count) throws Exception {
        AuditManager auditManager = this.auditManager();
        ArtificerQueryArgs args = new ArtificerQueryArgs(startPage, startIndex, count);
        return auditManager.getArtifactAuditEntries(artifactUuid, args);
    }

    public PagedResult<AuditEntry> queryByUser(String username) throws Exception {
        AuditManager auditManager = this.auditManager();
        return auditManager.getUserAuditEntries(username, new ArtificerQueryArgs());
    }

    public PagedResult<AuditEntry> queryByUser(String username, Integer startPage, Integer startIndex, Integer count) throws Exception {
        AuditManager auditManager = this.auditManager();
        ArtificerQueryArgs args = new ArtificerQueryArgs(startPage, startIndex, count);
        return auditManager.getUserAuditEntries(username, args);
    }
}

