/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.server;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ejb.Remote;
import javax.ejb.Stateful;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import org.artificer.atom.archive.ArtificerArchive;
import org.artificer.atom.archive.ArtificerArchiveEntry;
import org.artificer.common.ArtifactContent;
import org.artificer.common.ArtifactType;
import org.artificer.common.ArtifactTypeEnum;
import org.artificer.common.ArtificerException;
import org.artificer.common.error.ArtificerNotFoundException;
import org.artificer.common.error.ArtificerUserException;
import org.artificer.repository.PersistenceManager;
import org.artificer.repository.RepositoryProviderFactory;
import org.artificer.server.AbstractServiceImpl;
import org.artificer.server.BatchCreate;
import org.artificer.server.core.api.BatchResult;
import org.artificer.server.core.api.BatchService;
import org.artificer.server.mime.MimeTypes;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DocumentArtifactType;

@Stateful(name="BatchService")
@Remote(value={BatchService.class})
@TransactionManagement(value=TransactionManagementType.BEAN)
public class BatchServiceImpl
extends AbstractServiceImpl
implements BatchService {
    public BatchResult upload(ArtificerArchive archive) throws Exception {
        BatchResult batchResult = new BatchResult();
        PersistenceManager persistenceManager = this.persistenceManager();
        Collection entries = archive.getEntries();
        BatchCreate batchCreates = new BatchCreate();
        ArrayList<ArtificerArchiveEntry> updates = new ArrayList<ArtificerArchiveEntry>();
        for (ArtificerArchiveEntry entry : entries) {
            String path = entry.getPath();
            BaseArtifactType metaData = entry.getMetaData();
            if (this.isCreate(metaData)) {
                String mimeType;
                ArtifactType artifactType = ArtifactType.valueOf((BaseArtifactType)metaData);
                InputStream entryIs = archive.getInputStream(entry);
                ArtifactContent entryContent = null;
                if (entryIs != null) {
                    entryContent = new ArtifactContent(path, archive.getInputStream(entry));
                    mimeType = MimeTypes.determineMimeType((String)metaData.getName(), (InputStream)entryContent.getInputStream(), (ArtifactType)artifactType);
                } else {
                    mimeType = MimeTypes.determineMimeType((String)metaData.getName(), null, (ArtifactType)artifactType);
                }
                if (artifactType.isDerived()) {
                    throw ArtificerUserException.derivedArtifactCreate((ArtifactTypeEnum)artifactType.getArtifactType());
                }
                artifactType.setMimeType(mimeType);
                if (metaData instanceof DocumentArtifactType) {
                    ((DocumentArtifactType)metaData).setContentType(mimeType);
                }
                batchCreates.add(metaData, entryContent, entry.getPath());
                continue;
            }
            updates.add(entry);
        }
        List createItems = batchCreates.getBatchItems();
        List batchResponses = batchCreates.execute(persistenceManager);
        for (int i = 0; i < createItems.size(); ++i) {
            PersistenceManager.BatchItem bi = (PersistenceManager.BatchItem)createItems.get(i);
            Object response = batchResponses.get(i);
            if (response instanceof BaseArtifactType) {
                BaseArtifactType artifact = (BaseArtifactType)response;
                batchResult.getCreates().put(bi.batchItemId, artifact);
                continue;
            }
            if (!(response instanceof Exception)) continue;
            batchResult.getErrors().put(bi.batchItemId, (Exception)response);
        }
        batchCreates.cleanup();
        for (ArtificerArchiveEntry updateEntry : updates) {
            String path = updateEntry.getPath();
            String contentId = String.format("<%1$s@package>", path);
            BaseArtifactType metaData = updateEntry.getMetaData();
            ArtifactType artifactType = ArtifactType.valueOf((BaseArtifactType)metaData);
            metaData = this.processUpdate(artifactType, metaData);
            batchResult.getUpdates().put(contentId, metaData);
        }
        return batchResult;
    }

    private boolean isCreate(BaseArtifactType metaData) {
        if (metaData.getUuid() == null) {
            return true;
        }
        return !this.artifactExists(metaData);
    }

    private boolean artifactExists(BaseArtifactType metaData) {
        try {
            PersistenceManager persistenceManager = RepositoryProviderFactory.persistenceManager();
            ArtifactType artifactType = ArtifactType.valueOf((BaseArtifactType)metaData);
            BaseArtifactType artifact = persistenceManager.getArtifact(metaData.getUuid(), artifactType);
            return artifact != null;
        }
        catch (ArtificerException e) {
            return false;
        }
    }

    private BaseArtifactType processUpdate(ArtifactType artifactType, BaseArtifactType metaData) throws Exception {
        PersistenceManager persistenceManager = RepositoryProviderFactory.persistenceManager();
        BaseArtifactType artifact = persistenceManager.getArtifact(metaData.getUuid(), artifactType);
        if (artifact == null) {
            throw ArtificerNotFoundException.artifactNotFound((String)metaData.getUuid());
        }
        persistenceManager.updateArtifact(metaData, artifactType);
        artifact = persistenceManager.getArtifact(metaData.getUuid(), artifactType);
        return artifact;
    }
}

