/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.server;

import java.util.List;
import javax.ejb.Remote;
import javax.ejb.Stateful;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import org.artificer.common.query.ArtifactSummary;
import org.artificer.common.query.ReverseRelationship;
import org.artificer.repository.query.ArtificerQuery;
import org.artificer.repository.query.ArtificerQueryArgs;
import org.artificer.repository.query.PagedResult;
import org.artificer.server.AbstractServiceImpl;
import org.artificer.server.core.api.QueryService;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.StoredQuery;

@Stateful(name="QueryService")
@Remote(value={QueryService.class})
@TransactionManagement(value=TransactionManagementType.BEAN)
public class QueryServiceImpl
extends AbstractServiceImpl
implements QueryService {
    public PagedResult<ArtifactSummary> query(String query) throws Exception {
        return this.query(query, "name", Boolean.valueOf(true));
    }

    public PagedResult<ArtifactSummary> query(String query, String orderBy, Boolean ascending) throws Exception {
        String xpath = query;
        if (!xpath.startsWith("/s-ramp")) {
            xpath = query.startsWith("/") ? "/s-ramp" + query : "/s-ramp/" + query;
        }
        ArtificerQueryArgs args = new ArtificerQueryArgs(orderBy, ascending);
        ArtificerQuery artificerQuery = this.queryManager().createQuery(xpath, args);
        return artificerQuery.executeQuery();
    }

    public PagedResult<ArtifactSummary> query(String query, Integer startPage, Integer startIndex, Integer count, String orderBy, Boolean ascending) throws Exception {
        String xpath = query;
        if (!xpath.startsWith("/s-ramp")) {
            xpath = query.startsWith("/") ? "/s-ramp" + query : "/s-ramp/" + query;
        }
        ArtificerQueryArgs args = new ArtificerQueryArgs(orderBy, ascending, startPage, startIndex, count);
        ArtificerQuery artificerQuery = this.queryManager().createQuery(xpath, args);
        return artificerQuery.executeQuery();
    }

    public StoredQuery createStoredQuery(StoredQuery storedQuery) throws Exception {
        return this.persistenceManager().persistStoredQuery(storedQuery);
    }

    public void updateStoredQuery(String queryName, StoredQuery storedQuery) throws Exception {
        this.persistenceManager().updateStoredQuery(queryName, storedQuery);
    }

    public StoredQuery getStoredQuery(String queryName) throws Exception {
        return this.persistenceManager().getStoredQuery(queryName);
    }

    public List<StoredQuery> getStoredQueries() throws Exception {
        return this.persistenceManager().getStoredQueries();
    }

    public void deleteStoredQuery(String queryName) throws Exception {
        this.persistenceManager().deleteStoredQuery(queryName);
    }

    public List<ReverseRelationship> reverseRelationships(String uuid) throws Exception {
        return this.queryManager().reverseRelationships(uuid);
    }
}

