/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.demos.classifications;

import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.artificer.client.ArtificerAtomApiClient;
import org.artificer.client.ontology.OntologySummary;
import org.artificer.client.query.ArtifactSummary;
import org.artificer.client.query.QueryResultSet;
import org.artificer.common.ArtifactType;
import org.artificer.common.ArtificerModelUtils;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;

public class ClassificationDemo {
    private static final String DEFAULT_ENDPOINT = "http://localhost:8080/artificer-server";
    private static final String DEFAULT_USER = "admin";
    private static final String DEFAULT_PASSWORD = "artificer1!";

    public static void main(String[] args) throws Exception {
        System.out.println("\n*** Running Artificer Classification Demo ***\n");
        String endpoint = System.getProperty("artificer.endpoint");
        String username = System.getProperty("artificer.auth.username");
        String password = System.getProperty("artificer.auth.password");
        if (endpoint == null || endpoint.trim().length() == 0) {
            endpoint = DEFAULT_ENDPOINT;
        }
        if (username == null || username.trim().length() == 0) {
            username = DEFAULT_USER;
        }
        if (password == null || password.trim().length() == 0) {
            password = DEFAULT_PASSWORD;
        }
        System.out.println("Artificer Endpoint: " + endpoint);
        System.out.println("Artificer User: " + username);
        ArtificerAtomApiClient client = new ArtificerAtomApiClient(endpoint, username, password, true);
        QueryResultSet rs = client.buildQuery("/s-ramp[@from-demo = ?]").parameter(ClassificationDemo.class.getSimpleName()).count(1).query();
        if (rs.size() > 0L) {
            System.out.println("It looks like you already ran this demo!");
            System.out.println("I'm going to quit, because I don't want to clutter up");
            System.out.println("your repository with duplicate stuff.");
            System.exit(1);
        }
        System.out.println("Installing 'regions.owl' ontology.");
        ClassificationDemo.installRegionsOntology(client);
        InputStream content = ClassificationDemo.class.getResourceAsStream("classifications-demo-doc-1.txt");
        ArtifactType type = ArtifactType.valueOf((String)"Document");
        BaseArtifactType metaData = client.uploadArtifact(type, content, "classifications-demo-doc-1.txt");
        String artifact1UUID = metaData.getUuid();
        System.out.println("Artifact 1 successfully added with UUID: " + metaData.getUuid());
        metaData.getClassifiedBy().add("http://www.example.org/regions.owl#Germany");
        ArtificerModelUtils.setCustomProperty((BaseArtifactType)metaData, (String)"from-demo", (String)ClassificationDemo.class.getSimpleName());
        client.updateArtifactMetaData(metaData);
        System.out.println("Artifact 1 successfully updated to add the #Germany classification.");
        BaseArtifactType artifact = client.getArtifactMetaData(type, metaData.getUuid());
        if (artifact.getClassifiedBy().isEmpty()) {
            System.out.println("Re-fetched the artifact but didn't find any classifications!  Uh oh, this is embarrassing.");
            System.exit(1);
        } else {
            System.out.printf("Re-fetched the artifact and found %1$d classifications.\n", artifact.getClassifiedBy().size());
            System.out.println("  Classification: " + (String)artifact.getClassifiedBy().get(0));
        }
        content = ClassificationDemo.class.getResourceAsStream("classifications-demo-doc-2.txt");
        metaData = client.uploadArtifact(type, content, "classifications-demo-doc-2.txt");
        System.out.println("Artifact 2 successfully added.");
        ArtificerModelUtils.setCustomProperty((BaseArtifactType)metaData, (String)"from-demo", (String)ClassificationDemo.class.getSimpleName());
        client.updateArtifactMetaData(metaData);
        System.out.println("-- Time to Query --");
        String q = "/s-ramp/core/Document";
        QueryResultSet resultSet = client.query(q);
        if (resultSet.size() >= 2L) {
            System.out.println("Great, we found at least two Document artifacts!");
        } else {
            System.out.println("Uh oh, we didn't find enough Document artifacts.  Something is terribly wrong.");
            System.exit(1);
        }
        q = "/s-ramp/core/Document[s-ramp:exactlyClassifiedByAnyOf(., 'http://www.example.org/regions.owl#Germany')]";
        resultSet = client.query(q);
        boolean found = false;
        for (ArtifactSummary artifactSummary : resultSet) {
            if (!artifactSummary.getUuid().equals(artifact1UUID)) continue;
            found = true;
            break;
        }
        if (found) {
            System.out.println("Artifact 1 was successfully found in the query result set!");
        } else {
            System.out.println("Aw crap, we didn't find Artifact 1...");
            System.exit(1);
        }
        System.out.println("\n*** Demo Completed Successfully ***\n\n");
        Thread.sleep(3000L);
    }

    private static void installRegionsOntology(ArtificerAtomApiClient client) throws Exception {
        boolean alreadyExists = false;
        List ontologies = client.getOntologies();
        for (OntologySummary ontology : ontologies) {
            if (!"http://www.example.org/regions.owl".equals(ontology.getBase())) continue;
            alreadyExists = true;
            break;
        }
        if (!alreadyExists) {
            InputStream resourceAsStream = ClassificationDemo.class.getResourceAsStream("regions.owl.xml");
            client.uploadOntology(resourceAsStream);
            IOUtils.closeQuietly((InputStream)resourceAsStream);
            System.out.println("The 'regions.owl' ontology has been installed.");
        } else {
            System.out.println("The 'regions.owl' ontology was already installed (ok!).");
        }
    }
}

