/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.demos.artifactbuilder;

import java.io.IOException;
import java.util.Collection;
import java.util.UUID;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.artificer.common.ArtificerModelUtils;
import org.artificer.common.query.xpath.StaticNamespaceContext;
import org.artificer.demos.artifactbuilder.WebXmlArtifactCollection;
import org.artificer.integration.artifactbuilder.XmlArtifactBuilder;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedArtifactType;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WebXmlArtifactBuilder
extends XmlArtifactBuilder {
    private final WebXmlArtifactCollection derivedArtifacts = new WebXmlArtifactCollection();

    protected void configureNamespaceMappings(StaticNamespaceContext namespaceContext) {
        super.configureNamespaceMappings(namespaceContext);
        namespaceContext.addMapping("jee", "http://java.sun.com/xml/ns/javaee");
    }

    public Collection<BaseArtifactType> getDerivedArtifacts() {
        return this.derivedArtifacts;
    }

    protected void derive() throws IOException {
        try {
            String displayName = (String)this.query(this.rootElement, "string(./jee:display-name)", XPathConstants.STRING);
            if (displayName != null && displayName.trim().length() > 0) {
                this.getPrimaryArtifact().setName(displayName);
            }
            this.processListeners();
            this.processFilters();
            this.processFilterMappings();
            this.processServlets();
            this.processServletMappings();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void processListeners() throws XPathExpressionException {
        NodeList nodes = (NodeList)this.query(this.rootElement, "./jee:listener", XPathConstants.NODESET);
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Element node = (Element)nodes.item(idx);
            ExtendedArtifactType listener = new ExtendedArtifactType();
            listener.setArtifactType(BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE);
            listener.setUuid(UUID.randomUUID().toString());
            listener.setExtendedType("ListenerDeclaration");
            String listenerClass = (String)this.query(node, "string(./jee:listener-class)", XPathConstants.STRING);
            String displayName = (String)this.query(node, "string(./jee:display-name)", XPathConstants.STRING);
            if (displayName == null || displayName.trim().length() == 0) {
                displayName = listenerClass;
            }
            listener.setName(displayName);
            String description = (String)this.query(node, "string(./jee:description)", XPathConstants.STRING);
            if (description != null && description.trim().length() > 0) {
                listener.setDescription(description);
            }
            ArtificerModelUtils.setCustomProperty((BaseArtifactType)listener, (String)"listener-class", (String)listenerClass);
            this.derivedArtifacts.add((BaseArtifactType)listener);
        }
    }

    private void processFilters() throws XPathExpressionException {
        NodeList nodes = (NodeList)this.query(this.rootElement, "./jee:filter", XPathConstants.NODESET);
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            String description;
            Element node = (Element)nodes.item(idx);
            ExtendedArtifactType filter = new ExtendedArtifactType();
            filter.setArtifactType(BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE);
            filter.setUuid(UUID.randomUUID().toString());
            filter.setExtendedType("FilterDeclaration");
            String filterClass = (String)this.query(node, "string(./jee:listener-class)", XPathConstants.STRING);
            String filterName = (String)this.query(node, "string(./jee:filter-name)", XPathConstants.STRING);
            String displayName = (String)this.query(node, "string(./jee:display-name)", XPathConstants.STRING);
            if (displayName == null || displayName.trim().length() == 0) {
                displayName = filterClass;
            }
            if ((description = (String)this.query(node, "string(./jee:description)", XPathConstants.STRING)) != null && description.trim().length() > 0) {
                description = null;
            }
            filter.setName(filterName);
            filter.setDescription(description);
            ArtificerModelUtils.setCustomProperty((BaseArtifactType)filter, (String)"display-name", (String)displayName);
            ArtificerModelUtils.setCustomProperty((BaseArtifactType)filter, (String)"filter-class", (String)filterClass);
            this.derivedArtifacts.add((BaseArtifactType)filter);
        }
    }

    private void processFilterMappings() throws XPathExpressionException {
        NodeList nodes = (NodeList)this.query(this.rootElement, "./jee:filter-mapping", XPathConstants.NODESET);
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Element node = (Element)nodes.item(idx);
            ExtendedArtifactType filterMapping = new ExtendedArtifactType();
            filterMapping.setArtifactType(BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE);
            filterMapping.setUuid(UUID.randomUUID().toString());
            filterMapping.setExtendedType("FilterMapping");
            String filterName = (String)this.query(node, "string(./jee:filter-name)", XPathConstants.STRING);
            String urlPattern = (String)this.query(node, "string(./jee:url-pattern)", XPathConstants.STRING);
            filterMapping.setName(filterName + " Mapping");
            filterMapping.setDescription("Maps URLs of the form '" + urlPattern + "' to filter " + filterName + ".");
            ArtificerModelUtils.setCustomProperty((BaseArtifactType)filterMapping, (String)"filter-name", (String)filterName);
            ArtificerModelUtils.setCustomProperty((BaseArtifactType)filterMapping, (String)"url-pattern", (String)urlPattern);
            WebXmlArtifactCollection index = this.derivedArtifacts;
            ExtendedArtifactType filter = index.lookupFilter(filterName);
            if (filter != null) {
                ArtificerModelUtils.addGenericRelationship((BaseArtifactType)filterMapping, (String)"mapsFilter", (String)filter.getUuid());
            }
            this.derivedArtifacts.add((BaseArtifactType)filterMapping);
        }
    }

    private void processServlets() throws XPathExpressionException {
        NodeList nodes = (NodeList)this.query(this.rootElement, "./jee:servlet", XPathConstants.NODESET);
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            String description;
            Element node = (Element)nodes.item(idx);
            ExtendedArtifactType servlet = new ExtendedArtifactType();
            servlet.setArtifactType(BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE);
            servlet.setUuid(UUID.randomUUID().toString());
            servlet.setExtendedType("ServletDeclaration");
            String servletClass = (String)this.query(node, "string(./jee:listener-class)", XPathConstants.STRING);
            String servletName = (String)this.query(node, "string(./jee:servlet-name)", XPathConstants.STRING);
            String displayName = (String)this.query(node, "string(./jee:display-name)", XPathConstants.STRING);
            if (displayName == null || displayName.trim().length() == 0) {
                displayName = servletClass;
            }
            if ((description = (String)this.query(node, "string(./jee:description)", XPathConstants.STRING)) != null && description.trim().length() > 0) {
                description = null;
            }
            servlet.setName(servletName);
            servlet.setDescription(description);
            ArtificerModelUtils.setCustomProperty((BaseArtifactType)servlet, (String)"display-name", (String)displayName);
            ArtificerModelUtils.setCustomProperty((BaseArtifactType)servlet, (String)"servlet-class", (String)servletClass);
            this.derivedArtifacts.add((BaseArtifactType)servlet);
        }
    }

    private void processServletMappings() throws XPathExpressionException {
        NodeList nodes = (NodeList)this.query(this.rootElement, "./jee:servlet-mapping", XPathConstants.NODESET);
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Element node = (Element)nodes.item(idx);
            ExtendedArtifactType servletMapping = new ExtendedArtifactType();
            servletMapping.setArtifactType(BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE);
            servletMapping.setUuid(UUID.randomUUID().toString());
            servletMapping.setExtendedType("ServletMapping");
            String servletName = (String)this.query(node, "string(./jee:servlet-name)", XPathConstants.STRING);
            String urlPattern = (String)this.query(node, "string(./jee:url-pattern)", XPathConstants.STRING);
            servletMapping.setName(servletName + " Mapping");
            servletMapping.setDescription("Maps URLs of the form '" + urlPattern + "' to servlet " + servletName + ".");
            ArtificerModelUtils.setCustomProperty((BaseArtifactType)servletMapping, (String)"servlet-name", (String)servletName);
            ArtificerModelUtils.setCustomProperty((BaseArtifactType)servletMapping, (String)"url-pattern", (String)urlPattern);
            WebXmlArtifactCollection index = this.derivedArtifacts;
            ExtendedArtifactType servlet = index.lookupServlet(servletName);
            if (servlet != null) {
                ArtificerModelUtils.addGenericRelationship((BaseArtifactType)servletMapping, (String)"mapsServlet", (String)servlet.getUuid());
            }
            this.derivedArtifacts.add((BaseArtifactType)servletMapping);
        }
    }
}

