/*
 * Decompiled with CFR 0.152.
 */
package org.arvados.client.api.client;

import java.io.File;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.arvados.client.api.client.CountingRequestBody;
import org.arvados.client.api.client.ProgressListener;

public class CountingFileRequestBody
extends CountingRequestBody<File> {
    CountingFileRequestBody(File file, ProgressListener listener) {
        super(file, listener);
    }

    public long contentLength() {
        return ((File)this.requestBodyData).length();
    }

    public void writeTo(BufferedSink sink) {
        try (Source source = Okio.source((File)((File)this.requestBodyData));){
            long read;
            long total = 0L;
            while ((read = source.read(sink.buffer(), 2048L)) != -1L) {
                sink.flush();
                this.listener.updateProgress(total += read);
            }
        }
        catch (RuntimeException rethrown) {
            throw rethrown;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

