/*
 * Decompiled with CFR 0.152.
 */
package org.arvados.client.api.client;

import com.google.common.net.MediaType;
import okhttp3.RequestBody;
import org.arvados.client.api.client.ProgressListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class CountingRequestBody<T>
extends RequestBody {
    protected static final int SEGMENT_SIZE = 2048;
    protected static final okhttp3.MediaType CONTENT_BINARY = okhttp3.MediaType.parse((String)MediaType.OCTET_STREAM.toString());
    protected final ProgressListener listener;
    protected final T requestBodyData;

    CountingRequestBody(T file, ProgressListener listener) {
        this.requestBodyData = file;
        this.listener = listener;
    }

    public okhttp3.MediaType contentType() {
        return CONTENT_BINARY;
    }

    static class TransferData {
        private final Logger log = LoggerFactory.getLogger(TransferData.class);
        private int progressValue = 0;
        private long totalSize;

        TransferData(long totalSize) {
            this.totalSize = totalSize;
        }

        void updateTransferProgress(long transferred) {
            float progress = (float)transferred / (float)this.totalSize * 100.0f;
            if (this.progressValue != (int)progress) {
                this.progressValue = (int)progress;
                this.log.debug("{} / {} / {}%", new Object[]{transferred, this.totalSize, this.progressValue});
            }
        }
    }
}

