/*
 * Decompiled with CFR 0.152.
 */
package org.arvados.client.api.client;

import java.io.IOException;
import java.io.InputStream;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.arvados.client.api.client.CountingRequestBody;
import org.arvados.client.api.client.ProgressListener;

public class CountingStreamRequestBody
extends CountingRequestBody<InputStream> {
    CountingStreamRequestBody(InputStream inputStream, ProgressListener listener) {
        super(inputStream, listener);
    }

    public long contentLength() throws IOException {
        return ((InputStream)this.requestBodyData).available();
    }

    public void writeTo(BufferedSink sink) {
        try (Source source = Okio.source((InputStream)((InputStream)this.requestBodyData));){
            long read;
            long total = 0L;
            while ((read = source.read(sink.buffer(), 2048L)) != -1L) {
                sink.flush();
                this.listener.updateProgress(total += read);
            }
        }
        catch (RuntimeException rethrown) {
            throw rethrown;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

