/*
 * Decompiled with CFR 0.152.
 */
package org.arvados.client.api.client.factory;

import com.google.common.base.Suppliers;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import org.arvados.client.exception.ArvadosClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OkHttpClientFactory {
    public static final OkHttpClientFactory INSTANCE = new OkHttpClientFactory();
    private final Logger log = LoggerFactory.getLogger(OkHttpClientFactory.class);
    private final OkHttpClient clientSecure = new OkHttpClient();
    private final Supplier<OkHttpClient> clientUnsecure = Suppliers.memoize(this::getDefaultClientAcceptingAllCertificates);

    private OkHttpClientFactory() {
    }

    public OkHttpClient create(boolean apiHostInsecure) {
        return apiHostInsecure ? this.getDefaultUnsecureClient() : this.getDefaultClient();
    }

    public OkHttpClient getDefaultClient() {
        return this.clientSecure;
    }

    public OkHttpClient getDefaultUnsecureClient() {
        return this.clientUnsecure.get();
    }

    public OkHttpClient.Builder getDefaultClientBuilder() {
        return this.clientSecure.newBuilder();
    }

    public OkHttpClient.Builder getDefaultUnsecureClientBuilder() {
        return this.clientUnsecure.get().newBuilder();
    }

    private OkHttpClient getDefaultClientAcceptingAllCertificates() {
        this.log.warn("Creating unsafe OkHttpClient. All SSL certificates will be accepted.");
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{OkHttpClientFactory.createX509TrustManager()};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            OkHttpClient.Builder builder = this.clientSecure.newBuilder();
            builder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]);
            builder.hostnameVerifier((hostname, session) -> true);
            return builder.build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new ArvadosClientException("Error establishing SSL context", e);
        }
    }

    private static X509TrustManager createX509TrustManager() {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }
}

