/*
 * Decompiled with CFR 0.152.
 */
package org.arvados.client.logic.collection;

import com.google.common.base.Strings;

public class FileToken {
    private long filePosition;
    private long fileSize;
    private String fileName;
    private String path;

    public FileToken(String fileTokenInfo) {
        this.splitFileTokenInfo(fileTokenInfo);
    }

    public FileToken(String fileTokenInfo, String path) {
        this.splitFileTokenInfo(fileTokenInfo);
        this.path = path;
    }

    private void splitFileTokenInfo(String fileTokenInfo) {
        String[] tokenPieces = fileTokenInfo.split(":");
        this.filePosition = Long.parseLong(tokenPieces[0]);
        this.fileSize = Long.parseLong(tokenPieces[1]);
        this.fileName = tokenPieces[2].replace("\\040", " ");
    }

    public String toString() {
        return this.filePosition + ":" + this.fileSize + ":" + this.fileName;
    }

    public String getFullPath() {
        return Strings.isNullOrEmpty((String)this.path) ? this.fileName : this.path + this.fileName;
    }

    public long getFilePosition() {
        return this.filePosition;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPath() {
        return this.path;
    }
}

