/*
 * Decompiled with CFR 0.152.
 */
package org.arvados.client.logic.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.arvados.client.exception.ArvadosClientException;
import org.arvados.client.logic.collection.FileToken;
import org.arvados.client.logic.collection.ManifestStream;
import org.arvados.client.logic.keep.KeepLocator;

public class ManifestDecoder {
    public List<ManifestStream> decode(String manifestText) {
        if (manifestText == null || manifestText.isEmpty()) {
            throw new ArvadosClientException("Manifest text cannot be empty.");
        }
        ArrayList<String> manifestStreams = new ArrayList<String>(Arrays.asList(manifestText.split("\\n")));
        if (!((String)manifestStreams.get(0)).startsWith(". ")) {
            throw new ArvadosClientException("Invalid first path component (expecting \".\")");
        }
        return manifestStreams.stream().map(this::decodeSingleManifestStream).collect(Collectors.toList());
    }

    private ManifestStream decodeSingleManifestStream(String manifestStream) {
        Objects.requireNonNull(manifestStream, "Manifest stream cannot be empty.");
        LinkedList<String> manifestPieces = new LinkedList<String>(Arrays.asList(manifestStream.split("\\s+")));
        String streamName = manifestPieces.poll();
        String path = ".".equals(streamName) ? "" : streamName.substring(2).concat("/");
        List<KeepLocator> keepLocators = manifestPieces.stream().filter(p -> p.matches("([0-9a-f]{32})\\+([0-9]+)(\\+[A-Z][-A-Za-z0-9@_]*)*")).map(this::getKeepLocator).collect(Collectors.toList());
        List<FileToken> fileTokens = manifestPieces.stream().skip(keepLocators.size()).filter(p -> p.matches("(\\d+:\\d+:\\S+)")).map(p -> new FileToken((String)p, path)).collect(Collectors.toList());
        return new ManifestStream(streamName, keepLocators, fileTokens);
    }

    private KeepLocator getKeepLocator(String locatorString) {
        try {
            return new KeepLocator(locatorString);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

