/*
 * Decompiled with CFR 0.152.
 */
package org.arvados.client.logic.collection;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class ManifestFactory {
    private Collection<File> files;
    private List<String> locators;

    ManifestFactory(Collection<File> files, List<String> locators) {
        this.files = files;
        this.locators = locators;
    }

    public static ManifestFactoryBuilder builder() {
        return new ManifestFactoryBuilder();
    }

    public String create() {
        ImmutableList.Builder builder = new ImmutableList.Builder().add((Object)".").addAll(this.locators);
        long filePosition = 0L;
        for (File file : this.files) {
            builder.add((Object)String.format("%d:%d:%s", filePosition, file.length(), file.getName().replace(" ", "\\040")));
            filePosition += file.length();
        }
        String manifest = builder.build().stream().collect(Collectors.joining(" ")).concat("\n");
        return manifest;
    }

    public static class ManifestFactoryBuilder {
        private Collection<File> files;
        private List<String> locators;

        ManifestFactoryBuilder() {
        }

        public ManifestFactoryBuilder files(Collection<File> files) {
            this.files = files;
            return this;
        }

        public ManifestFactoryBuilder locators(List<String> locators) {
            this.locators = locators;
            return this;
        }

        public ManifestFactory build() {
            return new ManifestFactory(this.files, this.locators);
        }
    }
}

