/*
 * Decompiled with CFR 0.152.
 */
package org.arvados.client.logic.keep;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.arvados.client.api.client.CollectionsApiClient;
import org.arvados.client.api.model.Collection;
import org.arvados.client.config.ConfigProvider;
import org.arvados.client.exception.ArvadosClientException;
import org.arvados.client.logic.collection.CollectionFactory;
import org.arvados.client.logic.keep.KeepClient;
import org.arvados.client.utils.FileMerge;
import org.arvados.client.utils.FileSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploader {
    private final KeepClient keepClient;
    private final CollectionsApiClient collectionsApiClient;
    private final ConfigProvider config;
    private final Logger log = LoggerFactory.getLogger(FileUploader.class);

    public FileUploader(KeepClient keepClient, CollectionsApiClient collectionsApiClient, ConfigProvider config) {
        this.keepClient = keepClient;
        this.collectionsApiClient = collectionsApiClient;
        this.config = config;
    }

    public Collection upload(List<File> sourceFiles, String collectionName, String projectUuid) {
        List<String> locators = this.uploadToKeep(sourceFiles);
        CollectionFactory collectionFactory = CollectionFactory.builder().config(this.config).name(collectionName).projectUuid(projectUuid).manifestFiles(sourceFiles).manifestLocators(locators).build();
        Collection newCollection = collectionFactory.create();
        return this.collectionsApiClient.create(newCollection);
    }

    public Collection uploadToExistingCollection(List<File> files, String collectionUuid) {
        List<String> locators = this.uploadToKeep(files);
        Collection collectionBeforeUpload = (Collection)this.collectionsApiClient.get(collectionUuid);
        String oldManifest = collectionBeforeUpload.getManifestText();
        CollectionFactory collectionFactory = CollectionFactory.builder().config(this.config).manifestFiles(files).manifestLocators(locators).build();
        String newPartOfManifestText = collectionFactory.create().getManifestText();
        String newManifest = oldManifest + newPartOfManifestText;
        collectionBeforeUpload.setManifestText(newManifest);
        return this.collectionsApiClient.update(collectionBeforeUpload);
    }

    private List<String> uploadToKeep(List<File> files) {
        List<File> chunks;
        File targetDir = this.config.getFileSplitDirectory();
        File combinedFile = new File(targetDir.getAbsolutePath() + "/" + UUID.randomUUID());
        try {
            FileMerge.merge(files, combinedFile);
            chunks = FileSplit.split(combinedFile, targetDir, this.config.getFileSplitSize());
        }
        catch (IOException e) {
            throw new ArvadosClientException("Cannot create file chunks for upload", e);
        }
        combinedFile.delete();
        int copies = this.config.getNumberOfCopies();
        int numRetries = this.config.getNumberOfRetries();
        ArrayList locators = Lists.newArrayList();
        for (File chunk : chunks) {
            try {
                locators.add(this.keepClient.put(chunk, copies, numRetries));
            }
            catch (ArvadosClientException e) {
                this.log.error("Problem occurred while uploading chunk file {}", (Object)chunk.getName(), (Object)e);
                throw e;
            }
        }
        return locators.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }
}

