/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@GwtCompatible
public final class Objects {
    private Objects() {
    }

    @CheckReturnValue
    public static boolean equal(@Nullable Object a, @Nullable Object b2) {
        return a == b2 || a != null && a.equals(b2);
    }

    @CheckReturnValue
    public static int hashCode(Object ... objects) {
        return Arrays.hashCode(objects);
    }

    @CheckReturnValue
    @Deprecated
    public static ToStringHelper toStringHelper(Object self2) {
        return new ToStringHelper(self2.getClass().getSimpleName());
    }

    @CheckReturnValue
    @Deprecated
    public static ToStringHelper toStringHelper(Class<?> clazz) {
        return new ToStringHelper(clazz.getSimpleName());
    }

    @CheckReturnValue
    @Deprecated
    public static ToStringHelper toStringHelper(String className) {
        return new ToStringHelper(className);
    }

    @CheckReturnValue
    @Deprecated
    public static <T> T firstNonNull(@Nullable T first2, @Nullable T second) {
        return MoreObjects.firstNonNull(first2, second);
    }

    @Deprecated
    public static final class ToStringHelper {
        private final String className;
        private ValueHolder holderHead;
        private ValueHolder holderTail;
        private boolean omitNullValues;

        private ToStringHelper(String className) {
            this.holderTail = this.holderHead = new ValueHolder();
            this.omitNullValues = false;
            this.className = Preconditions.checkNotNull(className);
        }

        public ToStringHelper omitNullValues() {
            this.omitNullValues = true;
            return this;
        }

        public ToStringHelper add(String name2, @Nullable Object value2) {
            return this.addHolder(name2, value2);
        }

        public ToStringHelper add(String name2, boolean value2) {
            return this.addHolder(name2, String.valueOf(value2));
        }

        public ToStringHelper add(String name2, char value2) {
            return this.addHolder(name2, String.valueOf(value2));
        }

        public ToStringHelper add(String name2, double value2) {
            return this.addHolder(name2, String.valueOf(value2));
        }

        public ToStringHelper add(String name2, float value2) {
            return this.addHolder(name2, String.valueOf(value2));
        }

        public ToStringHelper add(String name2, int value2) {
            return this.addHolder(name2, String.valueOf(value2));
        }

        public ToStringHelper add(String name2, long value2) {
            return this.addHolder(name2, String.valueOf(value2));
        }

        public ToStringHelper addValue(@Nullable Object value2) {
            return this.addHolder(value2);
        }

        public ToStringHelper addValue(boolean value2) {
            return this.addHolder(String.valueOf(value2));
        }

        public ToStringHelper addValue(char value2) {
            return this.addHolder(String.valueOf(value2));
        }

        public ToStringHelper addValue(double value2) {
            return this.addHolder(String.valueOf(value2));
        }

        public ToStringHelper addValue(float value2) {
            return this.addHolder(String.valueOf(value2));
        }

        public ToStringHelper addValue(int value2) {
            return this.addHolder(String.valueOf(value2));
        }

        public ToStringHelper addValue(long value2) {
            return this.addHolder(String.valueOf(value2));
        }

        public String toString() {
            boolean omitNullValuesSnapshot = this.omitNullValues;
            String nextSeparator = "";
            StringBuilder builder = new StringBuilder(32).append(this.className).append('{');
            ValueHolder valueHolder = this.holderHead.next;
            while (valueHolder != null) {
                if (!omitNullValuesSnapshot || valueHolder.value != null) {
                    builder.append(nextSeparator);
                    nextSeparator = ", ";
                    if (valueHolder.name != null) {
                        builder.append(valueHolder.name).append('=');
                    }
                    builder.append(valueHolder.value);
                }
                valueHolder = valueHolder.next;
            }
            return builder.append('}').toString();
        }

        private ValueHolder addHolder() {
            ValueHolder valueHolder;
            this.holderTail = this.holderTail.next = (valueHolder = new ValueHolder());
            return valueHolder;
        }

        private ToStringHelper addHolder(@Nullable Object value2) {
            ValueHolder valueHolder = this.addHolder();
            valueHolder.value = value2;
            return this;
        }

        private ToStringHelper addHolder(String name2, @Nullable Object value2) {
            ValueHolder valueHolder = this.addHolder();
            valueHolder.value = value2;
            valueHolder.name = Preconditions.checkNotNull(name2);
            return this;
        }

        private static final class ValueHolder {
            String name;
            Object value;
            ValueHolder next;

            private ValueHolder() {
            }
        }
    }
}

