/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.annotations.Beta;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import javax.annotation.Nullable;

@Beta
public abstract class AbstractInvocationHandler
implements InvocationHandler {
    private static final Object[] NO_ARGS = new Object[0];

    @Override
    public final Object invoke(Object proxy2, Method method2, @Nullable Object[] args2) throws Throwable {
        if (args2 == null) {
            args2 = NO_ARGS;
        }
        if (args2.length == 0 && method2.getName().equals("hashCode")) {
            return this.hashCode();
        }
        if (args2.length == 1 && method2.getName().equals("equals") && method2.getParameterTypes()[0] == Object.class) {
            Object arg2 = args2[0];
            if (arg2 == null) {
                return false;
            }
            if (proxy2 == arg2) {
                return true;
            }
            return AbstractInvocationHandler.isProxyOfSameInterfaces(arg2, proxy2.getClass()) && this.equals(Proxy.getInvocationHandler(arg2));
        }
        if (args2.length == 0 && method2.getName().equals("toString")) {
            return this.toString();
        }
        return this.handleInvocation(proxy2, method2, args2);
    }

    protected abstract Object handleInvocation(Object var1, Method var2, Object[] var3) throws Throwable;

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return super.toString();
    }

    private static boolean isProxyOfSameInterfaces(Object arg2, Class<?> proxyClass) {
        return proxyClass.isInstance(arg2) || Proxy.isProxyClass(arg2.getClass()) && Arrays.equals(arg2.getClass().getInterfaces(), proxyClass.getInterfaces());
    }
}

