/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.asciidoclet;

import com.google.common.base.Optional;
import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Tag;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Attributes;
import org.asciidoctor.AttributesBuilder;
import org.asciidoctor.Options;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.asciidoctor.asciidoclet.AttributesLoader;
import org.asciidoctor.asciidoclet.DocletOptions;
import org.asciidoctor.asciidoclet.DocletRenderer;
import org.asciidoctor.asciidoclet.OutputTemplates;

public class AsciidoctorRenderer
implements DocletRenderer {
    protected static final String INLINE_DOCTYPE = "inline";
    private final Asciidoctor asciidoctor;
    private final Optional<OutputTemplates> templates;
    private final Options options;

    private static AttributesBuilder defaultAttributes() {
        return AttributesBuilder.attributes().attribute("at", "&#64;").attribute("slash", "/").attribute("icons", null).attribute("idprefix", "").attribute("idseparator", "-").attribute("javadoc", "").attribute("showtitle", true).attribute("source-highlighter", "coderay").attribute("coderay-css", "class");
    }

    private static OptionsBuilder defaultOptions() {
        return OptionsBuilder.options().safe(SafeMode.SAFE).backend("html5");
    }

    public AsciidoctorRenderer(DocletOptions docletOptions, DocErrorReporter errorReporter) {
        this(docletOptions, errorReporter, OutputTemplates.create(errorReporter), Asciidoctor.Factory.create(docletOptions.gemPath()));
    }

    protected AsciidoctorRenderer(DocletOptions docletOptions, DocErrorReporter errorReporter, Optional<OutputTemplates> templates, Asciidoctor asciidoctor) {
        this.asciidoctor = asciidoctor;
        this.templates = templates;
        this.options = this.buildOptions(docletOptions, errorReporter);
    }

    private Options buildOptions(DocletOptions docletOptions, DocErrorReporter errorReporter) {
        OptionsBuilder opts = AsciidoctorRenderer.defaultOptions();
        if (docletOptions.baseDir().isPresent()) {
            opts.baseDir(docletOptions.baseDir().get());
        }
        if (this.templates.isPresent()) {
            opts.templateDir(this.templates.get().templateDir());
        }
        opts.attributes(this.buildAttributes(docletOptions, errorReporter));
        if (docletOptions.requires().size() > 0) {
            for (String require2 : docletOptions.requires()) {
                this.asciidoctor.rubyExtensionRegistry().requireLibrary(require2);
            }
        }
        return opts.get();
    }

    private Attributes buildAttributes(DocletOptions docletOptions, DocErrorReporter errorReporter) {
        return AsciidoctorRenderer.defaultAttributes().attributes(new AttributesLoader(this.asciidoctor, docletOptions, errorReporter).load()).get();
    }

    @Override
    public void renderDoc(Doc doc) {
        doc.setRawCommentText(doc.getRawCommentText().replaceAll("@([A-Z])", "{@literal @}$1"));
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.render(doc.commentText(), false));
        buffer.append('\n');
        for (Tag tag2 : doc.tags()) {
            this.renderTag(tag2, buffer);
            buffer.append('\n');
        }
        doc.setRawCommentText(buffer.toString());
    }

    public void cleanup() {
        if (this.templates.isPresent()) {
            this.templates.get().delete();
        }
    }

    private void renderTag(Tag tag2, StringBuilder buffer) {
        buffer.append(tag2.name()).append(' ');
        if (tag2 instanceof ParamTag && ((ParamTag)tag2).isTypeParameter()) {
            ParamTag paramTag = (ParamTag)tag2;
            buffer.append("<" + paramTag.parameterName() + ">");
            String text = paramTag.parameterComment();
            if (text.length() > 0) {
                buffer.append(' ').append(this.render(text, true));
            }
            return;
        }
        buffer.append(this.render(tag2.text(), true));
    }

    private String render(String input, boolean inline) {
        if (input.trim().isEmpty()) {
            return "";
        }
        this.options.setDocType(inline ? INLINE_DOCTYPE : null);
        return this.asciidoctor.render(AsciidoctorRenderer.cleanJavadocInput(input), this.options);
    }

    protected static String cleanJavadocInput(String input) {
        return input.trim().replaceAll("\n ", "\n").replaceAll("\\{at}", "&#64;").replaceAll("\\{slash}", "/").replaceAll("(?m)^( *)\\*\\\\/$", "$1*/").replaceAll("\\{@literal (.*?)}", "$1");
    }
}

