/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.asciidoclet;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.RootDoc;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import org.asciidoctor.asciidoclet.StandardAdapter;

public class DocletOptions {
    private static final Splitter COMMA_WS = Splitter.onPattern("\\s*,\\s*").omitEmptyStrings().trimResults();
    public static final String ENCODING = "-encoding";
    public static final String OVERVIEW = "-overview";
    public static final String BASEDIR = "--base-dir";
    public static final String STYLESHEET = "-stylesheetfile";
    public static final String DESTDIR = "-d";
    public static final String ATTRIBUTE = "-a";
    public static final String ATTRIBUTE_LONG = "--attribute";
    public static final String ATTRIBUTES_FILE = "--attributes-file";
    public static final String GEM_PATH = "--gem-path";
    public static final String REQUIRE = "-r";
    public static final String REQUIRE_LONG = "--require";
    public static final DocletOptions NONE = new DocletOptions(new String[0][]);
    private final Optional<File> basedir;
    private final Optional<File> overview;
    private final Optional<File> stylesheet;
    private final Optional<File> destdir;
    private final Optional<File> attributesFile;
    private final String gemPath;
    private final List<String> requires;
    private final Charset encoding;
    private final List<String> attributes;

    public DocletOptions(RootDoc rootDoc) {
        this(rootDoc.options());
    }

    public DocletOptions(String[][] options2) {
        File basedir = null;
        File overview = null;
        File stylesheet = null;
        File destdir = null;
        File attrsFile = null;
        String gemPath = null;
        ImmutableList.Builder requires = ImmutableList.builder();
        Charset encoding2 = Charset.defaultCharset();
        ImmutableList.Builder attrs = ImmutableList.builder();
        for (String[] option : options2) {
            if (option.length <= 0) continue;
            if (BASEDIR.equals(option[0])) {
                basedir = new File(option[1]);
                continue;
            }
            if (OVERVIEW.equals(option[0])) {
                overview = new File(option[1]);
                continue;
            }
            if (STYLESHEET.equals(option[0])) {
                stylesheet = new File(option[1]);
                continue;
            }
            if (DESTDIR.equals(option[0])) {
                destdir = new File(option[1]);
                continue;
            }
            if (ENCODING.equals(option[0])) {
                encoding2 = Charset.forName(option[1]);
                continue;
            }
            if (ATTRIBUTE.equals(option[0]) || ATTRIBUTE_LONG.equals(option[0])) {
                attrs.addAll(COMMA_WS.split(option[1]));
                continue;
            }
            if (ATTRIBUTES_FILE.equals(option[0])) {
                attrsFile = new File(option[1]);
                continue;
            }
            if (GEM_PATH.equals(option[0])) {
                gemPath = option[1];
                continue;
            }
            if (!REQUIRE.equals(option[0]) && !REQUIRE_LONG.equals(option[0])) continue;
            requires.addAll(COMMA_WS.split(option[1]));
        }
        this.basedir = Optional.fromNullable(basedir);
        this.overview = Optional.fromNullable(overview);
        this.stylesheet = Optional.fromNullable(stylesheet);
        this.destdir = Optional.fromNullable(destdir);
        this.encoding = encoding2;
        this.attributes = attrs.build();
        this.attributesFile = Optional.fromNullable(attrsFile);
        this.gemPath = gemPath;
        this.requires = requires.build();
    }

    public Optional<File> overview() {
        return this.overview;
    }

    public Optional<File> stylesheet() {
        return this.stylesheet;
    }

    public Optional<File> baseDir() {
        return this.basedir;
    }

    public Optional<File> destDir() {
        return this.destdir;
    }

    public Charset encoding() {
        return this.encoding;
    }

    public List<String> attributes() {
        return this.attributes;
    }

    Optional<File> attributesFile() {
        if (!this.attributesFile.isPresent()) {
            return this.attributesFile;
        }
        File f = this.attributesFile.get();
        if (!f.isAbsolute() && this.basedir.isPresent()) {
            f = new File(this.basedir.get(), f.getPath());
        }
        return Optional.of(f);
    }

    public String gemPath() {
        return this.gemPath;
    }

    public List<String> requires() {
        return this.requires;
    }

    public static boolean validOptions(String[][] options2, DocErrorReporter errorReporter, StandardAdapter standardDoclet) {
        Optional<File> attrsFile;
        DocletOptions docletOptions = new DocletOptions(options2);
        if (!docletOptions.baseDir().isPresent()) {
            errorReporter.printWarning("--base-dir must be present for includes or file reference features to work properly.");
        }
        if ((attrsFile = docletOptions.attributesFile()).isPresent() && !attrsFile.get().canRead()) {
            errorReporter.printWarning("Cannot read attributes file " + attrsFile.get());
        }
        return standardDoclet.validOptions(options2, errorReporter);
    }

    public static int optionLength(String option, StandardAdapter standardDoclet) {
        if (BASEDIR.equals(option)) {
            return 2;
        }
        if (ATTRIBUTE.equals(option) || ATTRIBUTE_LONG.equals(option)) {
            return 2;
        }
        if (ATTRIBUTES_FILE.equals(option)) {
            return 2;
        }
        if (GEM_PATH.equals(option)) {
            return 2;
        }
        if (REQUIRE.equals(option) || REQUIRE_LONG.equals(option)) {
            return 2;
        }
        return standardDoclet.optionLength(option);
    }
}

